#!/usr/bin/python

###########################################################################
# setup - description                                                     #
# ------------------------------                                          #
# begin     : Fri Jun 27 2003                                             #
# copyright : (C) 2003-2006 by Simon Edwards                              #
# email     : simon@simonzone.com                                         #
#                                                                         #
###########################################################################
#                                                                         #
#   This program is free software; you can redistribute it and/or modify  #
#   it under the terms of the GNU General Public License as published by  #
#   the Free Software Foundation; either version 2 of the License, or     #
#   (at your option) any later version.                                   #
#                                                                         #
###########################################################################


from distutils.core import Extension
import tdedistutils


def doit():
    tdedistutils.setup(
        name = "guidance",
        version = "0.8.0",
        author = "Simon Edwards",
        author_email = "simon@simonzone.com",
        url = "http://www.simonzone.com/software/guidance/",
        min_kde_version = "3.0.0",
        min_tqt_version = "3.0.0",
        license = "GPL",
        docbooks = [('doc/en','en')],
        package_dir = {'':'modules'},
        py_modules = ['xf86misc'],

        ext_modules = [Extension('ixf86misc',\
                       sources = ['modules/ixf86misc.c'],\
                       library_dirs = ['/usr/X11R6/lib'],\
                       libraries = ['X11','Xxf86vm','Xext','Xrandr','Xrender','Xss'])],

        executable_links = [('serviceconfig','serviceconfig.py'),
                            ('userconfig','userconfig.py'),
                            ('mountconfig','mountconfig.py'),
                            ('wineconfig','wineconfig.py'),
                            ('grubconfig','grubconfig.py')],

        kcontrol_modules = [('serviceconfig/serviceconfig.desktop','serviceconfig.py'),
                            ('userconfig/userconfig.desktop','userconfig.py'),
                            ('mountconfig/mountconfig.desktop','mountconfig.py'),
                            ('wineconfig/wineconfig.desktop','wineconfig.py')],

        data_files = [('share/icons/crystalsvg/16x16/apps',['kde/serviceconfig/pics/16x16/daemons.png',
                      'kde/mountconfig/pics/16x16/disksfilesystems.png',
                      'kde/userconfig/pics/16x16/userconfig.png',
                      'kde/wineconfig/pics/16x16/wineconfig.png'])],

        i18n = ('po',['mountconfig','userconfig','serviceconfig','wineconfig']),

        application_data = [('pics',['kde/serviceconfig/pics/laserwarn.png',
                                     'kde/serviceconfig/pics/hi32-app-daemons.png',
                                     'kde/userconfig/pics/hi16-encrypted.png',
                                     'kde/userconfig/pics/hi32-user.png',
                                     'kde/userconfig/pics/hi32-group.png',
                                     'kde/userconfig/pics/hi32-identity.png',
                                     'kde/userconfig/pics/hi32-password.png',
                                     'kde/mountconfig/pics/kcmpartitions.png',
                                     'kde/mountconfig/pics/trinity1.png',
                                     'kde/mountconfig/pics/trinity2.png',
                                     'kde/mountconfig/pics/trinity3.png',
                                     'kde/mountconfig/pics/trinity4.png',
                                     'kde/mountconfig/pics/trinity5.png',
                                     'kde/mountconfig/pics/trinity6.png',
                                     'kde/mountconfig/pics/hi32-samba.png',
                                     'kde/mountconfig/pics/hi16-hdd.png',
                                     'kde/mountconfig/pics/hi16-cdrom.png',
                                     'kde/mountconfig/pics/hi16-burner.png',
                                     'kde/mountconfig/pics/hi16-floppy.png',
                                     'kde/mountconfig/pics/hi16-blockdevice.png',
                                     'kde/mountconfig/pics/hi16-password.png',
                                     'kde/mountconfig/pics/hi16-memory.png',
                                     'kde/mountconfig/pics/hi16-network.png',
                                     'kde/mountconfig/pics/hi16-lock.png',
                                     'kde/mountconfig/pics/hi16-usbpen.png',
                                     'kde/mountconfig/pics/greenled.png',
                                     'kde/mountconfig/pics/greyled.png',
                                     'kde/mountconfig/pics/exec.png',
                                     'kde/mountconfig/pics/file.png',
                                     'kde/mountconfig/pics/important.png',
                                     'kde/mountconfig/pics/tux.png',
                                     'kde/mountconfig/pics/user.png',
                                     'kde/wineconfig/pics/32-wine.png',
                                     'kde/wineconfig/pics/kdewinewizard.png']),
                             'serviceconfig/serviceconfig.py',
                             'userconfig/userconfig.py',
                             'userconfig/unixauthdb.py',
                             'mountconfig/mountconfig.py',
                             'mountconfig/MicroHAL.py',
                             'mountconfig/SMBShareSelectDialog.py',
                             'mountconfig/SimpleCommandRunner.py',
                             'mountconfig/fuser.py',
                             'mountconfig/fuser_ui.ui',
                             'mountconfig/sizeview.py',
                             'wineconfig/wineconfig.py',
                             'wineconfig/wineread.py',
                             'wineconfig/winewrite.py',
                             'wineconfig/drivedetect.py',
                             'grubconfig/grubconfig.py'])

doit()
