/***************************************************************************
 *   Copyright (C) 2004 by Leonid Zeitlin                                  *
 *   lz@europe.com                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "windowwatcher.h"

#include <twinmodule.h>

WindowWatcher::WindowWatcher(KBConfig *kbconf, TQObject *parent, const char *name)
 : TQObject(parent, name)
{
  m_kbconf = kbconf;
  m_twin_module = new KWinModule(this);
  connect(m_twin_module, SIGNAL(windowAdded(WId)), SLOT(windowAdded(WId)));
  connect(m_twin_module, SIGNAL(windowRemoved(WId)), SLOT(windowRemoved(WId)));
  connect(m_twin_module, SIGNAL(activeWindowChanged(WId)), SLOT(activeWindowChanged(WId)));
}

WindowWatcher::~WindowWatcher()
{
}

#include "windowwatcher.moc"
