/*
   This file is part of the KDE project
   Copyright (C) 1998, 1999 Reginald Stadlbauer <reggie@kde.org>
   2000, 2001 Werner Trobin <trobin@kde.org>
   2002, 2003 Thomas Nagy <tnagy@eleve.emn.fr>
   2004 David Faure <faure@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
   */

#ifndef koTemplateChooseDia_h
#define koTemplateChooseDia_h

#include <kdialogbase.h>
#include <kicondialog.h>
#include <kiconview.h>
#include <koffice_export.h>

// KoTCD : KoTemplateChooseDia

class KoTCDIconViewItem;
class KoTemplateTree;
class KoTemplateGroup;
class TQGridLayout;

/**
 * Our reimplementation of TDEIconCanvas used within the template-chooser dialog.
 * @internal
 */
class KoTCDIconCanvas : public TDEIconCanvas
{
    TQ_OBJECT
  
    public:
	KoTCDIconCanvas( TQWidget *parent = 0, const char *name = 0L )
	    : TDEIconCanvas( parent, name ) {}

	bool isCurrentValid() { return currentItem(); }
	TQIconViewItem * load(KoTemplateGroup *group, const TQString& name, TDEInstance* instance);

    protected:
	virtual void keyPressEvent( TQKeyEvent *e ) {
	    if ( e->key() == Key_Return || e->key() == Key_Enter )
		e->ignore();
	    else
		TDEIconCanvas::keyPressEvent( e );
	}
};

/// @internal
class KoTCDIconViewItem : public TDEIconViewItem
{
    public:
	KoTCDIconViewItem(TQIconView *parent=0)
	    : TDEIconViewItem ( parent )
	    {}

	KoTCDIconViewItem(TQIconView *parent=0, const TQString &text=0, const TQPixmap &icon=0,
                      const TQString &descr=0, const TQString &fullname=0)
	    : TDEIconViewItem(parent, text, icon)
	    {
            m_descr = descr;
            m_full = fullname;
	    }

	TQString getDescr() const { return m_descr; }
	TQString getFName() const { return m_full; }

    private :
	TQString m_descr;
	TQString m_full;

};

#include <tdefileiconview.h>
#include <tqlabel.h>
/**
 * Our reimplementation of KFileIconView used as the "recent files" view
 * within the template-chooser dialog.
 * @internal
 */
class KoTCDRecentFilesIconView : public KFileIconView {
    TQ_OBJECT
  
    public:
	KoTCDRecentFilesIconView( TQWidget* parent, const char* name ) :
		KFileIconView( parent, name ), toolTip(0)
	{
	    connect( this, TQT_SIGNAL( onItem( TQIconViewItem * ) ),
                     TQT_SLOT( showToolTip( TQIconViewItem * ) ) );
	    connect( this, TQT_SIGNAL( onViewport() ),
                     TQT_SLOT( removeToolTip() ) );
	}
        virtual ~KoTCDRecentFilesIconView();
    protected:
        /**
         * Reimplemented to remove an eventual tooltip
         */
        virtual void hideEvent( TQHideEvent * );

    private slots:
        void showToolTip( TQIconViewItem* );
        void removeToolTip();
    private:
        TQLabel* toolTip;
};

class TDEInstance;
class KoTemplateChooseDiaPrivate;

/**
 *  This class is used to show the template dialog
 *  on startup. Unless you need something special, you should use the static
 *  method choose().
 *
 *  @short The template choose dialog
 *  @author Reginald Stadlbauer <reggie@kde.org>
 *  @author Werner Trobin <trobin@kde.org>
 */
class KOFFICEUI_EXPORT KoTemplateChooseDia : public KDialogBase
{
    TQ_OBJECT
  

public:
    /**
     * The Dialog returns one of these values depending
     * on the input of the user.
     * Cancel = The user pressed 'Cancel'
     * Template = The user selected a template
     * File = The user has chosen a file
     * Empty = The user selected "Empty document"
     */
    enum ReturnType { Cancel, Template, File, Empty };
    /**
     * To configure the dialog you have to use this enum.
     * Everything = Show templates and the rest of the dialog
     * OnlyTemplates = Show only the templates
     * NoTemplates = Just guess :)
     */
    enum DialogType { Everything, OnlyTemplates, NoTemplates };

    ~KoTemplateChooseDia();

    /**
     * This is the static method you'll normally use to show the
     * dialog.
     *
     * @param instance the TDEInstance of your app
     * The native mimetype is retrieved from the (desktop file of) that instance.
     * @param file this is the filename which is returned to your app
     * More precisely, it's a url (to give to KURL) if ReturnType is File
     * and it's a path (to open directly) if ReturnType is Template
     *
     * @param dialogType the type of the dialog
     * @param templateType the template type of your application (see kword or
     *        kpresenter for details)
     * @param parent pointer to parent widget
     * @return The return type (see above)
     */
    static ReturnType choose(TDEInstance* instance, TQString &file,
                             const DialogType &dialogType,
                             const TQCString& templateType,
                             TQWidget* parent);

private:
    /// Ditto, with extraNativeMimeTypes added
    static ReturnType choose(TDEInstance* instance, TQString &file,
                             const TQCString &format,
                             const TQString &nativeName,
                             const TQStringList& extraNativeMimeTypes,
                             const DialogType &dialogType=Everything,
                             const TQCString& templateType="",
                             TQWidget* parent = 0);
public:

    /**
     * Method to get the current template
     */
    TQString getTemplate() const;
    /**
     * Method to get the "full" template (path+template)
     */
    TQString getFullTemplate() const;
    /**
     * The ReturnType (call this one after exec())
     */
    ReturnType getReturnType() const;
    /**
     * The dialogType - normally you won't need this one
     */
    DialogType getDialogType() const;

protected slots:
    /**
     * Activated when the Ok button has been clicked.
     */
    virtual void slotOk();

private:
    /**
     *
     * @param parent parent the parent of the dialog
     * @param name the TQt internal name
     * @param instance the TDEInstance of your app
     * @param format is the mimetype of the app (e.g. application/x-kspread)
     * @param nativeName is the name of your app (e.g KSpread)
     * @param dialogType the type of the dialog
     * @param templateType the template type of your application (see kword or
     *        kpresenter for details)
     *
     * @return The return type (see above)
     */
    KoTemplateChooseDia(TQWidget *parent, const char *name, TDEInstance* instance,
                        const TQCString &format,
                        const TQString &nativeName,
                        const TQStringList &extraNativeMimeTypes,
                        const DialogType &dialogType=Everything,
                        const TQCString& templateType="");

private:
    KoTemplateChooseDiaPrivate *d;

    TQString descriptionText(const TQString &name, const TQString &description);
    void setupDialog();
    void setupTemplateDialog(TQWidget * widgetbase, TQGridLayout * layout);
    void setupFileDialog(TQWidget * widgetbase, TQGridLayout * layout);
    void setupRecentDialog(TQWidget * widgetbase, TQGridLayout * layout);
    bool collectInfo();
    bool noStartupDlg() const;

private slots:

    void chosen(TQIconViewItem *);
    void currentChanged( TQIconViewItem * );
    void recentSelected( TQIconViewItem * );
};

#endif

