/* This file is part of the KDE project
   Copyright (C) 2005-2006 Jaroslaw Staniek <js@iidea.pl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

/* This file is included by KexiDBLabel and KexiFrame */

//! @todo add more frame types
void ClassName::drawFrame( TQPainter *p )
{
	if (frameShape() == TQFrame::Box) {
		if ( frameShadow() == Plain )
			qDrawPlainRect( p, frameRect(), d->frameColor, lineWidth() );
		else
			qDrawShadeRect( p, frameRect(), colorGroup(), frameShadow() == TQFrame::Sunken, 
				lineWidth(), midLineWidth() );
	}
	else {
		SuperClassName::drawFrame(p);
	}
}

void ClassName::setPalette( const TQPalette &pal )
{
	TQPalette pal2(pal);
	TQColorGroup cg( pal2.active() );
	cg.setColor(TQColorGroup::Light, KexiUtils::bleachedColor( d->frameColor, 150 ));
	cg.setColor(TQColorGroup::Mid, d->frameColor);
	cg.setColor(TQColorGroup::Dark, d->frameColor.dark(150));
	pal2.setActive(cg);
	TQColorGroup cg2( pal2.inactive() );
	cg2.setColor(TQColorGroup::Light, cg.light() );
	cg2.setColor(TQColorGroup::Mid, cg.mid());
	cg2.setColor(TQColorGroup::Dark, cg.dark());
	pal2.setInactive(cg2);
	SuperClassName::setPalette(pal2);
}

const TQColor& ClassName::frameColor() const
{
	return d->frameColor;
}

void ClassName::setFrameColor(const TQColor& color)
{
	d->frameColor = color;
	//update light and dark colors
	setPalette( palette() );
}

#if 0
//todo
ClassName::Shape ClassName::frameShape() const
{
	return d->frameShape;
}

void ClassName::setFrameShape( ClassName::Shape shape )
{
	d->frameShape = shape;
	update();
}

ClassName::Shadow ClassName::frameShadow() const
{
	return d->frameShadow;
}

void ClassName::setFrameShadow( ClassName::Shadow shadow )
{
	d->frameShadow = shadow;
	update();
}
#endif

#if 0
void TQFrame::drawFrame( TQPainter *p )
{
    TQPoint      p1, p2;
    TQRect       r     = frameRect();
    int         type  = fstyle & MShape;
    int         cstyle = fstyle & MShadow;
#ifdef TQT_NO_DRAWUTIL
    p->setPen( black ); // ####
    p->drawRect( r ); //### a bit too simple
#else
    const TQColorGroup & g = colorGroup();

#ifndef TQT_NO_STYLE
    TQStyleOption opt(lineWidth(),midLineWidth());

    TQStyle::SFlags flags = TQStyle::Style_Default;
    if (isEnabled())
	flags |= TQStyle::Style_Enabled;
    if (cstyle == Sunken)
	flags |= TQStyle::Style_Sunken;
    else if (cstyle == Raised)
	flags |= TQStyle::Style_Raised;
    if (hasFocus())
	flags |= TQStyle::Style_HasFocus;
    if (hasMouse())
	flags |= TQStyle::Style_MouseOver;
#endif // TQT_NO_STYLE

    switch ( type ) {

    case Box:
        if ( cstyle == Plain )
            qDrawPlainRect( p, r, g.foreground(), lwidth );
        else
            qDrawShadeRect( p, r, g, cstyle == Sunken, lwidth,
                            midLineWidth() );
        break;

    case LineEditPanel:
	style().drawPrimitive( TQStyle::PE_PanelLineEdit, p, r, g, flags, opt );
	break;

    case GroupBoxPanel:
	style().drawPrimitive( TQStyle::PE_PanelGroupBox, p, r, g, flags, opt );
	break;

    case TabWidgetPanel:
	style().drawPrimitive( TQStyle::PE_PanelTabWidget, p, r, g, flags, opt );
	break;

    case MenuBarPanel:
#ifndef TQT_NO_STYLE
	style().drawPrimitive(TQStyle::PE_PanelMenuBar, p, r, g, flags, opt);
	break;
#endif // fall through to Panel if TQT_NO_STYLE

    case ToolBarPanel:
#ifndef TQT_NO_STYLE
	style().drawPrimitive( TQStyle::PE_PanelDockWindow, p, rect(), g, flags, opt);
        break;
#endif // fall through to Panel if TQT_NO_STYLE

    case StyledPanel:
#ifndef TQT_NO_STYLE
        if ( cstyle == Plain )
            qDrawPlainRect( p, r, g.foreground(), lwidth );
        else
	    style().drawPrimitive(TQStyle::PE_Panel, p, r, g, flags, opt);
        break;
#endif // fall through to Panel if TQT_NO_STYLE

    case PopupPanel:
#ifndef TQT_NO_STYLE
    {
	int vextra = style().pixelMetric(TQStyle::PM_PopupMenuFrameVerticalExtra, this),
	    hextra = style().pixelMetric(TQStyle::PM_PopupMenuFrameHorizontalExtra, this);
	if(vextra > 0 || hextra > 0) {
	    TQRect fr = frameRect();
	    int   fw = frameWidth();
	    if(vextra > 0) {
		style().drawControl(TQStyle::CE_PopupMenuVerticalExtra, p, this,
				    TQRect(fr.x() + fw, fr.y() + fw, fr.width() - (fw*2), vextra),
				    g, flags, opt);
		style().drawControl(TQStyle::CE_PopupMenuVerticalExtra, p, this,
				    TQRect(fr.x() + fw, fr.bottom() - fw - vextra, fr.width() - (fw*2), vextra),
				    g, flags, opt);
	    }
	    if(hextra > 0) {
		style().drawControl(TQStyle::CE_PopupMenuHorizontalExtra, p, this,
				    TQRect(fr.x() + fw, fr.y() + fw + vextra, hextra, fr.height() - (fw*2) - vextra),
				    g, flags, opt);
		style().drawControl(TQStyle::CE_PopupMenuHorizontalExtra, p, this,
				    TQRect(fr.right() - fw - hextra, fr.y() + fw + vextra, hextra, fr.height() - (fw*2) - vextra),
				    g, flags, opt);
	    }
	}

        if ( cstyle == Plain )
            qDrawPlainRect( p, r, g.foreground(), lwidth );
        else
	    style().drawPrimitive(TQStyle::PE_PanelPopup, p, r, g, flags, opt);
        break;
    }
#endif // fall through to Panel if TQT_NO_STYLE

    case Panel:
        if ( cstyle == Plain )
            qDrawPlainRect( p, r, g.foreground(), lwidth );
        else
            qDrawShadePanel( p, r, g, cstyle == Sunken, lwidth );
        break;

    case WinPanel:
        if ( cstyle == Plain )
            qDrawPlainRect( p, r, g.foreground(), wpwidth );
        else
            qDrawWinPanel( p, r, g, cstyle == Sunken );
        break;
    case HLine:
    case VLine:
        if ( type == HLine ) {
            p1 = TQPoint( r.x(), r.height()/2 );
            p2 = TQPoint( r.x()+r.width(), p1.y() );
        }
        else {
            p1 = TQPoint( r.x()+r.width()/2, 0 );
            p2 = TQPoint( p1.x(), r.height() );
        }
        if ( cstyle == Plain ) {
            TQPen oldPen = p->pen();
            p->setPen( TQPen(g.foreground(),lwidth) );
            p->drawLine( p1, p2 );
            p->setPen( oldPen );
        }
        else
            qDrawShadeLine( p, p1, p2, g, cstyle == Sunken,
                            lwidth, midLineWidth() );
        break;
    }
#endif // TQT_NO_DRAWUTIL

#endif
