/*
 *  Copyright (c) 2005 Adrian Page <adrian@pagenet.plus.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.g
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "kis_canvas.h"
#include "kis_canvas_painter.h"
#include "kis_qpaintdevice_canvas_painter.h"

KisTQPaintDeviceCanvasPainter::KisTQPaintDeviceCanvasPainter()
{
}

KisTQPaintDeviceCanvasPainter::KisTQPaintDeviceCanvasPainter(const TQPaintDevice *paintDevice)
    : m_painter(const_cast<TQPaintDevice*>(paintDevice))
{
}

KisTQPaintDeviceCanvasPainter::~KisTQPaintDeviceCanvasPainter()
{
}

bool KisTQPaintDeviceCanvasPainter::begin(KisCanvasWidget *canvasWidget, bool unclipped)
{
    TQWidget *widget = dynamic_cast<TQWidget *>(canvasWidget);

    if (widget != 0) {
        return m_painter.begin(TQT_TQPAINTDEVICE(widget), unclipped);
    } else {
        return false;
    }
}

bool KisTQPaintDeviceCanvasPainter::begin(const TQPaintDevice* paintDevice, bool unclipped)
{
    return m_painter.begin(const_cast<TQPaintDevice*>(paintDevice), unclipped);
}

bool KisTQPaintDeviceCanvasPainter::end()
{
    return m_painter.end();
}

void KisTQPaintDeviceCanvasPainter::save()
{
    m_painter.save();
}

void KisTQPaintDeviceCanvasPainter::restore()
{
    m_painter.restore();
}

TQFontMetrics KisTQPaintDeviceCanvasPainter::fontMetrics() const
{
    return m_painter.fontMetrics();
}

TQFontInfo KisTQPaintDeviceCanvasPainter::fontInfo() const
{
    return m_painter.fontInfo();
}

const TQFont& KisTQPaintDeviceCanvasPainter::font() const
{
    return m_painter.font();
}

void KisTQPaintDeviceCanvasPainter::setFont(const TQFont& font)
{
    m_painter.setFont(font);
}

const TQPen& KisTQPaintDeviceCanvasPainter::pen() const
{
    return m_painter.pen();
}

void KisTQPaintDeviceCanvasPainter::setPen(const TQPen& pen)
{
    m_painter.setPen(pen);
}

void KisTQPaintDeviceCanvasPainter::setPen(Qt::PenStyle penStyle)
{
    m_painter.setPen(penStyle);
}

void KisTQPaintDeviceCanvasPainter::setPen(const TQColor& color)
{
    m_painter.setPen(color);;
}

const TQBrush& KisTQPaintDeviceCanvasPainter::brush() const
{
    return m_painter.brush();
}

void KisTQPaintDeviceCanvasPainter::setBrush(const TQBrush& brush)
{
    m_painter.setBrush(brush);
}

void KisTQPaintDeviceCanvasPainter::setBrush(TQt::BrushStyle brushStyle)
{
    m_painter.setBrush(brushStyle);
}

void KisTQPaintDeviceCanvasPainter::setBrush(const TQColor& color)
{
    m_painter.setBrush(color);
}

TQPoint KisTQPaintDeviceCanvasPainter::pos() const
{
    return m_painter.pos();
}

const TQColor& KisTQPaintDeviceCanvasPainter::backgroundColor() const
{
    return m_painter.backgroundColor();
}

void KisTQPaintDeviceCanvasPainter::setBackgroundColor(const TQColor& color)
{
    m_painter.setBackgroundColor(color);
}

Qt::BGMode KisTQPaintDeviceCanvasPainter::backgroundMode() const
{
    return m_painter.backgroundMode();
}

void KisTQPaintDeviceCanvasPainter::setBackgroundMode(Qt::BGMode bgMode)
{
    m_painter.setBackgroundMode(bgMode);
}

TQt::RasterOp KisTQPaintDeviceCanvasPainter::rasterOp() const
{
    return m_painter.rasterOp();
}

void KisTQPaintDeviceCanvasPainter::setRasterOp(TQt::RasterOp rasterOp)
{
    m_painter.setRasterOp(rasterOp);
}

const TQPoint& KisTQPaintDeviceCanvasPainter::brushOrigin() const
{
    return m_painter.brushOrigin();
}

void KisTQPaintDeviceCanvasPainter::setBrushOrigin(int x, int y)
{
    m_painter.setBrushOrigin(x, y);
}

void KisTQPaintDeviceCanvasPainter::setBrushOrigin(const TQPoint& origin)
{
    m_painter.setBrushOrigin(origin);
}

bool KisTQPaintDeviceCanvasPainter::hasViewXForm() const
{
    return m_painter.hasViewXForm();
}

bool KisTQPaintDeviceCanvasPainter::hasWorldXForm() const
{
    return m_painter.hasWorldXForm();
}

void KisTQPaintDeviceCanvasPainter::setViewXForm(bool enable)
{
    m_painter.setViewXForm(enable);
}

TQRect KisTQPaintDeviceCanvasPainter::window() const
{
    return m_painter.window();
}

void KisTQPaintDeviceCanvasPainter::setWindow(const TQRect& r)
{
    m_painter.setWindow(r);
}

void KisTQPaintDeviceCanvasPainter::setWindow(int x, int y, int w, int h)
{
    m_painter.setWindow(x, y, w, h);
}

TQRect KisTQPaintDeviceCanvasPainter::viewport() const
{
    return m_painter.viewport();
}

void KisTQPaintDeviceCanvasPainter::setViewport(const TQRect& r)
{
    m_painter.setViewport(r);
}

void KisTQPaintDeviceCanvasPainter::setViewport(int x, int y, int w, int h)
{
    m_painter.setViewport(x, y, w, h);
}

void KisTQPaintDeviceCanvasPainter::setWorldXForm(bool enable)
{
    m_painter.setWorldXForm(enable);
}

const TQWMatrix& KisTQPaintDeviceCanvasPainter::worldMatrix() const
{
    return m_painter.worldMatrix();
}

void KisTQPaintDeviceCanvasPainter::setWorldMatrix(const TQWMatrix& matrix, bool combine)
{
    m_painter.setWorldMatrix(matrix, combine);
}

void KisTQPaintDeviceCanvasPainter::saveWorldMatrix()
{
    m_painter.saveWorldMatrix();
}

void KisTQPaintDeviceCanvasPainter::restoreWorldMatrix()
{
    m_painter.restoreWorldMatrix();
}

void KisTQPaintDeviceCanvasPainter::scale(double sx, double sy)
{
    m_painter.scale(sx, sy);
}

void KisTQPaintDeviceCanvasPainter::shear(double sh, double sv)
{
    m_painter.shear(sh, sv);
}

void KisTQPaintDeviceCanvasPainter::rotate(double a)
{
    m_painter.rotate(a);
}

void KisTQPaintDeviceCanvasPainter::translate(double dx, double dy)
{
    m_painter.translate(dx, dy);
}

void KisTQPaintDeviceCanvasPainter::resetXForm()
{
    m_painter.resetXForm();
}

double KisTQPaintDeviceCanvasPainter::translationX() const
{
    return m_painter.translationX();
}

double KisTQPaintDeviceCanvasPainter::translationY() const
{
    return m_painter.translationY();
}

TQPoint KisTQPaintDeviceCanvasPainter::xForm(const TQPoint& point) const
{
    return m_painter.xForm(point);
}

TQRect KisTQPaintDeviceCanvasPainter::xForm(const TQRect& r) const
{
    return m_painter.xForm(r);
}

TQPointArray KisTQPaintDeviceCanvasPainter::xForm(const TQPointArray& pointArray) const
{
    return m_painter.xForm(pointArray);
}

TQPointArray KisTQPaintDeviceCanvasPainter::xForm(const TQPointArray& pointArray, int index, int npoints) const
{
    return m_painter.xForm(pointArray, index, npoints);
}

TQPoint KisTQPaintDeviceCanvasPainter::xFormDev(const TQPoint& point) const
{
    return m_painter.xFormDev(point);
}

TQRect KisTQPaintDeviceCanvasPainter::xFormDev(const TQRect& r) const
{
    return m_painter.xFormDev(r);
}

TQPointArray KisTQPaintDeviceCanvasPainter::xFormDev(const TQPointArray& pointArray) const
{
    return m_painter.xFormDev(pointArray);
}

TQPointArray KisTQPaintDeviceCanvasPainter::xFormDev(const TQPointArray& pointArray, int index, int npoints) const
{
    return m_painter.xFormDev(pointArray, index, npoints);
}

void KisTQPaintDeviceCanvasPainter::setClipping(bool enable)
{
    m_painter.setClipping(enable);
}

bool KisTQPaintDeviceCanvasPainter::hasClipping() const
{
    return m_painter.hasClipping();
}

TQRegion KisTQPaintDeviceCanvasPainter::clipRegion(TQPainter::CoordinateMode mode) const
{
    return m_painter.clipRegion(mode);
}

void KisTQPaintDeviceCanvasPainter::setClipRect(const TQRect& r, TQPainter::CoordinateMode mode)
{
    m_painter.setClipRect(r, mode);
}

void KisTQPaintDeviceCanvasPainter::setClipRect(int x, int y, int w, int h, TQPainter::CoordinateMode mode)
{
    m_painter.setClipRect(x, y, w, h, mode);
}

void KisTQPaintDeviceCanvasPainter::setClipRegion(const TQRegion& rgn, TQPainter::CoordinateMode mode)
{
    m_painter.setClipRegion(rgn, mode);
}

void KisTQPaintDeviceCanvasPainter::drawPoint(int x, int y)
{
    m_painter.drawPoint(x, y);
}

void KisTQPaintDeviceCanvasPainter::drawPoint(const TQPoint& point)
{
    m_painter.drawPoint(point);
}

void KisTQPaintDeviceCanvasPainter::drawPoints(const TQPointArray& pointArray, int index, int npoints)
{
    m_painter.drawPoints(pointArray, index, npoints);
}

void KisTQPaintDeviceCanvasPainter::moveTo(int x, int y)
{
    m_painter.moveTo(x, y);
}

void KisTQPaintDeviceCanvasPainter::moveTo(const TQPoint& point)
{
    m_painter.moveTo(point);
}

void KisTQPaintDeviceCanvasPainter::lineTo(int x, int y)
{
    m_painter.lineTo(x, y);
}

void KisTQPaintDeviceCanvasPainter::lineTo(const TQPoint& point)
{
    m_painter.lineTo(point);
}

void KisTQPaintDeviceCanvasPainter::drawLine(int x1, int y1, int x2, int y2)
{
    m_painter.drawLine(x1, y1, x2, y2);
}

void KisTQPaintDeviceCanvasPainter::drawLine(const TQPoint& start, const TQPoint& end)
{
    m_painter.drawLine(start, end);
}

void KisTQPaintDeviceCanvasPainter::drawRect(int x, int y, int w, int h)
{
    m_painter.drawRect(x, y, w, h);
}

void KisTQPaintDeviceCanvasPainter::drawRect(const TQRect& r)
{
    m_painter.drawRect(r);
}

void KisTQPaintDeviceCanvasPainter::drawWinFocusRect(int x, int y, int w, int h)
{
    m_painter.drawWinFocusRect(x, y, w, h);
}

void KisTQPaintDeviceCanvasPainter::drawWinFocusRect(int x, int y, int w, int h, const TQColor& bgColor)
{
    m_painter.drawWinFocusRect(x, y, w, h, bgColor);
}

void KisTQPaintDeviceCanvasPainter::drawWinFocusRect(const TQRect& r)
{
    m_painter.drawWinFocusRect(r);
}

void KisTQPaintDeviceCanvasPainter::drawWinFocusRect(const TQRect& r, const TQColor& bgColor)
{
    m_painter.drawWinFocusRect(r, bgColor);
}

void KisTQPaintDeviceCanvasPainter::drawRoundRect(int x, int y, int w, int h, int xRnd, int yRnd)
{
    m_painter.drawRoundRect(x, y, w, h, xRnd, yRnd);
}

void KisTQPaintDeviceCanvasPainter::drawRoundRect(const TQRect& r, int xRnd, int yRnd)
{
    m_painter.drawRoundRect(r, xRnd, yRnd);
}

void KisTQPaintDeviceCanvasPainter::drawEllipse(int x, int y, int w, int h)
{
    m_painter.drawEllipse(x, y, w, h);
}

void KisTQPaintDeviceCanvasPainter::drawEllipse(const TQRect& r)
{
    m_painter.drawEllipse(r);
}

void KisTQPaintDeviceCanvasPainter::drawArc(int x, int y, int w, int h, int a, int alen)
{
    m_painter.drawArc(x, y, w, h, a, alen);
}

void KisTQPaintDeviceCanvasPainter::drawArc(const TQRect& r, int a, int alen)
{
    m_painter.drawArc(r, a, alen);
}

void KisTQPaintDeviceCanvasPainter::drawPie(int x, int y, int w, int h, int a, int alen)
{
    m_painter.drawPie(x, y, w, h, a, alen);
}

void KisTQPaintDeviceCanvasPainter::drawPie(const TQRect& r, int a, int alen)
{
    m_painter.drawPie(r, a, alen);
}

void KisTQPaintDeviceCanvasPainter::drawChord(int x, int y, int w, int h, int a, int alen)
{
    m_painter.drawChord(x, y, w, h, a, alen);
}

void KisTQPaintDeviceCanvasPainter::drawChord(const TQRect& r, int a, int alen)
{
    m_painter.drawChord(r, a, alen);
}

void KisTQPaintDeviceCanvasPainter::drawLineSegments(const TQPointArray& pointArray, int index, int nlines)
{
    m_painter.drawLineSegments(pointArray, index, nlines);
}

void KisTQPaintDeviceCanvasPainter::drawPolyline(const TQPointArray& pointArray, int index, int npoints)
{
    m_painter.drawPolyline(pointArray, index, npoints);
}

void KisTQPaintDeviceCanvasPainter::drawPolygon(const TQPointArray& pointArray, bool winding, int index, int npoints)
{
    m_painter.drawPolygon(pointArray, winding, index, npoints);
}

void KisTQPaintDeviceCanvasPainter::drawConvexPolygon(const TQPointArray& pointArray, int index, int npoints)
{
    m_painter.drawConvexPolygon(pointArray, index, npoints);
}

void KisTQPaintDeviceCanvasPainter::drawCubicBezier(const TQPointArray& pointArray, int index)
{
    m_painter.drawCubicBezier(pointArray, index);
}

void KisTQPaintDeviceCanvasPainter::drawPixmap(int x, int y, const TQPixmap& pixmap, int sx, int sy, int sw, int sh)
{
    m_painter.drawPixmap(x, y, pixmap, sx, sy, sw, sh);
}

void KisTQPaintDeviceCanvasPainter::drawPixmap(const TQPoint& point, const TQPixmap& pixmap, const TQRect& sr)
{
    m_painter.drawPixmap(point, pixmap, sr);
}

void KisTQPaintDeviceCanvasPainter::drawPixmap(const TQPoint& point, const TQPixmap& pixmap)
{
    m_painter.drawPixmap(point, pixmap);
}

void KisTQPaintDeviceCanvasPainter::drawPixmap(const TQRect& r, const TQPixmap& pixmap)
{
    m_painter.drawPixmap(r, pixmap);
}

void KisTQPaintDeviceCanvasPainter::drawImage(int x, int y, const TQImage& image, int sx, int sy, int sw, int sh, int conversionFlags)
{
    m_painter.drawImage(x, y, image, sx, sy, sw, sh, conversionFlags);
}

void KisTQPaintDeviceCanvasPainter::drawImage(const TQPoint& point, const TQImage& image, const TQRect& sr, int conversionFlags)
{
    m_painter.drawImage(point, image, sr, conversionFlags);
}

void KisTQPaintDeviceCanvasPainter::drawImage(const TQPoint& point, const TQImage& image, int conversion_flags)
{
    m_painter.drawImage(point, image, conversion_flags);
}

void KisTQPaintDeviceCanvasPainter::drawImage(const TQRect& r, const TQImage& image)
{
    m_painter.drawImage(r, image);
}

void KisTQPaintDeviceCanvasPainter::drawTiledPixmap(int x, int y, int w, int h, const TQPixmap& pixmap, int sx, int sy)
{
    m_painter.drawTiledPixmap(x, y, w, h, pixmap, sx, sy);
}

void KisTQPaintDeviceCanvasPainter::drawTiledPixmap(const TQRect& r, const TQPixmap& pixmap, const TQPoint& point)
{
    m_painter.drawTiledPixmap(r, pixmap, point);
}

void KisTQPaintDeviceCanvasPainter::drawTiledPixmap(const TQRect& r, const TQPixmap& pixmap)
{
    m_painter.drawTiledPixmap(r, pixmap);
}

void KisTQPaintDeviceCanvasPainter::fillRect(int x, int y, int w, int h, const TQBrush& brush)
{
    m_painter.fillRect(x, y, w, h, brush);
}

void KisTQPaintDeviceCanvasPainter::fillRect(const TQRect& r, const TQBrush& brush)
{
    m_painter.fillRect(r, brush);
}

void KisTQPaintDeviceCanvasPainter::eraseRect(int x, int y, int w, int h)
{
    m_painter.eraseRect(x, y, w, h);
}

void KisTQPaintDeviceCanvasPainter::eraseRect(const TQRect& r)
{
    m_painter.eraseRect(r);
}

void KisTQPaintDeviceCanvasPainter::drawText(int x, int y, const TQString& text, int len, TQPainter::TextDirection dir)
{
    m_painter.drawText(x, y, text, len, dir);
}

void KisTQPaintDeviceCanvasPainter::drawText(const TQPoint& point, const TQString& text, int len, TQPainter::TextDirection dir)
{
    m_painter.drawText(point, text, len, dir);
}

void KisTQPaintDeviceCanvasPainter::drawText(int x, int y, const TQString& text, int pos, int len, TQPainter::TextDirection dir)
{
    m_painter.drawText(x, y, text, pos, len, dir);
}

void KisTQPaintDeviceCanvasPainter::drawText(const TQPoint& point, const TQString& text, int pos, int len, TQPainter::TextDirection dir)
{
    m_painter.drawText(point, text, pos, len, dir);
}

void KisTQPaintDeviceCanvasPainter::drawText(int x, int y, int w, int h, int flags, const TQString& text, int len, TQRect *br, TQTextParag **intern)
{
    m_painter.drawText(x, y, w, h, flags, text, len, br, intern);
}

void KisTQPaintDeviceCanvasPainter::drawText(const TQRect& r, int flags, const TQString& text, int len, TQRect *br, TQTextParag **intern)
{
    m_painter.drawText(r, flags, text, len, br, intern);
}

void KisTQPaintDeviceCanvasPainter::drawTextItem(int x, int y, const TQTextItem& ti, int textflags)
{
    m_painter.drawTextItem(x, y, ti, textflags);
}

void KisTQPaintDeviceCanvasPainter::drawTextItem(const TQPoint& p, const TQTextItem& ti, int textflags)
{
    m_painter.drawTextItem(p, ti, textflags);
}

TQRect KisTQPaintDeviceCanvasPainter::boundingRect(int x, int y, int w, int h, int flags, const TQString& text, int len, TQTextParag **intern)
{
    return m_painter.boundingRect(x, y, w, h, flags, text, len, intern);
}

TQRect KisTQPaintDeviceCanvasPainter::boundingRect(const TQRect& r, int flags, const TQString& text, int len, TQTextParag **intern)
{
    return m_painter.boundingRect(r, flags, text, len, intern);
}

int	KisTQPaintDeviceCanvasPainter::tabStops() const
{
    return m_painter.tabStops();
}

void KisTQPaintDeviceCanvasPainter::setTabStops(int ts)
{
    m_painter.setTabStops(ts);
}

int	*KisTQPaintDeviceCanvasPainter::tabArray() const
{
    return m_painter.tabArray();
}

void KisTQPaintDeviceCanvasPainter::setTabArray(int *ts)
{
    m_painter.setTabArray(ts);
}


