/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** TQt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/

// ----------------------------------------------------------------------------
// QT Includes

// ----------------------------------------------------------------------------
// KDE Includes

#include <kstdguiitem.h>

// ----------------------------------------------------------------------------
// Project Includes


void KSortOptionDlg::init()
{
  m_okButton->setGuiItem(KStdGuiItem::ok());
  m_cancelButton->setGuiItem(KStdGuiItem::cancel());
  m_helpButton->setGuiItem(KStdGuiItem::help());
}

void KSortOptionDlg::setSortOption(const TQString& option, const TQString& def)
{
  if(option.isEmpty()) {
    m_sortOption->setSettings(def);
    m_useDefault->setChecked(true);
  } else {
    m_sortOption->setSettings(option);
    m_useDefault->setChecked(false);
  }
}

TQString KSortOptionDlg::sortOption(void) const
{
  TQString rc;
  if(!m_useDefault->isChecked()) {
    rc = m_sortOption->settings();
  }
  return rc;
}

void KSortOptionDlg::hideDefaultButton(void)
{
  m_useDefault->hide();
}
 
