/***************************************************************************
*   Copyright (C) 2004 by Jason Kivlighn                                  *
*   (jkivlighn@gmail.com)                                                 *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef REFINESHOPPINGLISTDIALOG_H
#define REFINESHOPPINGLISTDIALOG_H

#include <ntqvariant.h>
#include <ntqmap.h>

#include <kdialogbase.h>

#include "datablocks/ingredientlist.h"

class TQVBoxLayout;
class TQHBoxLayout;
class TQGridLayout;
class TQSpacerItem;
class TQLabel;
class TQListViewItem;
class TQPushButton;

class RecipeDB;
class ElementList;
class KreListView;

class RefineShoppingListDialog : public KDialogBase
{
	TQ_OBJECT

public:
	RefineShoppingListDialog( TQWidget* parent, RecipeDB *db, const ElementList &recipeList );
	~RefineShoppingListDialog();

	TQLabel* helpLabel;
	KreListView* allIngListView;
	TQPushButton* addButton;
	TQPushButton* removeButton;
	KreListView* ingListView;

protected:
	TQVBoxLayout* layout1;
	TQSpacerItem* spacer1;

protected slots:
	virtual void languageChange();
	virtual void accept();
	void addIngredient();
	void removeIngredient();
	void itemRenamed( TQListViewItem*, const TQString &, int );

private:
	void loadData();

	RecipeDB *database;
	IngredientList ingredientList;
	TQMap<TQListViewItem*, IngredientList::iterator> item_ing_map;
};

#endif // REFINESHOPPINGLISTDIALOG_H
