/*********
*
* This file is part of BibleTime's source code, http://www.bibletime.info/.
*
* Copyright 1999-2006 by the BibleTime developers.
* The BibleTime source code is licensed under the GNU General Public License version 2.0.
*
**********/



#ifndef CSEARCHDIALOGPAGES_H
#define CSEARCHDIALOGPAGES_H

//BibleTime includes
#include "backend/cswordmoduleinfo.h"
#include "backend/cswordbackend.h"
#include "backend/cswordmodulesearch.h"

#include "frontend/searchdialog/searchoptionsform.h" // uic generated
#include "frontend/searchdialog/searchresultsform.h" // uic generated

//TQt includes
#include <tqwidget.h>
#include <tqvgroupbox.h>

//KDE includes
#include <tdelistview.h>

//forward declarations
class TQLabel;
class TQCheckBox;
class TQPushButton;
class TQRadioButton;

class KComboBox;
class TDEActionMenu;
class TDEAction;
class KHistoryCombo;
class KProgress;
class TDEPopupMenu;

class CReadDisplay;

namespace Search {
	namespace Result {
		
/**
* This class is used to keep track of the text strongs results.
* It only keeps track of one instance of a strongs text result.
*
*    The functions of the class are:
*       - Store an instance of a strongs text result.
*       - Each strongs text result will contain a list of verses (keyNames).
*       - The number of verses (keyNames) is returned by keyCount().
*       - The text for the strongs text result is returned by keyText().
*       - The list of verses (keyNames) is returned by getKeyList() [as TQStringList].
*
*   To add a new verse to a strongs text result use addKeyName.
*/
class StrongsResult {
public:
   StrongsResult() /*: text(TQString())*/ {
	   	//keyNameList.clear();
   }
   
   StrongsResult(const TQString& text, const TQString &keyName)
	   : text(text)
    {
		//keyNameList.clear();
		keyNameList.append(keyName);
	}

	TQString keyText() const {
		return text;
	}
	int keyCount() const {
		return keyNameList.count();
	}
	void addKeyName(const TQString& keyName) {
		if (keyNameList.findIndex(keyName) == -1)
			keyNameList.append(keyName);
	}
	TQStringList* getKeyList() {
		return & keyNameList;
	}

	/* ????
	bool operator==(const StrongsResult &l, const StrongsResult &r)
		{ return (l.keyText() == r.keyText()); }

	bool operator<(const StrongsResult &l, const StrongsResult &r)
		{ return (l->keyText() < r->keyText()); }

	bool operator>(const StrongsResult &l, const StrongsResult &r)
		{ return (l->keyText() > r->keyText()); }
	*/
private:
	TQString text;
	TQStringList keyNameList;
};

typedef TQValueList<StrongsResult> StrongsResultList;

/**
* This class is used to keep track of the text strongs results.
* It keeps track of all instances of all strongs text results.
* This class makes use of the above class StrongsResult.
*
*    The functions of the class are:
*       - Store an instance of a strongs text result.
*       - Each strongs text result will contain a list of verses (keyNames).
*       - The number of verses (keyNames) is returned by keyCount().
*       - The text for the strongs text result is returned by keyText().
*       - The list of verses (keyNames) is returned by getKeyList() [as TQStringList].
*
*   To add a new verse to a strongs text result use addKeyName.
*/
class StrongsResultClass {
public:
	StrongsResultClass(CSwordModuleInfo* module, const TQString& strongsNumber)
		: srModule(module), lemmaText(strongsNumber)
	{
		initStrongsResults();
	}

	TQString keyText(int index) const {
		return srList[index].keyText();
	}
	int keyCount(int index) const {
		return srList[index].keyCount();
	}
	TQStringList* getKeyList(int index) {
		return srList[index].getKeyList();
	}
	int Count() const {
		return srList.count();
	}

private:
	void initStrongsResults(void);
	TQString getStrongsNumberText(const TQString& verseContent, int *startIndex);

	StrongsResultList srList;
	CSwordModuleInfo* srModule;
	TQString lemmaText;
};

/** The page of the search dialog which contains the search result part.
  * @author The BibleTime team
  */
class CSearchResultPage : public SearchResultsForm {
	TQ_OBJECT
  
public:
	CSearchResultPage(TQWidget *parent=0, const char *name=0);
	~CSearchResultPage();
	/**
	* Sets the modules which contain the result of each.
	*/
	void setSearchResult(ListCSwordModuleInfo modules);
	
	TQSize sizeHint() const { return baseSize(); }
	TQSize minimumSizeHint() const { return minimumSize(); }

public slots: // Public slots
	/**
	* Resets the current l�st of modules and the displayed list of found entries.
	*/
	void reset();

protected: // Protected methods
	/**
	* Initializes the view of this widget.
	*/
	void initView();
	/**
	* Initializes the signal slot conections of the child widgets
	*/
	void initConnections();
	/**
	* This function breakes the queryString into clucene tokens
	*/	
	TQStringList QueryParser(const TQString& queryString);
	/**
	* This function highlights the searched text in the content using the search type given by search flags
	*/
	const TQString highlightSearchedText(const TQString& content, const TQString& searchedText/*, const int searchFlags*/);

private:
	CReadDisplay* m_previewDisplay;
	ListCSwordModuleInfo m_modules;

protected slots: // Protected slots
	/**
	* Update the preview of the selected key.
	*/
	void updatePreview(const TQString& key);
	/**
	* Shows a dialog with the search analysis of the current search.
	*/
	void showAnalysis();

};
	} //end of namespace Search::Result
	
	namespace Options {
		
class CSearchOptionsPage : public SearchOptionsForm  {
	TQ_OBJECT
  
public:
	CSearchOptionsPage(TQWidget *parent=0, const char *name=0);
	~CSearchOptionsPage();
	/**
	* Sets the search text used in the page.
	*/
	void setSearchText(const TQString& text);
	/**
	* Returns the search text set in this page.
	*/
	const TQString searchText();
	/**
	* Returns the list of used modules.
	*/
	const ListCSwordModuleInfo modules();
	/**
	* Return the selected search type,.
	*/
//	const int searchFlags();
	/**
	* Sets all options back to the default.
	*/
	void reset();
	/**
	* Returns the selected search scope if a search scope was selected.
	*/
	sword::ListKey searchScope();
	/**
	* Returns the selected scope type.
	*/
	//const CSwordModuleSearch::scopeType scopeType();

	TQSize sizeHint() const { return baseSize(); }
	TQSize minimumSizeHint() const { return minimumSize(); }
    bool hasSearchScope();

private:
	ListCSwordModuleInfo m_modules;
	
protected: // Protected methods
	/**
	* Initializes this page.
	*/
	void initView();
	/**
	* Reads the settings of the last searchdialog session.
	*/
	void readSettings();
	/**
	* Reads the settings for the searchdialog from disk.
	*/
	void saveSettings();

public slots: // Public slots
	/**
	* Sets the modules used by the search.
	*/
	void setModules( ListCSwordModuleInfo modules );
	/**
	* Reimplementation.
	*/
	void aboutToShow();
	/**
	* Refreshes the list of ranges and the range combobox. 
	*/
	void refreshRanges();
	/**
	 * Opens the modules chooser dialog.
	 */
	void chooseModules();

protected slots: // Protected slots
	void setupRanges();
	void syntaxHelp();

signals:
	void sigSetSearchButtonStatus(bool);
};

	} //end of namespace Search::Options
} //end of namespace Search

#endif
