/*********
*
* This file is part of BibleTime's source code, http://www.bibletime.info/.
*
* Copyright 1999-2006 by the BibleTime developers.
* The BibleTime source code is licensed under the GNU General Public License version 2.0.
*
**********/


//BibleTime includes
#include "cscrollbutton.h"
#include "cscrollerwidgetset.h"

//BibleTime frontend includes
#include "frontend/cbtconfig.h"

//TQt includes
#include <tqlineedit.h>
#include <tqstring.h>
#include <tqstringlist.h>
#include <tqlistbox.h>
#include <tqtoolbutton.h>
#include <tqevent.h>
#include <tqlayout.h>
#include <tqpainter.h>
#include <tqstyle.h>
#include <tqpixmap.h>
#include <tqapplication.h>
#include <tqtooltip.h>
#include <tqrect.h>
#include <tqlayout.h>

const unsigned int WIDTH = 16;
const unsigned int ARROW_HEIGHT = 12;
const unsigned int MOVER_HEIGHT = 6;

CScrollerWidgetSet::CScrollerWidgetSet(TQWidget *parent, const char *name) : TQWidget(parent,name) {
	m_layout = new TQVBoxLayout(this);
	m_layout->setAlignment(TQt::AlignHCenter | TQt::AlignCenter);

	//setAlignment(TQt::AlignHCenter | TQt::AlignCenter);

	btn_up = new TQToolButton( UpArrow, this, "btn_up" );
	btn_up->setFixedSize(WIDTH, ARROW_HEIGHT);
	btn_up->setFocusPolicy(TQWidget::NoFocus);

	btn_fx = new CScrollButton( this, "btn_fx" );
	btn_fx->setFixedSize(WIDTH, MOVER_HEIGHT);
	btn_fx->setFocusPolicy(TQWidget::NoFocus);

	btn_down = new TQToolButton( DownArrow, this, "btn_down" );
	btn_down->setFixedSize(WIDTH, ARROW_HEIGHT);
	btn_down->setFocusPolicy(TQWidget::NoFocus);
	m_layout->addWidget( btn_up,0 );
	m_layout->addWidget( btn_fx,0 );
	m_layout->addWidget( btn_down,0 );
	setMinimumWidth(WIDTH+4); // Kludge to add some spacing but seems to work.

	connect(btn_fx, TQT_SIGNAL(lock()), TQT_SLOT(slotLock()));
	connect(btn_fx, TQT_SIGNAL(unlock()), TQT_SLOT(slotUnlock()));
	connect(btn_fx, TQT_SIGNAL(change_requested(int)), TQT_SLOT(slotScroller(int)));
	connect(btn_up, TQT_SIGNAL(clicked()), TQT_SLOT(slotUpClick()));
	connect(btn_down, TQT_SIGNAL(clicked()), TQT_SLOT(slotDownClick()));
}

/** Sets the tooltips for the given entries using the parameters as text. */
void CScrollerWidgetSet::setToolTips( const TQString nextEntryTip, const TQString scrollButtonTip, const TQString previousEntryTip) {
	TQToolTip::add (btn_fx,  scrollButtonTip);
	TQToolTip::add (btn_down, nextEntryTip);
	TQToolTip::add (btn_up, previousEntryTip);
}

void CScrollerWidgetSet::slotLock() { emit scroller_pressed(); }
void CScrollerWidgetSet::slotUnlock() { emit scroller_released(); }
void CScrollerWidgetSet::slotScroller(int n) { emit change(n); }
void CScrollerWidgetSet::slotUpClick() { slotScroller(-1); }
void CScrollerWidgetSet::slotDownClick() { slotScroller(1); }

#include "cscrollerwidgetset.moc"
