/*********
*
* This file is part of BibleTime's source code, http://www.bibletime.info/.
*
* Copyright 1999-2006 by the BibleTime developers.
* The BibleTime source code is licensed under the GNU General Public License version 2.0.
*
**********/



#ifndef CBIBLEREADWINDOW_H
#define CBIBLEREADWINDOW_H

//BibleTime includes
#include "clexiconreadwindow.h"

#include "backend/cswordkey.h"
#include "backend/cswordversekey.h"

//TQt includes
#include <tqwidget.h>

//KDE includes
#include <tdeaction.h>


class CTransliterationButton;

/**The read display window for Bibles.
  *@author The BibleTime team
  */

class CBibleReadWindow : public CLexiconReadWindow  {
	TQ_OBJECT
  
public:
	CBibleReadWindow(ListCSwordModuleInfo modules, CMDIArea* parent, const char *name=0);
	virtual ~CBibleReadWindow();
	/**
	* Store the settings of this window in the given CProfileWindow object.
	*/
	virtual void storeProfileSettings( Profile::CProfileWindow* const settings );
	/**
	* Store the settings of this window in the given profile window.
	*/
	virtual void applyProfileSettings( Profile::CProfileWindow* const settings );
	/**
	* Reimplementation.
	*/
	static void insertKeyboardActions( TDEActionCollection* const a );

protected:
	virtual void initActions();
	virtual void initToolbars();
	virtual void initConnections();
	virtual void initView();
	/**
	* Reimplementation.
	*/
	virtual void setupPopupMenu();
	/**
	* Reimplemented.
	*/
	virtual void updatePopupMenu();
	/** Event filter.
	* Reimplementation of the event filter to filter out events like focus in.
	*/
	virtual bool eventFilter( TQObject* o, TQEvent* e);

	struct {
		TDEAction* selectAll;
		TDEAction* findText;
		TDEAction* findStrongs;

		TDEActionMenu* copyMenu;
		struct {
			TDEAction* referenceOnly;
			TDEAction* referenceTextOnly;
			TDEAction* referenceAndText;
			TDEAction* chapter;
			TDEAction* selectedText;
		}
		copy;

		TDEActionMenu* saveMenu;
		struct {
			TDEAction* referenceAndText;
			TDEAction* chapterAsPlain;
			TDEAction* chapterAsHTML;
		}
		save;

		TDEActionMenu* printMenu;
		struct {
			TDEAction* reference;
			TDEAction* chapter;
		}
		print;
	}
	m_actions;


public slots:
	void nextBook();
	void previousBook();
	void nextChapter();
	void previousChapter();
	void nextVerse();
	void previousVerse();
	/**
	* Refreshes the content of this display window and the content of the keychooser.
	*/
	virtual void reload();

protected slots: // Protected slots
	/**
	* Copies the current chapter into the clipboard.
	*/
	void copyDisplayedText();
	/**
	* Saves the chapter as valid HTML page.
	*/
	void saveChapterHTML();
	/**
	* Saves the chapter as valid HTML page.
	*/
	void saveChapterPlain();
	virtual void lookup( CSwordKey* newKey );
	void syncWindows();

private:
	friend class CCommentaryReadWindow;
	/**
	* Wrapper around key() to return the right type of key.
	*/
	CSwordVerseKey* verseKey();

	//  CTransliterationButton* m_transliterationButton;
};

#endif
