/***************************************************************************
    smb4kmountdialog  -  This class provides a dialog for mounting shares
    manually.
                             -------------------
    begin                : Mo Nov 29 2004
    copyright            : (C) 2004-2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KMOUNTDIALOG_H
#define SMB4KMOUNTDIALOG_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// TQt includes
#include <tqcheckbox.h>

// KDE includes
#include <kdialogbase.h>
#include <klineedit.h>

/**
 * This class provides a dialog with which you can mount shares "manually".
 *
 * @author Alexander Reinholdt <dustpuppy@users.berlios.de>
 */

class Smb4KMountDialog : public KDialogBase
{
  TQ_OBJECT
  

  public:
    /**
     * The constructor.
     */
    Smb4KMountDialog( TQWidget *parent = 0, const char *name = 0 );
    /**
     * The destructor.
     */
    ~Smb4KMountDialog();

  protected slots:
    /**
     * Reimplemented from KDialogBase.
     */
    void slotOk();

    /**
     * Reimplemented from KDoalogBase.
     */
    void slotCancel();

    /**
     * This slot is being enabled if there is input text.
     *
     * @param text        The input text.
     */
    void slotChangeInputValue( const TQString &text );

    /**
     * This slot is connected to the Smb4KCore::mounter()::state() signal.
     * It is used to close the dialog.
     *
     * @param state       The state of the mounter.
     */
    void slotMounterStateChanged( int state );

  private:
    /**
     * This function sets up the view.
     */
    void setupView();
    /**
     * The line edit where the user has to enter the share.
     */
    KLineEdit *m_share_input;
    /**
     * The line edit where the user can enter the IP address.
     */
    KLineEdit *m_ip_input;
    /**
     * The line edit where the user can enter the workgroup.
     */
    KLineEdit *m_workgroup_input;
    /**
     * This checkbox determines whether the share should be added to the
     * bookmarks.
     */
    TQCheckBox *m_bookmark;
};

#endif
