/***************************************************************************
*   Copyright (C) 2004 by Christoph Thielecke                             *
*   crissi99@gmx.de                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/ 
//BEGIN INCLUDES
#include "utils.h"
#include <tqstring.h>
#include <tqapplication.h>
#include <iostream>
#include <tqfile.h>
#include <tqprocess.h>
#include <tqstring.h>
#include <tdelocale.h>
#include <ksimpleconfig.h>
#include <tqdir.h>
#include <kstddirs.h>
#include <kdebug.h>
#include <kstandarddirs.h>
#include <netdb.h> // name resolving
#include <arpa/inet.h>
#include <tqregexp.h>
#include <tdemessagebox.h>

//END INCLUDES

Utils::Utils( KVpncConfig* config, TQObject *parent, const char *name )
		: TQObject( parent, name )
{
	env = new TQStringList();
	*env << "LC_ALL=C" << "LANG=C" << "PATH=/bin:/usr/bin:/usr/sbin:/sbin";
	this->config = config;
	retrieveValidNetworkdevice = false;
}

Utils::~Utils()
{
	// 	if(createProcess!=0)
	// 		delete createProcess;
	//
	// 	if (NetworkDeviceTestProcess!=0)
	// 		delete NetworkDeviceTestProcess;
}

bool Utils::isValidIPv4Address( TQString Address )
{
	if ( Address.contains( '.' ) != 3 )
		return false;
	else
	{
		//std::cout << "test1 succeed.\n";
		TQString addr = Address;
		int part0 = addr.section( '.', 0, 0 ).toInt();
		int part1 = addr.section( '.', 1, 1 ).toInt();
		int part2 = addr.section( '.', 2, 2 ).toInt();
		int part3 = addr.section( '.', 3, 3 ).toInt();

		//std::cout << "part0 " << part0 << ", part1 " << part1 <<  ", part2 " << part2 << ", part3 " << part3 << "\n";

		if ( ( part0 > 1 && part0 < 255 ) &&
		        ( part1 >= 0 && part1 < 255 ) &&
		        ( part2 >= 0 && part2 < 255 ) &&
		        ( part3 >= 0 && part3 < 255 ) )
			return true;
		else
			return false;
	}
}

bool Utils::isValidIPv4NetworkAddress( TQString Address )
{
	if ( isValidIPv4Address ( Address ) )
	{
		if ( Address.section( '.', 3, 3 ).toInt() == 0 )
			return true;
		else
			return false;
	}
	else
		return false;
}

bool Utils::isValidIPv4BroadcastAddress( TQString Address )
{
	if ( isValidIPv4Address ( Address ) )
	{
		if ( Address.section( '.', 3, 3 ).toInt() == 255 )
			return true;
		else
			return false;
	}
	else
		return false;
	return false;
}

bool Utils::isValidIPv4Netmask(TQString Netmask)
{
	if ( Netmask.contains( '.' ) != 3 )
		return false;
	else
	{
		//std::cout << "test1 succeed.\n";
		TQString addr = Netmask;
		int part0 = addr.section( '.', 0, 0 ).toInt();
		int part1 = addr.section( '.', 1, 1 ).toInt();
		int part2 = addr.section( '.', 2, 2 ).toInt();
		int part3 = addr.section( '.', 3, 3 ).toInt();

		//std::cout << "part0 " << part0 << ", part1 " << part1 <<  ", part2 " << part2 << ", part3 " << part3 << "\n";

		if ( ( part0 > 254 && part0 <= 255 ) &&
		        ( part1 > 254 && part1 <= 255 ) &&
		        ( part2 >= 0 && part2 <= 255 ) &&
		        ( part3 >= 0 && part3 <= 253 ) )
			return true;
		else
			return false;
	}
}

bool Utils::tunDevExists()
{
	if ( TQFile ( "/dev/net/tun" ).exists() )
		return true;
	else
		return false;
}

bool Utils::createTunDev()
{
	createProcess = new TQProcess( this );
	connect( createProcess, TQT_SIGNAL( readyReadStdout() ), this, TQT_SLOT( readStdOutCreateTunDev() ) );
	connect( createProcess, TQT_SIGNAL( readyReadStderr() ), this, TQT_SLOT( readStdErrCreateTunDev() ) );

	// step one: create directory
	if ( !TQDir ( "/dev/net" ).exists() )
	{
		createProcess->addArgument("mkdir") ;
		//createProcess->addArgument("-p");
		createProcess->addArgument( "/dev/net" );


		if ( !createProcess->start(env) ) {
			disconnect( createProcess, TQT_SIGNAL( readyReadStdout() ), this, TQT_SLOT( readStdOutCreateTunDev() ) );
			disconnect( createProcess, TQT_SIGNAL( readyReadStderr() ), this, TQT_SLOT( readStdErrCreateTunDev() ) );
			delete createProcess;
			createProcess=0L;
			kdError() << "Unable to create tunnel device file!" << endl;
			return false;
		}
		else
		{
			// 		while(createProcess->isRunning())
			// 		{ };
			sleep ( 2 );
		}
	}

	// step two: create device node
	createProcess->clearArguments();
	createProcess->addArgument( "/bin/mknod" );
	createProcess->addArgument( "/dev/net/tun" );
	createProcess->addArgument( "c" );
	createProcess->addArgument( "10" );
	createProcess->addArgument( "200" );

	if ( !createProcess->start(env) )
	{
		disconnect( createProcess, TQT_SIGNAL( readyReadStdout() ), this, TQT_SLOT( readStdOutCreateTunDev() ) );
		disconnect( createProcess, TQT_SIGNAL( readyReadStderr() ), this, TQT_SLOT( readStdErrCreateTunDev() ) );
		delete createProcess;
		createProcess = 0L;
		kdError() << "Unable to create tunnel device file!" << endl;
		return false;
	}
	else
	{
		while ( createProcess->isRunning() )
		{
			sleep ( 1 );
		}
		disconnect( createProcess, TQT_SIGNAL( readyReadStdout() ), this, TQT_SLOT( readStdOutCreateTunDev() ) );
		disconnect( createProcess, TQT_SIGNAL( readyReadStderr() ), this, TQT_SLOT( readStdErrCreateTunDev() ) );
		delete createProcess;
		createProcess = 0L;
		return true;
	}
	return false;
}

bool Utils::loadKernelModule( TQString Name, TQApplication *app )
{
	if ( !Name.isEmpty() )
	{
		modprobeSuccess = true;
		ModprobeProcess = new TQProcess( this );
		ModprobeProcess->addArgument( "/sbin/modprobe" );
		ModprobeProcess->addArgument( Name );

		connect( ModprobeProcess, TQT_SIGNAL( readyReadStdout() ), this, TQT_SLOT( readStdOutLoadKernelModule() ) );
		connect( ModprobeProcess, TQT_SIGNAL( readyReadStderr() ), this, TQT_SLOT( readStdErrLoadKernelModule() ) );
		if ( !ModprobeProcess->start( env ) ) {
			disconnect( ModprobeProcess, TQT_SIGNAL( readyReadStdout() ), this, TQT_SLOT( readStdOutLoadKernelModule() ) );
			disconnect( ModprobeProcess, TQT_SIGNAL( readyReadStderr() ), this, TQT_SLOT( readStdErrLoadKernelModule() ) );
			delete ModprobeProcess;
			ModprobeProcess = 0L;
			return modprobeSuccess;
			kdError() << "Unable to start kernel module loading process!" << endl;
			return false;
		}
		else
		{
			while ( ModprobeProcess && ModprobeProcess->isRunning() )
			{
				if (config->appPointer->hasPendingEvents())
					config->appPointer->processEvents();
				usleep(250);
			}
			disconnect( ModprobeProcess, TQT_SIGNAL( readyReadStdout() ), this, TQT_SLOT( readStdOutLoadKernelModule() ) );
			disconnect( ModprobeProcess, TQT_SIGNAL( readyReadStderr() ), this, TQT_SLOT( readStdErrLoadKernelModule() ) );
			delete ModprobeProcess;
			ModprobeProcess = 0L;
			return modprobeSuccess;
		}

	}
	else
		return false;
}

bool Utils::unloadKernelModule( TQString Name, TQApplication *app , bool force)
{
	if ( !Name.isEmpty() )
	{
		modprobeSuccess = true;
		ModprobeProcess = new TQProcess( this );
		ModprobeProcess->addArgument( "/sbin/rmmod" );

		if (force == true)
			ModprobeProcess->addArgument( "-f" );

		ModprobeProcess->addArgument( Name );

		connect( ModprobeProcess, TQT_SIGNAL( readyReadStdout() ), this, TQT_SLOT( readStdOutLoadKernelModule() ) );
		connect( ModprobeProcess, TQT_SIGNAL( readyReadStderr() ), this, TQT_SLOT( readStdErrLoadKernelModule() ) );
		if ( !ModprobeProcess->start( env ) ) {
			disconnect( ModprobeProcess, TQT_SIGNAL( readyReadStdout() ), this, TQT_SLOT( readStdOutLoadKernelModule() ) );
			disconnect( ModprobeProcess, TQT_SIGNAL( readyReadStderr() ), this, TQT_SLOT( readStdErrLoadKernelModule() ) );
			delete ModprobeProcess;
			ModprobeProcess = 0L;
			return modprobeSuccess;
			kdError() << "Unable to start kernel module loading process!" << endl;
			return false;
		}
		else
		{
			while ( ModprobeProcess->isRunning() )
			{
				if (config->appPointer->hasPendingEvents())
					config->appPointer->processEvents();
				usleep(250);
			}
			disconnect( ModprobeProcess, TQT_SIGNAL( readyReadStdout() ), this, TQT_SLOT( readStdOutLoadKernelModule() ) );
			disconnect( ModprobeProcess, TQT_SIGNAL( readyReadStderr() ), this, TQT_SLOT( readStdErrLoadKernelModule() ) );
			delete ModprobeProcess;
			ModprobeProcess = 0L;
			return modprobeSuccess;
		}

	}
	else
		return false;
}

bool Utils::doChmod( TQString file, TQString mode )
{
	config->appendLogEntry ( i18n( "\"%1\" begin." ).arg("chmod"),config->info );
	TDEProcess *chmodProcess =  new TDEProcess;
	*chmodProcess << "/bin/chmod";
	*chmodProcess <<  mode;
	*chmodProcess << file;

	if ( !chmodProcess->start() )
	{
		// KMessageBox::sorry( this, i18n( "\"%1\" start failed!" ).arg( "PppdUpScript" ) );
		config->appendLogEntry( i18n( "Chmod of %1 failed!" ).arg( file ), config->error );
		delete chmodProcess;
		return false;
	}
	else
	{
		if ( config->KvpncDebugLevel > 0 )
			config->appendLogEntry ( i18n( "chmod of %1 (%2) started." ).arg( file ).arg( mode ) , config->debug );
		int max_count = 9;
		int count=0;
		while ( count < max_count && chmodProcess->isRunning() )
		{
			if ( config->KvpncDebugLevel > 6 )
				config->appendLogEntry ( i18n( "chmod of %1 (%2) running." ).arg( file ).arg( mode ) , config->debug );
			usleep ( 250 );
			if ( config->appPointer->hasPendingEvents () )
				config->appPointer->processEvents();
			count++;
		}
		config->appendLogEntry ( i18n( "\"%1\" finished." ).arg("chmod"),config->info );
		delete chmodProcess;
		return true;
	}
}

bool Utils::resolvConfAvailable()
{
	bool resolvConfAvailable=false;
	if (TQFile("/sbin/resolvconf").exists() && TQFile("/etc/init.d/resolvconf").exists())
		resolvConfAvailable=true;
	else
		resolvConfAvailable=false;
	return resolvConfAvailable;
}

TQPtrList<ToolInfo>* Utils::getToolList()
{
	TQPtrList<ToolInfo> *ToolList = new TQPtrList<ToolInfo>();

	//TODO move to KVpncConfig
	TQStringList *ToolNamesList = new TQStringList();
	ToolNamesList->append( "vpnc" );
	ToolNamesList->append( "vpnclient" );
	ToolNamesList->append( "racoon" );
	ToolNamesList->append( "racoonctl" );
	ToolNamesList->append( "ipsec" ); // freeswan
	ToolNamesList->append( "pppd" );
	ToolNamesList->append( "pptp" );
	ToolNamesList->append( "l2tpd" );
	ToolNamesList->append( "xl2tpd" );
	ToolNamesList->append( "openl2tpd" );
	ToolNamesList->append( "setkey" );
	ToolNamesList->append( "iptables" );
	ToolNamesList->append( "openssl" );
	ToolNamesList->append( "openvpn" );
	ToolNamesList->append( "kill" );
	ToolNamesList->append( "killall" );
	ToolNamesList->append( "ping" );
	ToolNamesList->append( "ip" );
	ToolNamesList->append( "ifconfig" );
	ToolNamesList->append( "route" );
	ToolNamesList->append( "pkcs11-tool" );
	ToolNamesList->append( "bash" );
	ToolNamesList->append( "vtund" );
	ToolNamesList->append( "cisco_cert_mgr" );
	ToolNamesList->append( "tail" );
	ToolNamesList->append( "ssh" );
	ToolNamesList->append( "ksshaskpass" );
	ToolNamesList->append( "gnome-ssh-askpass" );
	ToolNamesList->append( "racoonctl" );
	ToolNamesList->append( "netstat" );

	ToolInfo *currentTool;
	for ( TQStringList::Iterator it = ToolNamesList->begin(); it != ToolNamesList->end(); it++ ) {
		//std::cout << "tool: " << *it << std::endl;

		currentTool = new ToolInfo( *it );
		currentTool->programsInPath =config->programsInPath;
		if ( currentTool->Name == "vpnc" )
			currentTool->TryPath_first = config->pathToVpnc;
		else if (currentTool->Name == "vpnclient")
			currentTool->TryPath_first = config->pathToCiscoVpnc;
		else	if ( currentTool->Name == "ipsec" )
			currentTool->TryPath_first = config->pathToIpsec;
		else	if ( currentTool->Name == "racoon" )
			currentTool->TryPath_first = config->pathToRacoon;
		else	if ( currentTool->Name == "racoonctl" )
			currentTool->TryPath_first = config->pathToRacoonctl;
		else	if ( currentTool->Name == "setkey" )
			currentTool->TryPath_first = config->pathToSetkey;
		else	if ( currentTool->Name == "openvpn" )
			currentTool->TryPath_first = config->pathToOpenvpn;
		else	if ( currentTool->Name == "openssl" )
			currentTool->TryPath_first = config->pathToOpenssl;
		else	if ( currentTool->Name == "pppd" )
			currentTool->TryPath_first = config->pathToPppd;
		else	if ( currentTool->Name == "iptables" )
			currentTool->TryPath_first = config->pathToIptables;
		else	if ( currentTool->Name == "kill" )
			currentTool->TryPath_first = config->pathToKill;
		else	if ( currentTool->Name == "killall" )
			currentTool->TryPath_first = config->pathToKillall;
		else	if ( currentTool->Name == "ping" )
			currentTool->TryPath_first = config->pathToPing;
		else	if ( currentTool->Name == "ip" )
			currentTool->TryPath_first = config->pathToIp;
		else	if ( currentTool->Name == "ifconfig" )
			currentTool->TryPath_first = config->pathToIfconfig;
		else	if ( currentTool->Name == "route" )
			currentTool->TryPath_first = config->pathToRoute;
		else	if ( currentTool->Name == "pptp" )
			currentTool->TryPath_first = config->pathToPptp;
		else	if ( currentTool->Name == "l2tpd" )
			currentTool->TryPath_first = config->pathToL2tpd;
		else	if ( currentTool->Name == "pkcs11-tool" )
			currentTool->TryPath_first = config->pathToPkcs11Tool;
		else	if ( currentTool->Name == "bash" )
			currentTool->TryPath_first = config->InterpreterShell;
		else	if ( currentTool->Name == "vtund" )
			currentTool->TryPath_first = config->pathToVtund;
		else if ( currentTool->Name == "cisco_cert_mgr" )
			currentTool->TryPath_first = config->pathToCiscoCertMgr;
		else if ( currentTool->Name == "tail" )
			currentTool->TryPath_first = config->pathToTail;
		else if ( currentTool->Name == "ssh" )
			currentTool->TryPath_first = config->pathToSsh;
		else if ( currentTool->Name == "ksshaskpass" )
			currentTool->TryPath_first = config->pathToKsshAskpass;
		else if ( currentTool->Name == "gnome-ssh-askpass" )
			currentTool->TryPath_first = config->pathToGnomeSshAskpass;
		else if ( currentTool->Name == "racoonctl" )
			currentTool->TryPath_first = config->pathToRacoonctl;
		else if ( currentTool->Name == "netstat" )
			currentTool->TryPath_first = config->pathToNetstat;

		currentTool->collectToolInfo();
		ToolList->append( currentTool );
		
		//currentTool=0L;
		// 			std::cout << "tool: " << currentTool->Name << std::endl;
		// 			std::cout << "Version: " << currentTool->Version << std::endl;
		// 			std::cout << "Path: " << currentTool->PathToExec << std::endl << std::endl;
	}
	ToolList->sort();

	return ToolList;

}

ToolInfo* Utils::getToolInfo( TQString name )
{
	ToolInfo * Tool = 0;
	for ( Tool = config->ToolList->first();Tool;Tool = config->ToolList->next() )
	{
		if ( Tool->Name == name )
			break;
	}
	return Tool;
}

TQString Utils::resolveName( TQString Name )
{
	resolvedIP = "";
	resolveFinished = false;

	struct hostent * server_entry;

	// get ip address to server name
	if ( ( server_entry = gethostbyname( Name.ascii() ) ) == NULL )
	{
		std::cout << "gethostbyname failed" << std::endl;
	}
	else
		resolvedIP = TQString( inet_ntoa( *( struct in_addr* ) server_entry->h_addr_list[ 0 ] ) );
	return resolvedIP;
}

TQString Utils::removeSpecialCharsForFilename( TQString filename )
{
	filename.replace( TQRegExp( "[*]+" ), "_" );
	filename.replace( TQRegExp( "[+] +" ), "_" );
	filename.replace( TQRegExp( "[$]+" ), "_" );
	filename.replace( TQRegExp( ":+" ), "_" );
	filename.replace( TQRegExp( "ï¿œ" ), "_" );
	filename.replace( TQRegExp( "ï¿œ" ), "_" );
	filename.replace( TQRegExp( "+" ), "_" );
	filename.replace( TQRegExp( "ï¿œ" ), "_" );
	filename.replace( TQRegExp( "ï¿œ" ), "_" );
	filename.replace( TQRegExp( "ï¿œ" ), "_" );
	filename.replace( TQRegExp( "ï¿œ" ), "_" );
	filename.replace( "\\" , "_" );
	filename.replace( "/" , "_" );
	filename.replace( TQRegExp( ";+" ), "_" );
	filename.replace( TQRegExp( " " ), "_" );
	filename.replace( TQRegExp( "_+" ), "_" );
	filename.replace(  ")" , "_" );
	filename.replace(  "(" , "_" );
	filename.replace(  " " , "_" );
	return filename;
}

TQStringList Utils::getOpenvpnCiphers()
{
	OpenvpnCiphers.clear();
	retrieveOpenvpnCiphers = false;

	ToolInfo *OpenvpnInfo = getToolInfo ( "openvpn" );
	TQString pathToOpenvpn = OpenvpnInfo->PathToExec;

	if ( pathToOpenvpn.isEmpty() )
		return OpenvpnCiphers;

	OpenvpnCiphersProcess = new TQProcess( this );
	OpenvpnCiphersProcess->addArgument( pathToOpenvpn );
	OpenvpnCiphersProcess->addArgument( "--show-ciphers" );

	connect( OpenvpnCiphersProcess, TQT_SIGNAL( readyReadStdout() ), this, TQT_SLOT( readStdOutRetriveOpenvpnCiphers() ) );
	connect( OpenvpnCiphersProcess, TQT_SIGNAL( readyReadStderr() ), this, TQT_SLOT( readStdErrRetriveOpenvpnCiphers() ) );

	if ( !OpenvpnCiphersProcess->start( env ) ) {

		disconnect( OpenvpnCiphersProcess, TQT_SIGNAL( readyReadStdout() ), this, TQT_SLOT( readStdOutRetriveOpenvpnCiphers() ) );
		disconnect( OpenvpnCiphersProcess, TQT_SIGNAL( readyReadStderr() ), this, TQT_SLOT( readStdErrRetriveOpenvpnCiphers() ) );
		delete OpenvpnCiphersProcess;
		OpenvpnCiphersProcess=0L;
		kdError() << "Unable to fetch openvpn ciphers!" << endl;
		return 0;
	}
	else
	{
		while ( OpenvpnCiphersProcess->isRunning() )
		{
			config->appPointer->processEvents();
			sleep ( 1 );
		}
		disconnect( OpenvpnCiphersProcess, TQT_SIGNAL( readyReadStdout() ), this, TQT_SLOT( readStdOutRetriveOpenvpnCiphers() ) );
		disconnect( OpenvpnCiphersProcess, TQT_SIGNAL( readyReadStderr() ), this, TQT_SLOT( readStdErrRetriveOpenvpnCiphers() ) );
		delete OpenvpnCiphersProcess;
		OpenvpnCiphersProcess=0L;
	}
	return OpenvpnCiphers;
}

Utils::IpsecAlgos Utils::getIpsecAlgos()
{

	IpsecAlgos salgos;
	salgos.IpsecIkeEncryptionAlgorithms.clear();
	salgos.IpsecIkeHashAlgorithms.clear();
	salgos.IpsecIkeDhGroups.clear();
	salgos.IpsecEspEncryptionAlgorithms.clear();
	salgos.IpsecEspAuthenticationAlgorithms.clear();
	salgos.IpsecCompressionAlgorithms.clear();
	IpsecAlgoCurrent="";
	retrieveIpsecAlgos = false;

	ToolInfo *IpsecInfo = getToolInfo ( "ipsec" );
	TQString pathToIpsec = IpsecInfo->PathToExec;

	if ( pathToIpsec.isEmpty() )
		return salgos;

	IpsecAlgosProcess = new TQProcess( this );
	IpsecAlgosProcess->addArgument( pathToIpsec);
	IpsecAlgosProcess->addArgument( "auto" );
	IpsecAlgosProcess->addArgument( "--status" );

	connect( IpsecAlgosProcess, TQT_SIGNAL( readyReadStdout() ), this, TQT_SLOT( readStdOutRetriveIpsecAlgos() ) );
	connect( IpsecAlgosProcess, TQT_SIGNAL( readyReadStderr() ), this, TQT_SLOT( readStdErrRetriveIpsecAlgos() ) );

	if ( !IpsecAlgosProcess->start( env ) ) {
	disconnect( IpsecAlgosProcess, TQT_SIGNAL( readyReadStdout() ), this, TQT_SLOT( readStdOutRetriveIpsecAlgos() ) );
	disconnect( IpsecAlgosProcess, TQT_SIGNAL( readyReadStderr() ), this, TQT_SLOT( readStdErrRetriveIpsecAlgos() ) );
	delete IpsecAlgosProcess;
	IpsecAlgosProcess=0L;
		kdError() << "Unable to fetch ipsec algos!" << endl;
		return salgos;
	}
	else
	{
		while ( IpsecAlgosProcess->isRunning() )
		{
			config->appPointer->processEvents();
			sleep ( 1 );
		}
		disconnect( IpsecAlgosProcess, TQT_SIGNAL( readyReadStdout() ), this, TQT_SLOT( readStdOutRetriveIpsecAlgos() ) );
		disconnect( IpsecAlgosProcess, TQT_SIGNAL( readyReadStderr() ), this, TQT_SLOT( readStdErrRetriveIpsecAlgos() ) );
		delete IpsecAlgosProcess;
		IpsecAlgosProcess=0L;
	}
	return salgos;
}

Utils::PppdCapabilities Utils::checkPppdCapabilities()
{
		pppdcap.pppdHasMppeRequiredSupport=false;
		pppdcap.pppdHasRequireMppeSupport=false;
		pppdcap.pppdHasReplacedefaultrouteSupport=false;
		pppdcap.pppdHasMppeSupport=false;
		pppdcap.oldPppdStyle=false;
		pppdcap.pppdOk=false;

		// test mppe support of pppd
		testPppdRequireMppe=true;
		testPppdReplacedefaultroute=false;
		testPppdMppeRequiredSupport=false;
		testOldPppdStyle=false;
		testPppdRequireMppe=false;
		testPppdMppeRequired=false;


		/* get pppd info */
		int pppd_version_major = 0;
		int pppd_version_minor = 0;
		int pppd_version_subminor = 0;

		ToolInfo *Tool = Utils ( config ).getToolInfo ( "pppd" );
		if ( !Tool->Version.isEmpty() )
		{
			pppd_version_major = ( Tool->Version.section ( '.', 0, 0 ) ).toInt();
			pppd_version_minor = ( Tool->Version.section ( '.', 1, 1 ) ).toInt();
			pppd_version_subminor = ( Tool->Version.section ( '.', 2, 2 ) ).toInt();
			if ( config->KvpncDebugLevel > 5 )
			{
				config->appendLogEntry ( i18n ( "pppd version (major): \"%1\"" ).arg ( pppd_version_major ) , config->debug );
				config->appendLogEntry ( i18n ( "pppd version (minor): \"%1\"" ).arg ( pppd_version_minor ) , config->debug );
				config->appendLogEntry ( i18n ( "pppd version (subminor): \"%1\"" ).arg ( pppd_version_subminor ) , config->debug );
			}
		}

		if ( pppd_version_major <2 || (pppd_version_major ==2 && pppd_version_minor < 4  )  )
		{
			// pppd < 2.4.0
			if ( config->KvpncDebugLevel > 5 )
				config->appendLogEntry ( i18n ( "pppd version is lower than 2.4.0" ) , config->debug );
			
			pppdcap.RequireMppeOption="";
			pppdcap.Require128BitMppeOption="";
			pppdcap.RefuseMppeOption="";
			pppdcap.Refuse40BitMppeOption="";
			pppdcap.Refuse128BitMppeOption="";

			pppdcap.RequireStatelessOption="";
			pppdcap.RequireStatefulOption="";
			pppdcap.MppeOptionsInALine = false;
			pppdcap.RequireAuthMschapOption="";
			pppdcap.RequireAuthMschapv2Option="";
			pppdcap.RequireAuthPapOption="";
		}

		if  (pppd_version_major ==2 && pppd_version_minor == 4  && (pppd_version_subminor == 0  || pppd_version_subminor == 0 ) )
		{
			// pppd == 2.4.0/2.4.1
			if ( config->KvpncDebugLevel > 5 )
				config->appendLogEntry ( i18n ( "pppd version is 2.4.0" ) , config->debug );
			
			pppdcap.RequireMppeOption="mppe-40";
			pppdcap.Require128BitMppeOption="mppe-128";
			pppdcap.RefuseMppeOption="";
			pppdcap.Refuse40BitMppeOption="";
			pppdcap.Refuse128BitMppeOption="";

			pppdcap.RequireStatelessOption="mppe-stateless";
			pppdcap.RequireStatefulOption="";
			pppdcap.MppeOptionsInALine = false;
			pppdcap.RequireAuthChapOption="";
			pppdcap.RequireAuthChapOption+="require-chap\n";
			pppdcap.RequireAuthChapOption+="refuse-chapms\n";
			pppdcap.RequireAuthChapOption+="refuse-chapms-v2\n";
			pppdcap.RequireAuthChapOption+="refuse-pap\n";
			pppdcap.RequireAuthChapOption+="refuse-eap";
			pppdcap.RequireAuthMschapOption="";
// 			pppdcap.RequireAuthMschapOption+="refuse-chap\n";
			pppdcap.RequireAuthMschapOption+="require-chapms\n";
// 			pppdcap.RequireAuthMschapOption+="require-chapms-v2\n";
			pppdcap.RequireAuthMschapOption+="refuse-pap\n";
			pppdcap.RequireAuthMschapOption+="refuse-eap";
			pppdcap.RequireAuthMschapv2Option="";
// 			pppdcap.RequireAuthMschapv2Option+="refuse-chap\n";
// 			pppdcap.RequireAuthMschapv2Option+="refuse-chapms\n";
			pppdcap.RequireAuthMschapv2Option+="require-chapms-v2\n";
			pppdcap.RequireAuthMschapv2Option+="refuse-pap\nrefuse-eap";
			pppdcap.RequireAuthPapOption="";
			pppdcap.RequireAuthPapOption+="require-pap\n";
			pppdcap.RequireAuthPapOption+="refuse-chap\n";
			pppdcap.RequireAuthPapOption+="refuse-chapms-v2\n";
			pppdcap.RequireAuthPapOption+="refuse-chapms-v2\n";
			pppdcap.RequireAuthPapOption+="refuse-eap";
		}

		if ( ( pppd_version_major ==2 && pppd_version_minor == 4 && pppd_version_subminor >= 2) || pppd_version_major >2  )
		{
			// pppd >= 2.4.2
			if ( config->KvpncDebugLevel > 5 )
				config->appendLogEntry ( i18n ( "pppd version is >= 2.4.2, good" ) , config->debug );
			
			pppdcap.RequireMppeOption="require-mppe";
			pppdcap.Require128BitMppeOption="require-mppe-128";
			pppdcap.RefuseMppeOption="nomppe";
			pppdcap.Refuse40BitMppeOption="nomppe-40";
			pppdcap.Refuse128BitMppeOption="nomppe-128";

			pppdcap.RequireStatelessOption="nomppe-stateful";
			pppdcap.RequireStatefulOption="";
			pppdcap.MppeOptionsInALine = false;
			pppdcap.RequireAuthChapOption="";
			pppdcap.RequireAuthChapOption+="refuse-pap\n";
			pppdcap.RequireAuthChapOption+="refuse-mschap\n";
			pppdcap.RequireAuthChapOption+="refuse-mschap-v2\n";
			pppdcap.RequireAuthChapOption+="refuse-eap";
			pppdcap.RequireAuthMschapOption="";
			pppdcap.RequireAuthMschapOption+="refuse-pap\n";
// 			pppdcap.RequireAuthMschapOption+="refuse-chap\n";
// 			pppdcap.RequireAuthMschapOption+="refuse-mschap-v2\n";
			pppdcap.RequireAuthMschapOption+="refuse-eap";
			pppdcap.RequireAuthMschapv2Option="";
			pppdcap.RequireAuthMschapv2Option+="refuse-pap\n";
			pppdcap.RequireAuthMschapv2Option+="refuse-chap\n";
			pppdcap.RequireAuthMschapv2Option+="refuse-mschap\n";
			pppdcap.RequireAuthMschapv2Option+="refuse-eap";
			pppdcap.RequireAuthPapOption="";
			pppdcap.RequireAuthPapOption+="refuse-mschap\n";
			pppdcap.RequireAuthPapOption+="refuse-mschap-v2\n";
			pppdcap.RequireAuthPapOption+="refuse-chap\n";
			pppdcap.RequireAuthPapOption+="refuse-eap";
		}


		/* mppe test */

		pppdcap.pppdHasMppeRequiredSupport=true;
		pppdcap.pppdHasRequireMppeSupport=true;
		pppdcap.pppdHasMppeSupport=true;
		// first: new style
		testOldPppdStyle = false;
		testPppdRequireMppe=true;
		testPppdMppeRequired=false;
		TestPppdProcess = new TQProcess ( this );
		TestPppdProcess->addArgument ( config->pathToPppd );
		TestPppdProcess->addArgument ( "/dev/null" );
		TestPppdProcess->addArgument ( "require-mppe" );

		TestPppdProcess->setCommunication ( TQProcess::Stdin | TQProcess::Stdout | TQProcess::Stderr | TQProcess::DupStderr );
		TestPppdProcess->closeStdin ();

		connect ( TestPppdProcess, TQT_SIGNAL ( readyReadStdout() ), this, TQT_SLOT ( readPppdtestProcessOutput() ) );
// 		connect ( TestPppdProcess, TQT_SIGNAL ( readyReadStderr() ), this, TQT_SLOT ( readPppdtestProcessOutput() ) );
		
		if ( !TestPppdProcess->start ( env ) )
		{
			config->appendLogEntry ( i18n ( "unable to start proc (%1)!" ).arg ( i18n ( "Test require-mppe support of pppd" ) ) , KVpncConfig::error );
			pppdcap.pppdOk=false;
		}
		else
		{
			pppdcap.pppdOk=true;
			while ( TestPppdProcess->isRunning() )
				config->appPointer->processEvents();


			if (pppdcap.pppdHasRequireMppeSupport)
			{
				if ( config->KvpncDebugLevel > 0 )
					config->appendLogEntry ( "pppdHasRequireMppeSupport: true", config->debug );
				pppdcap.RequireMppeOption="require-mppe";
				pppdcap.Require128BitMppeOption="require-mppe-128";
				pppdcap.RefuseMppeOption="nomppe";
				pppdcap.Refuse40BitMppeOption="nomppe-40";
				pppdcap.Refuse128BitMppeOption="nomppe-128";
			}
			else
				config->appendLogEntry ( "pppdHasRequireMppeSupport: false", config->debug );

		}
		disconnect ( TestPppdProcess, TQT_SIGNAL ( readyReadStdout() ), this, TQT_SLOT ( readPppdtestProcessOutput() ) );
// 		disconnect ( TestPppdProcess, TQT_SIGNAL ( readyReadStderr() ), this, TQT_SLOT ( readPppdtestProcessOutput() ) );

		delete TestPppdProcess;
		TestPppdProcess=0L;
		testPppdRequireMppe=false;
		testPppdMppeRequired=true;

		
		TestPppdProcess = new TQProcess ( this );
		TestPppdProcess->addArgument ( config->pathToPppd );
		TestPppdProcess->addArgument ( "/dev/null" );
		TestPppdProcess->addArgument ( "mppe");
		TestPppdProcess->addArgument ( "required" );

		TestPppdProcess->setCommunication ( TQProcess::Stdin | TQProcess::Stdout | TQProcess::Stderr | TQProcess::DupStderr );
		TestPppdProcess->closeStdin ();

		connect ( TestPppdProcess, TQT_SIGNAL ( readyReadStdout() ), this, TQT_SLOT ( readPppdtestProcessOutput() ) );
// 		connect ( TestPppdProcess, TQT_SIGNAL ( readyReadStderr() ), this, TQT_SLOT ( readPppdtestProcessOutput() ) );
		
		if ( !TestPppdProcess->start ( env ) )
		{
			config->appendLogEntry ( i18n ( "unable to start proc (%1)!" ).arg ( i18n ( "Test mppe required support of pppd" ) ), KVpncConfig::error );
			pppdcap.pppdOk=false;
		}
		else
		{
			pppdcap.pppdOk=true;
			while ( TestPppdProcess->isRunning() )
		{
				config->appPointer->processEvents();
			sleep ( 1 );
		}
			if (pppdcap.pppdHasMppeRequiredSupport)
			{
				if ( config->KvpncDebugLevel > 0 )
						config->appendLogEntry ( "PppdMppeRequired: true", config->debug );

				pppdcap.MppeOptionsInALine = true;

				pppdcap.RequireMppeOption="mppe required";
				pppdcap.Require128BitMppeOption="";
				pppdcap.RefuseMppeOption="nomppe";
				pppdcap.Refuse40BitMppeOption=",no40";
				pppdcap.Refuse128BitMppeOption=",no128";
				pppdcap.RequireStatefulOption="";
				pppdcap.RequireStatelessOption=",stateless";

			}
			else
				config->appendLogEntry ( "PppdMppeRequired: false", config->debug );
		}

		disconnect ( TestPppdProcess, TQT_SIGNAL ( readyReadStdout() ), this, TQT_SLOT ( readPppdtestProcessOutput() ) );
// 		disconnect ( TestPppdProcess, TQT_SIGNAL ( readyReadStderr() ), this, TQT_SLOT ( readPppdtestProcessOutput() ) );
		delete TestPppdProcess;
		testPppdMppeRequired=false;




		if (pppdcap.pppdHasRequireMppeSupport || pppdcap.pppdHasMppeRequiredSupport)
		{
			pppdcap.pppdHasMppeSupport = true;
			if ( config->KvpncDebugLevel > 0 )
				config->appendLogEntry ( i18n ( " %1 has MPPE support." ) .arg ( config->pathToPppd ), config->debug );
		}
		else
		{
			if ( config->KvpncDebugLevel > 0 )
				config->appendLogEntry ( i18n ( " %1 has no MPPE support." ) .arg ( config->pathToPppd ), config->debug );

		}

		
		/* defaultroute test */
		//unrecognized option 'replacedefaultroute'
		// test defaultroute support of pppd
		testPppdReplacedefaultroute = false;
		TestPppdProcess = new TQProcess ( this );
		TestPppdProcess->addArgument ( config->pathToPppd );
		TestPppdProcess->addArgument ( "replacedefaultroute" );
		TestPppdProcess->setCommunication ( TQProcess::Stdin | TQProcess::Stdout | TQProcess::Stderr | TQProcess::DupStderr );
		TestPppdProcess->closeStdin ();

		connect ( TestPppdProcess, TQT_SIGNAL ( readyReadStdout() ), this, TQT_SLOT ( readPppdtestProcessOutput() ) );
 		connect ( TestPppdProcess, TQT_SIGNAL ( readyReadStderr() ), this, TQT_SLOT ( readPppdtestProcessOutput() ) );


		if ( !TestPppdProcess->start ( env ) )
		{
			config->appendLogEntry ( i18n ( "unable to start proc (%1)!" ).arg ( i18n ( "Test support of replacedefaultroute pppd" ) ) , config->error );
			pppdcap.pppdOk=false;
		}
		else
		{
			while ( TestPppdProcess->isRunning() )
		{
				config->appPointer->processEvents();
			sleep ( 1 );
		}


			if ( pppdcap.pppdHasReplacedefaultrouteSupport )
			{
				if ( config->KvpncDebugLevel > 4 )
					config->appendLogEntry ( i18n ( "Test support of replacedefaultroute pppd: %1" ).arg ( i18n ( "succeded" ) ) , config->debug );
			}
			else
			{
				if ( config->KvpncDebugLevel > 4 )
					config->appendLogEntry ( i18n ( "Test support of replacedefaultroute pppd: %1" ).arg ( i18n ( "failed" ) ) , config->debug );
			}
		}
		disconnect ( TestPppdProcess, TQT_SIGNAL ( readyReadStdout() ), this, TQT_SLOT ( readPppdtestProcessOutput() ) );
 		disconnect ( TestPppdProcess, TQT_SIGNAL ( readyReadStderr() ), this, TQT_SLOT ( readPppdtestProcessOutput() ) );
		delete TestPppdProcess;
		TestPppdProcess=0L;

	return pppdcap;
}

TQStringList Utils::getOpenvpnDigests()
{
	OpenvpnDigests.clear();
	retrieveOpenvpnDigests = false;
	OpenvpnDigestCount=0;
	OpenvpnDigestString="";

	ToolInfo *OpenvpnInfo = getToolInfo ( "openvpn" );
	TQString pathToOpenvpn = OpenvpnInfo->PathToExec;

	if ( pathToOpenvpn.isEmpty() )
		return OpenvpnDigests;

	OpenvpnDigestProcess = new TQProcess( this );
	OpenvpnDigestProcess->addArgument( pathToOpenvpn );
	OpenvpnDigestProcess->addArgument( "--show-digests" );

	connect( OpenvpnDigestProcess, TQT_SIGNAL( readyReadStdout() ), this, TQT_SLOT( readStdOutRetriveOpenvpnDigests() ) );
	connect( OpenvpnDigestProcess, TQT_SIGNAL( readyReadStderr() ), this, TQT_SLOT( readStdErrRetriveOpenvpnDigests() ) );

	if ( !OpenvpnDigestProcess->start( env ) ) {
		disconnect( OpenvpnDigestProcess, TQT_SIGNAL( readyReadStdout() ), this, TQT_SLOT( readStdOutRetriveOpenvpnDigests() ) );
		disconnect( OpenvpnDigestProcess, TQT_SIGNAL( readyReadStderr() ), this, TQT_SLOT( readStdErrRetriveOpenvpnDigests() ) );
		delete OpenvpnDigestProcess;
		OpenvpnDigestProcess=0L;
		kdError() << "Unable to fetch openvpn digests!" << endl;
		return 0;
	}
	else
	{
		while ( OpenvpnDigestProcess->isRunning() )
		{
			config->appPointer->processEvents();
			sleep ( 1 );
		}


		OpenvpnDigests = TQStringList().split("#",OpenvpnDigestString);

		for ( TQStringList::Iterator it = OpenvpnDigests.begin(); it != OpenvpnDigests.end(); ++it )
			*it = TQString(*it).section(' ',0,0);

	}
	disconnect( OpenvpnDigestProcess, TQT_SIGNAL( readyReadStdout() ), this, TQT_SLOT( readStdOutRetriveOpenvpnDigests() ) );
	disconnect( OpenvpnDigestProcess, TQT_SIGNAL( readyReadStderr() ), this, TQT_SLOT( readStdErrRetriveOpenvpnDigests() ) );
	delete OpenvpnDigestProcess;
	OpenvpnDigestProcess=0L;
	return OpenvpnDigests;
}

Utils::IpsecAlgos Utils::getKernelCrypto()
{
	IpsecAlgos salgos;
	salgos.IpsecIkeEncryptionAlgorithms.clear();
	salgos.IpsecIkeHashAlgorithms.clear();
	salgos.IpsecIkeDhGroups.clear();
	salgos.IpsecEspEncryptionAlgorithms.clear();
	salgos.IpsecEspAuthenticationAlgorithms.clear();
	salgos.IpsecCompressionAlgorithms.clear();
	TQString IpsecAlgoNameCurrent="";
	TQString IpsecAlgoTypeCurrent="";
	TQFile cryptoprocfile( "/proc/crypto" );

	if ( cryptoprocfile.open( IO_ReadOnly ) )
	{
		TQTextStream stream( &cryptoprocfile );
		TQString line;
		if (config->KvpncDebugLevel > 4)
			std::cout << "Kernel crypto list: " << std::endl;
		while ( !stream.atEnd() )
		{
			line = stream.readLine();
			if (line.find("name") > -1 )
			{
				IpsecAlgoNameCurrent = line.section(':',1,1).stripWhiteSpace();
// 				std::cout << "crypto name: " << IpsecAlgoNameCurrent.ascii() << std::endl;
			}
			if (line.find("type") >-1)
			{
				IpsecAlgoTypeCurrent=line.section(':',1,1).stripWhiteSpace();
// 				std::cout << "crypto type: " << IpsecAlgoTypeCurrent.ascii() << std::endl;

				if (IpsecAlgoTypeCurrent != "blkcipher" && IpsecAlgoTypeCurrent == "cipher")
				{
// 					std::cout << "adding cipher algo " << IpsecAlgoNameCurrent << std::endl;
					salgos.IpsecEspEncryptionAlgorithms.append(IpsecAlgoNameCurrent);
				}
				if (IpsecAlgoTypeCurrent == "digest")
				{
// 					std::cout  << "adding digest algo " << IpsecAlgoNameCurrent << std::endl;
					salgos.IpsecEspAuthenticationAlgorithms.append(IpsecAlgoNameCurrent);
				}
				if (IpsecAlgoTypeCurrent == "hash")
				{
// 					std::cout  << "adding hash algo " << IpsecAlgoNameCurrent << std::endl;
					salgos.IpsecIkeHashAlgorithms.append(IpsecAlgoNameCurrent);
				}
				if (IpsecAlgoTypeCurrent == "compression")
				{
// 					std::cout  << "adding compression algo " << IpsecAlgoNameCurrent << std::endl;
					salgos.IpsecCompressionAlgorithms.append(IpsecAlgoNameCurrent);
				}

			}
		}
		cryptoprocfile.close();
		salgos.IpsecIkeEncryptionAlgorithms.sort();
		salgos.IpsecIkeHashAlgorithms.sort();
		salgos.IpsecIkeDhGroups.sort();
		salgos.IpsecEspEncryptionAlgorithms.sort();
		salgos.IpsecEspAuthenticationAlgorithms.sort();
		salgos.IpsecCompressionAlgorithms.sort();
	}
	else
	{
		config->appendLogEntry(i18n("%1 cant be opened!").arg("/proc/crypto"),config->error);
	}
	return salgos;
}

TQString Utils::getNameAndPidOfProgramListen( int port )
{
	if ( port == 0 )
		return "";

	ListenPort = port;
	retrieveNameAndPidOfProgramListen = false;

	NameAndPidOfProgramListenProcess = new TQProcess( this );
	NameAndPidOfProgramListenProcess->addArgument( config->pathToNetstat );
	NameAndPidOfProgramListenProcess->addArgument( "-ntupl" );

	connect( NameAndPidOfProgramListenProcess, TQT_SIGNAL( readyReadStdout() ), this, TQT_SLOT( readStdOutGetNameAndPidOfProgramListen() ) );
	connect( NameAndPidOfProgramListenProcess, TQT_SIGNAL( readyReadStderr() ), this, TQT_SLOT( readStdErrGetNameAndPidOfProgramListen() ) );

	if ( !NameAndPidOfProgramListenProcess->start( env ) ) {
		disconnect( NameAndPidOfProgramListenProcess, TQT_SIGNAL( readyReadStdout() ), this, TQT_SLOT( readStdOutGetNameAndPidOfProgramListen() ) );
		disconnect( NameAndPidOfProgramListenProcess, TQT_SIGNAL( readyReadStderr() ), this, TQT_SLOT( readStdErrGetNameAndPidOfProgramListen() ) );
		delete NameAndPidOfProgramListenProcess;
		NameAndPidOfProgramListenProcess=0L;
		kdError() << "netstat fails!" << endl;
		return 0;
	}
	else
	{
		while ( NameAndPidOfProgramListenProcess->isRunning() )
		{
			config->appPointer->processEvents();
			sleep ( 1 );
		}


		disconnect( NameAndPidOfProgramListenProcess, TQT_SIGNAL( readyReadStdout() ), this, TQT_SLOT( readStdOutGetNameAndPidOfProgramListen() ) );
		disconnect( NameAndPidOfProgramListenProcess, TQT_SIGNAL( readyReadStderr() ), this, TQT_SLOT( readStdErrGetNameAndPidOfProgramListen() ) );
		delete NameAndPidOfProgramListenProcess;
		NameAndPidOfProgramListenProcess=0L;
	}
	return NameAndPidOfProgramListen;
}

TQString Utils::getEmailAddressOfCert(TQString cert)
{
	if (cert.isEmpty())
		return "";

	GetEmailAddressOfCertProcess = new TQProcess ( this );
	GetEmailAddressOfCertProcess->setCommunication( TQProcess::Stdin | TQProcess::Stdout | TQProcess::Stderr | TQProcess::DupStderr );
	GetEmailAddressOfCertProcess->addArgument( config->pathToOpenssl );
	GetEmailAddressOfCertProcess->addArgument( "x509");
	GetEmailAddressOfCertProcess->addArgument( "-noout");
	GetEmailAddressOfCertProcess->addArgument( "-in");
	GetEmailAddressOfCertProcess->addArgument( cert );
	GetEmailAddressOfCertProcess->addArgument( "-subject");

	connect( GetEmailAddressOfCertProcess, TQT_SIGNAL( readyReadStdout() ), this, TQT_SLOT( readOutGetEmailAddressOfCert() ) );

	if ( !GetEmailAddressOfCertProcess->start( env ) ) {
		disconnect( GetEmailAddressOfCertProcess, TQT_SIGNAL( readyReadStdout() ), this, TQT_SLOT( readOutGetEmailAddressOfCert() ) );
		delete GetEmailAddressOfCertProcess;
		GetEmailAddressOfCertProcess=0L;
		kdError() << "GetEmailAddressOfCertProcess" << endl;
		return 0;
	}
	else
	{
		while ( GetEmailAddressOfCertProcess->isRunning() )
		{
			config->appPointer->processEvents();
			sleep ( 1 );
		}
		disconnect( GetEmailAddressOfCertProcess, TQT_SIGNAL( readyReadStdout() ), this, TQT_SLOT( readOutGetEmailAddressOfCert() ) );
		delete GetEmailAddressOfCertProcess;
		GetEmailAddressOfCertProcess=0L;
	}

	return EmailAddressOfCert;
}

TQStringList Utils::getSmartcardSlots(TQString ProviderLib)
{
	SmartcardSlots.clear();

	ToolInfo *Pkcs11ToolInfo = getToolInfo ( "pkcs11-tool" );
	Pkcs11ToolInfo->collectToolInfo();
// 	if (Pkcs11ToolInfo == 0)
// 		return SmartcardSlots;
	TQString pathToPkcs11Tool;
	pathToPkcs11Tool = Pkcs11ToolInfo->PathToExec;

	if ( pathToPkcs11Tool.isEmpty() )
		return SmartcardSlots;

	GetSmartcardSlotsProcess = new TDEProcess;
	
	*GetSmartcardSlotsProcess << pathToPkcs11Tool;
	if (!ProviderLib.isEmpty())
	{
		*GetSmartcardSlotsProcess <<  "--module";
		*GetSmartcardSlotsProcess << ProviderLib ;
	}
	*GetSmartcardSlotsProcess <<  "-L" ;

	connect( GetSmartcardSlotsProcess, TQT_SIGNAL( receivedStdout   (  TDEProcess *, char *, int)), this, TQT_SLOT(readOutGetSmartcardSlots()));
	
	if ( !GetSmartcardSlotsProcess->start ( TDEProcess::NotifyOnExit, TDEProcess::All ) )
	{
		disconnect( GetSmartcardSlotsProcess, TQT_SIGNAL( receivedStdout   (  TDEProcess *, char *, int)), this, TQT_SLOT(readOutGetSmartcardSlots()));
		delete GetSmartcardSlotsProcess;
		GetSmartcardCertsFromSlotProcess=0L;
		config->appendLogEntry(i18n("Unable to fetch smartcard slots via pkcs11-tool!"), config->error);
		return 0;
	}
	else
	{
		 if (config->KvpncDebugLevel > 5)
			config->appendLogEntry ( i18n("Fetch smartcard slots via pkcs11-tool started.") ,config->debug );

		while ( GetSmartcardSlotsProcess->isRunning() )
		{
			usleep ( 500 );
			config->appPointer->processEvents();
		}
		disconnect( GetSmartcardSlotsProcess, TQT_SIGNAL( receivedStdout   (  TDEProcess *, char *, int)), this, TQT_SLOT(readOutGetSmartcardSlots()));
		delete GetSmartcardSlotsProcess;
		GetSmartcardCertsFromSlotProcess=0L;
		 if (config->KvpncDebugLevel > 5)
			config->appendLogEntry ( i18n("Fetch smartcard slots via pkcs11-tool finished.") ,config->debug );
	}
	return SmartcardSlots;
}

TQStringList Utils::getSmartcardCertsFromSlot(TQString slot,TQString IdType,TQString ProviderLib)
{
	Pkcs11CertFound=false;
	SmartcardCertsFromSlot.clear();

	if (!IdType.isEmpty())
		this->IdType= IdType;
	else
		this->IdType = "id";

	ToolInfo *Pkcs11ToolInfo = getToolInfo ( "pkcs11-tool" );
	Pkcs11ToolInfo->collectToolInfo();
// 	if (Pkcs11ToolInfo == 0)
// 		return SmartcardSlots;
	TQString pathToPkcs11Tool;
	pathToPkcs11Tool = Pkcs11ToolInfo->PathToExec;

	if ( pathToPkcs11Tool.isEmpty() )
		return SmartcardSlots;

	GetSmartcardCertsFromSlotProcess = new TQProcess( this );
	GetSmartcardCertsFromSlotProcess->setCommunication( TQProcess::Stdin | TQProcess::Stdout | TQProcess::Stderr | TQProcess::DupStderr );
	GetSmartcardCertsFromSlotProcess->addArgument( pathToPkcs11Tool);	
	
	if (!ProviderLib.isEmpty())
	{
		GetSmartcardCertsFromSlotProcess->addArgument( "--module");
		GetSmartcardCertsFromSlotProcess->addArgument( ProviderLib );
	}

	GetSmartcardCertsFromSlotProcess->addArgument( "-O" );

	GetSmartcardCertsFromSlotProcess->addArgument( "--slot" );
	if (!slot.isEmpty())
		GetSmartcardCertsFromSlotProcess->addArgument( slot );
	else
		GetSmartcardCertsFromSlotProcess->addArgument("0");

	connect( GetSmartcardCertsFromSlotProcess, TQT_SIGNAL( readyReadStdout() ), this, TQT_SLOT( readOutGetSmartcardCertsFromSlot() ) );
	
	if ( !GetSmartcardCertsFromSlotProcess->start( env ) ) {
		disconnect( GetSmartcardCertsFromSlotProcess, TQT_SIGNAL( readyReadStdout() ), this, TQT_SLOT( readOutGetSmartcardCertsFromSlot() ) );
		delete GetSmartcardCertsFromSlotProcess;
		GetSmartcardCertsFromSlotProcess=0L;
		kdError() << "Unable to fetch smartcard slots via pkcs11-tool!" << endl;
		return 0;
	}
	else
	{

		while ( GetSmartcardCertsFromSlotProcess->isRunning() )
		{
			usleep ( 500 );
			config->appPointer->processEvents();
		}
		disconnect( GetSmartcardCertsFromSlotProcess, TQT_SIGNAL( readyReadStdout() ), this, TQT_SLOT( readOutGetSmartcardCertsFromSlot() ) );
		delete GetSmartcardCertsFromSlotProcess;
		GetSmartcardCertsFromSlotProcess=0L;
	}

	return SmartcardCertsFromSlot;
}

TQStringList Utils::getCertsFromCiscoCertStore(TQString type)
{

	if (type != "user" && type != "ca" && type != "enrollment")
		type="user";

	if (config->KvpncDebugLevel > 2)
		config->appendLogEntry("getCertsFromCiscoCertStore: "+i18n("type: %1").arg(type),config->debug );

	CertsFromCiscoCertStore.clear();
	CertsFromCiscoCertPos=0;
	
	if ( config->pathToCiscoCertMgr.isEmpty() )
		return CertsFromCiscoCertStore;

	GetCertsFromCiscoCertStoreProcess = new TQProcess( this );
	GetCertsFromCiscoCertStoreProcess->setCommunication( TQProcess::Stdin | TQProcess::Stdout | TQProcess::Stderr | TQProcess::DupStderr );
	GetCertsFromCiscoCertStoreProcess->addArgument( config->pathToCiscoCertMgr );

	if (type == "user")
		GetCertsFromCiscoCertStoreProcess->addArgument( "-U");
	if (type == "ca")
		GetCertsFromCiscoCertStoreProcess->addArgument( "-R");
	GetCertsFromCiscoCertStoreProcess->addArgument( "-op");
	if (type == "enrollent")
		GetCertsFromCiscoCertStoreProcess->addArgument( "-E");
	GetCertsFromCiscoCertStoreProcess->addArgument( "-op");


	GetCertsFromCiscoCertStoreProcess->addArgument( "list");
	
	connect( GetCertsFromCiscoCertStoreProcess, TQT_SIGNAL( readyReadStdout() ), this, TQT_SLOT( readOutGetCertsFromCiscoCertStoreSlot() ) );
	
	if ( !GetCertsFromCiscoCertStoreProcess->start( env ) )
	{
		disconnect( GetCertsFromCiscoCertStoreProcess, TQT_SIGNAL( readyReadStdout() ), this, TQT_SLOT( readOutGetCertsFromCiscoCertStoreSlot() ) );
		delete GetCertsFromCiscoCertStoreProcess;
		GetCertsFromCiscoCertStoreProcess=0L;
		kdError() << "Unable to fetch certificates via cisco_cert_mgr!" << endl;
		return 0;
	}
	else
	{

		while ( GetCertsFromCiscoCertStoreProcess->isRunning() )
		{
			usleep ( 500 );
			if ( config->appPointer->hasPendingEvents () )
				config->appPointer->processEvents();
		}
		disconnect( GetCertsFromCiscoCertStoreProcess, TQT_SIGNAL( readyReadStdout() ), this, TQT_SLOT( readOutGetCertsFromCiscoCertStoreSlot() ) );
		delete GetCertsFromCiscoCertStoreProcess;
		GetCertsFromCiscoCertStoreProcess=0L;
	}

	return CertsFromCiscoCertStore;
}

TQStringList Utils::getOpenvpnPkcs11Ids(TQString ProviderLib)
{
	Pkcs11CertFound=false;
	OpenvpnPkcs11Ids.clear();
	OpenvpnPkcs11IdsProcess = new TQProcess( this );
	OpenvpnPkcs11IdsProcess->setCommunication( TQProcess::Stdin | TQProcess::Stdout | TQProcess::Stderr | TQProcess::DupStderr );
	//openvpn --show-pkcs11-ids /usr/lib/opensc-pkcs11.so
	OpenvpnPkcs11IdsProcess->addArgument(config->pathToOpenvpn);
	OpenvpnPkcs11IdsProcess->addArgument("--show-pkcs11-ids");
	if (!ProviderLib.isEmpty())
		OpenvpnPkcs11IdsProcess->addArgument( ProviderLib );


	connect( OpenvpnPkcs11IdsProcess, TQT_SIGNAL( readyReadStdout() ), this, TQT_SLOT( readOutGetOpenvpnPkcs11Ids() ) );
	
	if ( !OpenvpnPkcs11IdsProcess->start( env ) ) {
		disconnect( OpenvpnPkcs11IdsProcess, TQT_SIGNAL( readyReadStdout() ), this, TQT_SLOT( readOutGetOpenvpnPkcs11Ids() ) );
		delete OpenvpnPkcs11IdsProcess;
		OpenvpnPkcs11IdsProcess=0L;
		kdError() << "Unable to fetch pkcs11 ids via openvpn!" << endl;
		return 0;
	}
	else
	{

		while ( OpenvpnPkcs11IdsProcess->isRunning() )
		{
			usleep ( 500 );
			config->appPointer->processEvents();
		}
		disconnect( OpenvpnPkcs11IdsProcess, TQT_SIGNAL( readyReadStdout() ), this, TQT_SLOT( readOutGetOpenvpnPkcs11Ids() ) );
		delete OpenvpnPkcs11IdsProcess;
		OpenvpnPkcs11IdsProcess=0L;
	}

	return OpenvpnPkcs11Ids;
}

bool Utils::getNeedsPassphrase(TQString key)
{
	
	if (key.isEmpty() || !TQFile(key).exists())
		return false;

	needsPassphrase=false;

	//openssl rsa -noout -in client.key -passin pass:aaa
	
	ToolInfo *OpensslToolInfo = getToolInfo ( "openssl" );
	OpensslToolInfo->collectToolInfo();

	TQString pathToOpenssl = OpensslToolInfo->PathToExec;

	if ( pathToOpenssl.isEmpty() )
		return needsPassphrase;

	NeedsPassphraseProcess = new TQProcess( this );
	NeedsPassphraseProcess->setCommunication( TQProcess::Stdin | TQProcess::Stdout | TQProcess::Stderr | TQProcess::DupStderr );
	NeedsPassphraseProcess->addArgument( pathToOpenssl);
	NeedsPassphraseProcess->addArgument("rsa");
	NeedsPassphraseProcess->addArgument("-noout");
	NeedsPassphraseProcess->addArgument("-in");
	NeedsPassphraseProcess->addArgument(key);
	NeedsPassphraseProcess->addArgument("-passin");
	NeedsPassphraseProcess->addArgument("pass:aaa");
	

	connect( NeedsPassphraseProcess, TQT_SIGNAL( readyReadStdout() ), this, TQT_SLOT( readOutNeedsPassphrase() ) );
	
	if ( !NeedsPassphraseProcess->start( env ) ) {
		disconnect( NeedsPassphraseProcess, TQT_SIGNAL( readyReadStdout() ), this, TQT_SLOT( readOutNeedsPassphrase() ) );
		delete NetworkDeviceTestProcess;
		NeedsPassphraseProcess=0L;
		kdError() << "Unable to start openssl!" << endl;
		return false;
	}
	else
	{
		while ( NeedsPassphraseProcess->isRunning() )
		{
			usleep ( 500 );
			config->appPointer->processEvents();
		}
		disconnect( NeedsPassphraseProcess, TQT_SIGNAL( readyReadStdout() ), this, TQT_SLOT( readOutNeedsPassphrase() ) );
		delete NetworkDeviceTestProcess;
		NeedsPassphraseProcess=0L;
	}

	return needsPassphrase;
}

TQString Utils::getHostname()
{
	Hostname="linux.local";

	GetHostnameProcess = new TQProcess( this );
	GetHostnameProcess->addArgument( "hostname" );

	connect( GetHostnameProcess, TQT_SIGNAL( readyReadStdout() ), this, TQT_SLOT( readStdOutGetHostname() ) );
	connect( GetHostnameProcess, TQT_SIGNAL( readyReadStderr() ), this, TQT_SLOT( readStdErrGetHostname() ) );
	if ( !GetHostnameProcess->start( env ) ) {
		disconnect( GetHostnameProcess, TQT_SIGNAL( readyReadStdout() ), this, TQT_SLOT( readStdOutGetHostname() ) );
		disconnect( GetHostnameProcess, TQT_SIGNAL( readyReadStderr() ), this, TQT_SLOT( readStdErrGetHostname() ) );
		delete GetHostnameProcess;
		GetHostnameProcess=0L;
		kdError() << "Unable to start getHostname process!" << endl;
		return Hostname;
	}
	else
	{
		while ( GetHostnameProcess->isRunning() )
		{
			usleep(200);
		}
		disconnect( GetHostnameProcess, TQT_SIGNAL( readyReadStdout() ), this, TQT_SLOT( readStdOutGetHostname() ) );
		disconnect( GetHostnameProcess, TQT_SIGNAL( readyReadStderr() ), this, TQT_SLOT( readStdErrGetHostname() ) );
		delete GetHostnameProcess;
		GetHostnameProcess=0L;
		return Hostname;
	}
	
	
}

/* === Slots === */
void Utils::readStdOutCreateTunDev() {
	TQString msg = TQString( createProcess->readStderr() );
	kdDebug() << "readStdOutCreateTunDev(): " << msg << endl;
}

void Utils::readStdErrCreateTunDev()
{
	TQString msg = TQString( createProcess->readStderr() );
	kdError() << "readStdErrCreateTunDev" << msg << endl;

}

void Utils::readStdOutLoadKernelModule()
{
	TQString msg = TQString( ModprobeProcess->readStdout() );
	kdDebug() << "readStdErrreadStdOutLoadKernelModule" << msg << endl;
}

void Utils::readStdErrLoadKernelModule()
{
	TQString msg = TQString( ModprobeProcess->readStderr() );
	// 	kdDebug() << "readStdErrreadStderrLoadKernelModule" << msg << endl;

	/* FATAL: Module <Name> not found. */
	if ( msg.find( "not found", 0, FALSE ) > -1 ) {
		modprobeSuccess = false;
	}

	if ( msg.find( "could not find module", 0 , FALSE ) > -1 ) {
		modprobeSuccess = false;
	}

	if ( msg.find( "not permitted", 0 , FALSE ) > -1 ) {
		modprobeSuccess = false;
	}
}

void Utils::readStdOutToolsTest()
{
}

void Utils::readStdErrToolsTest()
{
}

void Utils::readStdOutRetriveOpenvpnCiphers()
{
	while ( OpenvpnCiphersProcess->canReadLineStdout() ) {
		TQString msg = TQString( OpenvpnCiphersProcess->readLineStdout() );
		if ( msg.contains( "default key" ) ) {
			//std::cout << msg.ascii() << std::endl;
			OpenvpnCiphers.append( msg.section( ' ', 0, 0 ) );
		}
	}
}

void Utils::readStdErrRetriveOpenvpnCiphers()
{
	while ( OpenvpnCiphersProcess->canReadLineStderr() ) {
		TQString msg = TQString( OpenvpnCiphersProcess->readLineStderr() );

	}
}

void Utils::readStdOutRetriveIpsecAlgos()
{
	while ( IpsecAlgosProcess->canReadLineStdout() ) {
		TQString msg = TQString( IpsecAlgosProcess->readLineStdout() );
		bool newIpsecAlgoFound=false;
// 		std::cout << "[ipsec algos raw] "<< msg.ascii() << std::endl;
		if (msg.find ( "000 algorithm", 0, -1 ) > -1)
		{
			std::cout << "[ipsec algos line] "<< msg.ascii() << std::endl;
			if (msg.find ( "000 algorithm ESP", 0, -1 ) > -1)
			{

					TQString Algo = msg.stripWhiteSpace().section(":",1,1).section(",",1,1).section("=",1,1);
					TQString MinKeySize = msg.stripWhiteSpace().section(":",1,1).section(",",3,3).section("=",1,1);
					TQString MaxKeySize = msg.stripWhiteSpace().section(":",1,1).section(",",4,4).section("=",1,1);
					std::cout << "IKE encryption algo found: \"" << Algo.local8Bit() << "\", Min: " << MinKeySize.local8Bit() << ", Max: " << MaxKeySize.local8Bit() << std::endl;
// 					TQStringList AlgoOptList = TQStringList::split("-",AlgoOpt);
// 					for (TQStringList::Iterator it = AlgoOptList.begin(); it != AlgoOptList.end(); ++it)
// 					{
// 						std::cout << "IKE encryption algo subtypes found: \"" << Algo << "-" << *it << "\"" << std::endl;
// 					}
				}

		}
	}
}

void Utils::readStdErrRetriveIpsecAlgos()
{
	while ( IpsecAlgosProcess->canReadLineStderr() ) {
		TQString msg = TQString( IpsecAlgosProcess->readLineStderr() );
		std::cout << "[ipsec algos raw err] "<< msg.ascii() << std::endl;
	}
}

void Utils::readPppdtestProcessOutput()
{
	TQString msg = "";
	msg += TQString ( TestPppdProcess->readStdout() );
// 	msg += TQString ( TestPppdProcess->readStderr() );

// 	if ( msg == "" )
// 		return ;



	/* mppe test */
	if (testPppdRequireMppe)
	{
		if (config->KvpncDebugLevel > 2)
			config->appendLogEntry("Testing require-mppe",config->debug);

		if (config->KvpncDebugLevel > 4)
			config->appendLogEntry("[test pppd raw]: "+msg,config->debug);

		if ( msg.contains ( "unrecognized option 'require-mppe'" ) )
		{
			pppdcap.oldPppdStyle = true;
			pppdcap.pppdHasMppeSupport = false;
			pppdcap.pppdHasRequireMppeSupport=false;

			if ( config->KvpncDebugLevel > 4 )
				config->appendLogEntry ( i18n ( "%1 has  no MPPE support using \"require mppe\"." ) .arg ( config->pathToPppd ), config->debug );
		}
		else
		{
			if ( msg.contains ( "The remote system is required to authenticate itself" ) )
			{
				// old style found
				pppdcap.oldPppdStyle = false;
				pppdcap.pppdHasMppeSupport = true;
				pppdcap.pppdHasRequireMppeSupport=true;

				if ( config->KvpncDebugLevel > 0 )
					config->appendLogEntry ( i18n ( "%1 has MPPE support and uses require mppe." ) .arg ( config->pathToPppd ), config->debug );
			}
		}
	}

	if ( testPppdMppeRequired)
	{
		if (config->KvpncDebugLevel > 2)
			config->appendLogEntry("Testing mppe-required",config->debug);

		if (config->KvpncDebugLevel > 4)
			config->appendLogEntry("[test pppd raw]: "+msg,config->debug);

		// try old style
		if ( msg.contains ( "unrecognized option 'mppe'" ) )
		{
			// no mppe support :(
			pppdcap.oldPppdStyle = false;
			pppdcap.pppdHasMppeSupport = false;
			pppdcap.pppdHasMppeRequiredSupport=false;
			if ( config->KvpncDebugLevel > 4 )
				config->appendLogEntry ( i18n ( "%1 has  no MPPE support using \"mppe-required\"." ) .arg ( config->pathToPppd ), config->debug );
		}
		else
		{
			if ( msg.contains ( "The remote system is required to authenticate itself" ) )
			{
				// old style found
				pppdcap.oldPppdStyle = true;
				pppdcap.pppdHasMppeSupport = true;
				pppdcap.pppdHasMppeRequiredSupport=true;

				if ( config->KvpncDebugLevel > 0 )
					config->appendLogEntry ( i18n ( "%1 has MPPE support and uses mppe-required." ) .arg ( config->pathToPppd ), config->debug );
			}
		}
	}


	/* default route test */
	if ( testPppdReplacedefaultroute )
	{

		if (config->KvpncDebugLevel > 1)
			config->appendLogEntry("[test pppd raw]: "+msg,config->debug);

		if ( msg.contains ( "unrecognized option 'replacedefaultroute'" )   )
		{
			pppdcap.pppdHasReplacedefaultrouteSupport = false;

		if (config->KvpncDebugLevel > 1)
			config->appendLogEntry(i18n("Testing %1: %2").arg("replacedefaultroute").arg(i18n("failed")),config->debug);
		}
		else
		{
			pppdcap.pppdHasReplacedefaultrouteSupport = true;
		if (config->KvpncDebugLevel > 1)
			config->appendLogEntry(i18n("Testing %1: %2").arg("replacedefaultroute").arg(i18n("succeded")),config->debug);
		}
	}


}

void Utils::readStdOutRetriveOpenvpnDigests()
{
	while ( OpenvpnDigestProcess->canReadLineStdout() ) {
		TQString msg = TQString( OpenvpnDigestProcess->readLineStdout() );
		OpenvpnDigestCount+=1;
		if ( OpenvpnDigestCount > 5 )
		{
// 			std::cout << msg.simplifyWhiteSpace().ascii() << std::endl;
			OpenvpnDigestString += msg+"#";
		}
	}
}

void Utils::readStdErrRetriveOpenvpnDigests()
{
	while ( OpenvpnDigestProcess->canReadLineStderr() ) {
		TQString msg = TQString( OpenvpnDigestProcess->readLineStderr() );

	}
}

void Utils::readStdOutGetNameAndPidOfProgramListen()
{
	while ( NameAndPidOfProgramListenProcess->canReadLineStdout() ) {
		TQString msg = TQString( NameAndPidOfProgramListenProcess->readLineStdout() );
		if ( msg.contains( "/" ) && msg.contains( TQString().setNum( ListenPort ) ) && msg.simplifyWhiteSpace().section( ' ', 3, 3 ).section(':',1,1) == TQString().setNum( ListenPort )  ) {
			std::cout << msg.ascii() << std::endl;
			NameAndPidOfProgramListen = ( msg.simplifyWhiteSpace().section( ' ', 5, 5 ) );
			if (NameAndPidOfProgramListen.contains( "LISTEN"))
				NameAndPidOfProgramListen = ( msg.simplifyWhiteSpace().section( ' ', 6, 6 ) );
			break;
		}
	}
}

void Utils::readStdErrGetNameAndPidOfProgramListen()
{
	while ( NameAndPidOfProgramListenProcess->canReadLineStderr() ) {
		TQString msg = TQString( NameAndPidOfProgramListenProcess->readLineStderr() );

	}
}

void Utils::readOutGetEmailAddressOfCert()
{
	while ( GetEmailAddressOfCertProcess->canReadLineStdout() ) {
		TQString msg = TQString( GetEmailAddressOfCertProcess->readLineStdout() );
		if ( msg.contains( "emailAddress" ) ) {
			std::cout << "msg: " << msg.ascii() << std::endl;
			TQStringList fields = TQStringList::split( '/', msg);
			for ( TQStringList::iterator field = fields.begin();  field != fields.end();++field )
			{
				if (TQString (*field).contains("emailAddress"))
				{
					if (config->KvpncDebugLevel > 2)
						std::cout << "field: " << TQString(*field).ascii() << std::endl;
					// subject= /C=de/L=WR/O=crissi/CN=Christoph Thielecke/emailAddress=crissi99@gxm.de
					// crissi99@gxm.de
					EmailAddressOfCert = TQString(*field).section('=',1,1);
					break;
				}
			}
			break;
		}
	}
}

void Utils::readOutGetSmartcardSlots(TDEProcess *   proc, char *   buffer, int   buflen)
{
	TQString msg_raw = TQString::fromLatin1(buffer, buflen);
		 if (config->KvpncDebugLevel > 5)
			config->appendLogEntry ( TQString("[readOutGetSmartcardSlots raw] "+TQString(msg_raw)) ,config->debug );


	TQStringList msg_raw_list = TQStringList::split ( "\n",msg_raw );
	
	for ( TQStringList::Iterator it = msg_raw_list.begin(); it != msg_raw_list.end(); ++it )
	{
		TQString msg = *it;
		 if (config->KvpncDebugLevel > 5)
			config->appendLogEntry ( TQString("[readOutGetSmartcardSlots] "+TQString(msg)) ,config->debug );


		if ( msg.contains( "Slot" ) && !msg.contains("empty") )
		{
			//std::cout << msg.ascii() << std::endl;
// 			KMessageBox::information( 0, i18n( "msg: %1" ).arg( msg.stripWhiteSpace() ), TQString("foo") );
			// we put in this format: <id>:<name>
			TQString id = msg.stripWhiteSpace().section( ' ', 1, 1 );
			TQString name = msg.stripWhiteSpace().remove(TQString("Slot "+id)).stripWhiteSpace();
			TQString slot = id+" : "+name;
			SmartcardSlots.append( slot );
		}
	}
}

void Utils::readOutGetSmartcardCertsFromSlot()
{
	while ( GetSmartcardCertsFromSlotProcess->canReadLineStdout() ) {
		TQString msg = TQString( GetSmartcardCertsFromSlotProcess->readLineStdout() );

		if (config->KvpncDebugLevel > 5)
			config->appendLogEntry ( TQString("[readOutGetSmartcardCertsFromSlot] "+TQString(msg)) ,config->debug );

		if ( msg.contains( "Certificate Object" ) ) {
// 			KMessageBox::sorry( 0, TQString("msg: "+msg), TQString("foo1"),0 );
			Pkcs11CertFound=true;
		}
// 		KMessageBox::information( 0, i18n( "msg: %1" ).arg( msg ), TQString("foo") );
		if (IdType == "id")
		{
			if ( msg.contains( "ID:" ) && Pkcs11CertFound==true ) {
				//std::cout << msg.ascii() << std::endl;
				TQString msg2 = msg.section( ':', 1, 1 );
				msg2 = msg2.stripWhiteSpace();
// 				KMessageBox::sorry( 0, TQString("id: "+msg), TQString("foo"),0 );
				SmartcardCertsFromSlot.append( msg2 );
				Pkcs11CertFound=false;
			}
		}
		else if (IdType == "label")
		{
			if ( msg.contains( "label:" ) && Pkcs11CertFound==true ) {
				//std::cout << msg.ascii() << std::endl;
				TQString msg2 = msg.section( ':', 1, 1 );
				msg2 = msg2.stripWhiteSpace();
// 				KMessageBox::sorry( 0, TQString("label: "+msg2), TQString("foo"),0 );
				SmartcardCertsFromSlot.append( msg2 );
				Pkcs11CertFound=false;
			}
		}
		else if (IdType == "subject")
		{
			if ( msg.contains( "Subject:" ) && Pkcs11CertFound==true ) {
				//std::cout << msg.ascii() << std::endl;
				TQString msg2 = msg.section( ':', 1, 1 );
				msg2 = msg2.stripWhiteSpace();
// 				KMessageBox::sorry( 0, TQString("subject: "+msg), TQString("foo"),0 );
				SmartcardCertsFromSlot.append( msg2 );
				Pkcs11CertFound=false;
			}
		}
	}

}

void Utils::readOutGetCertsFromCiscoCertStoreSlot()
{
	while ( GetCertsFromCiscoCertStoreProcess->canReadLineStdout() ) {
		TQString msg = TQString( GetCertsFromCiscoCertStoreProcess->readLineStdout() );

// samle output :(

// Cisco Systems VPN Client Version 4.8.00 (0490)
// Copyright (C) 1998-2005 Cisco Systems, Inc. All Rights Reserved.
// Client Type(s): Linux
// Running on: Linux 2.6.22-2-686 #1 SMP Fri Aug 31 00:24:01 UTC 2007 i686
// 
// 
//       Cert #          Common Name
//       -------         ------------
// 
//       0               crissi 

// 		if (config->KvpncDebugLevel > 2)
// 			std::cout << "readOutGetCertsFromCiscoCertStoreSlot: " << msg << std::endl;

		if (msg.find("Cert #",0,FALSE) > -1)
			CertsFromCiscoCertPos=1;
		if (CertsFromCiscoCertPos==1 || CertsFromCiscoCertPos ==2 | CertsFromCiscoCertPos ==3)
		{
			CertsFromCiscoCertPos++;
			continue;
		}
		else if (CertsFromCiscoCertPos>=4)
		{
			if (msg.length() > 2)
			{
	// 			"       0               crissi "
				int idx=0; // first non space => 0
				int idx2=0; // second nonspace => c
				for (idx=0;idx<(int)msg.length();idx++)
					if (!msg.at(idx).isSpace())
						break;

// 				if (config->KvpncDebugLevel > 2)
// 					std::cout << "readOutGetCertsFromCiscoCertStoreSlot: idx " << idx << std::endl;

				for (idx2=idx+1;idx2<(int)msg.length();idx2++)
					if (!msg.at(idx2).isSpace())
						break;
// 				if (config->KvpncDebugLevel > 2)
// 					std::cout << "readOutGetCertsFromCiscoCertStoreSlot: idx2 " << idx2 << std::endl;
				TQString common_name = msg.right(msg.length()-idx2);
				if (common_name.length() > 0)
				{
// 					if (config->KvpncDebugLevel > 2)
// 						std::cout << "readOutGetCertsFromCiscoCertStoreSlot => cert " << common_name << std::endl;
					CertsFromCiscoCertStore.append( common_name );
				}
			}
		}
	}
}

void Utils::readOutGetOpenvpnPkcs11Ids()
{
	while ( OpenvpnPkcs11IdsProcess->canReadLineStdout() )
	{
		TQString msg = TQString( OpenvpnPkcs11IdsProcess->readLineStdout() );

		/*
		sample output:
		Serial:     21
		Serialized id: 
		OpenSC\x20Project/PKCS\x20\x2315\x20SCard/2322222222222222/OpenSC\x20Card\x20\x28User1\x20Name22\x29/45
		*/
		
		if (config->KvpncDebugLevel > 5)
			config->appendLogEntry ( TQString("[readOutGetOpenvpnPkcs11Ids] "+TQString(msg)) ,config->debug );

// 	KMessageBox::information( 0, i18n( "msg: %1" ).arg( msg ), TQString("foo") );
		if ( msg.contains( "Serialized id:" ))
		{
			//std::cout << msg.ascii() << std::endl;
			TQString msg2 = msg.section( ':', 1, 1 );
			msg2 = msg2.stripWhiteSpace();
// 		KMessageBox::sorry( 0, TQString("id: "+msg), TQString("foo"),0 );
			OpenvpnPkcs11Ids.append( msg2 );
		}
	}
}

void Utils::readOutNeedsPassphrase()
{
	while ( NeedsPassphraseProcess->canReadLineStdout() ) {
		TQString msg = TQString( NeedsPassphraseProcess->readLineStdout() );
// 		KMessageBox::sorry( 0, TQString("msg: "+msg), TQString("foo1"),0 );
		if ( msg.contains( "unable to load Private Key" ) ) {
			needsPassphrase=true;
		}
	}

}

void Utils::readStdOutGetHostname()
{
	while ( GetHostnameProcess->canReadLineStdout() ) {
		TQString msg = TQString( GetHostnameProcess->readLineStdout() ).simplifyWhiteSpace().section(' ',0,0);
// 		KMessageBox::sorry( 0, TQString("msg: "+msg), TQString("foo1"),0 );
		if (!msg.isEmpty())
			Hostname=msg;
	}
}

void Utils::readStdErrGetHostname()
{
	while ( GetHostnameProcess->canReadLineStderr() ) {
		TQString msg = TQString( GetHostnameProcess->readLineStderr() );
		KMessageBox::error( 0, TQString(msg), TQString("getHostname()"),0 );
	}
}

TQString Utils::dec2bin(int n)
{
	if (0 == n)
	{
		return "0";
  	}
	else
	{
		TQString ret ="";
    		TQString ret2 = dec2bin(n/2);
		ret+= ret2;
    		if(n % 2)
			ret +="1";
		else
			ret+= "0";
		return ret;
  	}
}

int Utils::dottedIpv4Netmask2NetmaskBytes(TQString dottedIpv4Netmask)
{
	if (dottedIpv4Netmask.isEmpty() || dottedIpv4Netmask.contains( '.' ) != 3)
		return 0;
	int byteSetCount =0;
	int part0 = dottedIpv4Netmask.section( '.', 0, 0 ).toInt();
	int part1 = dottedIpv4Netmask.section( '.', 1, 1 ).toInt();
	int part2 = dottedIpv4Netmask.section( '.', 2, 2 ).toInt();
	int part3 = dottedIpv4Netmask.section( '.', 3, 3 ).toInt();
	
	std::cout << "part0: " << part0 << std::endl;
	std::cout << "part1: " << part1 << std::endl;
	std::cout << "part2: " << part2 << std::endl;
	std::cout << "part3: " << part3 << std::endl;
	TQString block="";
	TQString block0 = dec2bin(part0);
	TQString block1 = dec2bin(part1);
	TQString block2 = dec2bin(part2);
	TQString block3 = dec2bin(part3);
	
	std::cout << "block0: " << block0.local8Bit() << std::endl;
	std::cout << "block1: " << block1.local8Bit() << std::endl;
	std::cout << "block2: " << block2.local8Bit() << std::endl;
	std::cout << "block3: " << block3.local8Bit() << std::endl;
	block = block0 + block1 +block2 + block3;
	std::cout << "block: " << block.local8Bit() << std::endl;

	for (int i=0; i< 31;i++)
	{
		if (block.mid(i,1) == "1")
			byteSetCount++;
	}
	return byteSetCount;
}

#include "utils.moc"
