/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  Copyright (C) 2006 Dario Abatianni <eisfuchs@tigress.com>
  Copyright (C) 2006 John Tapsell <johnflux@gmail.com>
*/

#ifndef KONVERSATIONHIGHLIGHT_CONFIG_H
#define KONVERSATIONHIGHLIGHT_CONFIG_H

#include "highlight_preferencesui.h"
#include "konvisettingspage.h"

#include <tqobject.h>
#include <tqlistview.h>

class Highlight_Config;
class Highlight;

class Highlight_Config : public Highlight_ConfigUI, public KonviSettingsPage
{
    TQ_OBJECT
  

    public:
        explicit Highlight_Config(TQWidget *parent = 0, const char *name = 0);
        ~Highlight_Config();

    public:
        virtual void saveSettings();
        virtual void loadSettings();
        virtual void restorePageToDefaults();

        virtual bool hasChanged();

    signals:
        void modified();

    protected slots:
        void highlightSelected(TQListViewItem* item);
        void highlightTextChanged(const TQString& newPattern);
        void highlightTextEditButtonClicked();
        void highlightColorChanged(const TQColor& newColor);
        void soundURLChanged(const TQString& newURL);
        void autoTextChanged(const TQString& newText);
        void addHighlight();
        void removeHighlight();
        void playSound();
        TQPtrList<Highlight> getHighlightList(); // prefs format
        TQStringList currentHighlightList();     // hasChanged() format
    protected:
        void updateButtons();

        bool newItemSelected;
        TQStringList m_oldHighlightList;
};

#endif

