/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** TQt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/

/*
 *  SQ_ImageProperties shows image properties.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef SQ_HAVE_KEXIF
#include <libkexif/kexifwidget.h>
#include <libkexif/kexifdata.h>
#include <tqobjectlist.h>
#include "sq_config.h"
#endif

void SQ_ImageProperties::init()
{
    menu = new TDEPopupMenu;
    copy = KStdAction::copy(TQT_TQOBJECT(this), TQT_SLOT(slotCopyString()), 0);
    copyentry = new TDEAction(i18n("Copy entry"), 0, TQT_TQOBJECT(this), TQT_SLOT(slotCopyEntry()), 0);
    copyall = new TDEAction(i18n("Copy all entries"), 0, TQT_TQOBJECT(this), TQT_SLOT(slotCopyAll()), 0);

    copyentry->setIcon(copy->icon());
    copyall->setIcon(copy->icon());

    copy->plug(menu);
    copyentry->plug(menu);
    copyall->plug(menu);

    ok = SQ_IconLoader::instance()->loadIcon("ok", TDEIcon::Desktop, 16);
    error = SQ_IconLoader::instance()->loadIcon("error", TDEIcon::Desktop, 16);
}

void SQ_ImageProperties::destroy()
{
#ifdef SQ_HAVE_KEXIF
    SQ_Config::instance()->setGroup("GL view");
    SQ_Config::instance()->writeEntry("exifmode", exifMode);
#endif

    delete copyall;
    delete copyentry;
    delete copy;
    delete menu;
}

void SQ_ImageProperties::setParams(TQStringList &l)
{
    setFileParams();
    
    TQStringList::Iterator it = l.begin();
    textType->setText(*it); ++it;
    textDimensions->setText(*it); ++it;
    textBpp->setText(*it); ++it;
    textColorModel->setText(*it); ++it;
    textCompression->setText(*it); ++it;
    textUncompressed->setText(*it); ++it;
    textRatio->setText(*it); ++it;
    textInterlaced->setText(*it); ++it;
    int errors = (*it).toInt(); ++it;
    textFrames->setText(*it); ++it;
    textFrame->setText(*it); ++it;
    TQString s = TQString::fromLatin1("%1").arg(i18n("1 error", "%n errors", errors));
    textStatus->setText((errors)?s:TQString());
    textStatusIcon->setPixmap((errors)?error:ok);

    s = TQString::fromLatin1("%1%2").arg(*it).arg(i18n(" ms."));
    textDelay->setText(s);
}

void SQ_ImageProperties::setURL(const KURL &_url)
{
    url = _url;
}

void SQ_ImageProperties::setFileParams()
{
    TDEIO::Job *stjob = TDEIO::stat(url, false);
    connect(stjob, TQT_SIGNAL(result(TDEIO::Job *)), TQT_TQOBJECT(this), TQT_SLOT(slotStatResult(TDEIO::Job *)));

#ifdef SQ_HAVE_KEXIF
        SQ_Config::instance()->setGroup("GL view");
        exifMode = SQ_Config::instance()->readNumEntry("exifmode", 0);

        TQWidget *tabWidgetEXIF = new TQWidget(tabWidget, "tabWidgetEXIF");
        tabWidget->addTab(tabWidgetEXIF, i18n("EXIF"));
        TQGridLayout *pageLayout6 = new TQGridLayout(tabWidgetEXIF, 2, 1, 11, 6, "tabWidgetEXIFLayout");

        TQButtonGroup *gr = new TQButtonGroup(tabWidgetEXIF, "EXIF mode");
        gr->setFrameShape(TQFrame::NoFrame);
        gr->setExclusive(true);
        connect(gr, TQT_SIGNAL(clicked(int)), TQT_TQOBJECT(this), TQT_SLOT(slotModeClicked(int)));

        TQGridLayout *pageLayoutGR = new TQGridLayout(gr, 1, 3, 0, -1, "tabWidgetEXIFGRLayout");

        TQPushButton *mode1 = new TQPushButton(i18n("Simple"), gr, "mode1");
        mode1->setToggleButton(true);

        TQPushButton *mode2 = new TQPushButton(i18n("Full"), gr, "mode2");
        mode2->setToggleButton(true);

        TQSpacerItem *spacer = new TQSpacerItem(15, 1, TQSizePolicy::Expanding, TQSizePolicy::Minimum);

        // create KEXIF widget and load metadata from file
        KExifWidget *kew1 = new KExifWidget(tabWidgetEXIF);
        kew1->loadFile(file);

        // hack to workaround poor libkexif API
        TQObjectList *ch = const_cast<TQObjectList *>(kew1->children());
        for(TQObjectList::iterator it = ch->begin();it != ch->end();++it)
        {
            if((*it)->inherits("TQListView"))
            {
                TQListView *l = dynamic_cast<TQListView *>(*it);
                TQWidget   *w = tabWidget->page(3);

                if(l && w && !l->childCount())
                    tabWidget->changeTab(w, i18n("EXIF (no)"));

                break;
            }
        }

        // set proper button on
        if(exifMode)
        {
            mode2->setOn(true);
            kew1->setMode(KExifWidget::FULL);
        }
        else
        {
            mode1->setOn(true);
            kew1->setMode(KExifWidget::SIMPLE);
        }

        // finally, add all widgets to layouts
        pageLayoutGR->addWidget(mode1, 0, 0);
        pageLayoutGR->addWidget(mode2, 0, 1);
        pageLayoutGR->addItem(spacer, 0, 2);

        pageLayout6->addWidget(gr, 0, 0);
        pageLayout6->addWidget(kew1, 1, 0);
        kew = kew1;
#endif
}

void SQ_ImageProperties::setMetaInfo(TQValueVector<TQPair<TQString,TQString> > meta )
{
    TQListViewItem *after = 0, *item;

    TQValueVector<TQPair<TQString,TQString> >::iterator itEnd = meta.end();

    for(TQValueVector<TQPair<TQString,TQString> >::iterator it = meta.begin();it != itEnd;++it)
    {
        if(after)
            item = new TQListViewItem(listMeta, after, (*it).first+TQString::fromLatin1("  "), (*it).second.replace(TQChar('\n'), TQChar(' ')));
        else
            after = item = new TQListViewItem(listMeta, (*it).first+TQString::fromLatin1("  "), (*it).second.replace(TQChar('\n'), TQChar(' ')));

        listMeta->insertItem(item);
    }
    
    if(!listMeta->childCount())
    {
        listMeta->header()->hide();

        TQWidget *w = tabWidget->page(2);

        if(w)
            tabWidget->changeTab(w, i18n("Metadata (no)"));
    }
}

void SQ_ImageProperties::slotContextMenu( TQListViewItem *item, const TQPoint &p, int z1 )
{
    if(item)
    {
        data = item;
        z = z1;
        menu->exec(p);
    }
}

void SQ_ImageProperties::slotCopyString()
{
    TQApplication::clipboard()->setText(data->text(z), TQClipboard::Clipboard);
}

void SQ_ImageProperties::slotCopyAll()
{
    if(!data)
        return;

    TQString app;
    TQListViewItem *item = listMeta->firstChild();

    for(;item;item = item->itemBelow())
    {
        app.append(item->text(0) + "\n" + item->text(1) + "\n");
    }

    TQApplication::clipboard()->setText(app, TQClipboard::Clipboard);
}

void SQ_ImageProperties::slotCopyEntry()
{
    if(!data)
        return;

    TQString app = data->text(0) + "\n" + data->text(1) + "\n";

    TQApplication::clipboard()->setText(app, TQClipboard::Clipboard);
}

void SQ_ImageProperties::slotModeClicked(int id)
{
// change mode: simple or full
#ifdef SQ_HAVE_KEXIF
    exifMode = id;
    static_cast<KExifWidget *>(kew)->setMode(id ? KExifWidget::FULL : KExifWidget::SIMPLE);
#endif
}

void SQ_ImageProperties::slotStatResult(TDEIO::Job *job)
{
    if(!job->error())
    {
	TDEIO::UDSEntry entry = static_cast<TDEIO::StatJob*>(job)->statResult();
	KFileItem fi(entry, url);

	KURL t = url;
	t.cd("..");
	lineDirectory->setText(t.isLocalFile() ? t.path() : t.prettyURL());
	lineFile->setText(fi.name());

	textSize->setText(TDEIO::convertSize(fi.size()));
	textOwner->setText(TQString("%1").arg(fi.user()));
	textGroup->setText(TQString("%1").arg(fi.group()));
	textPermissions->setText(fi.permissionsString());
    
	TQDateTime abs;
	abs.setTime_t(fi.time(TDEIO::UDS_CREATION_TIME));
	textCreated->setText(abs.toString("dd/MM/yyyy hh:mm:ss"));
	abs.setTime_t(fi.time(TDEIO::UDS_ACCESS_TIME));
	textLastRead->setText(abs.toString("dd/MM/yyyy hh:mm:ss"));
	abs.setTime_t(fi.time(TDEIO::UDS_MODIFICATION_TIME));
	textLastMod->setText(abs.toString("dd/MM/yyyy hh:mm:ss"));
    }
}

// set local file for KEXIF
void SQ_ImageProperties::setFile(const TQString &_file)
{
    file = _file;
}
