/*
 * Port for usage with qt-framework and development for tdesvn
 * (C) 2005-2007 by Rajko Albrecht
 * http://tdesvn.alwins-world.de
 */
/*
 * ====================================================================
 * Copyright (c) 2002-2005 The RapidSvn Group.  All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library (in the file LGPL.txt); if not,
 * write to the Free Software Foundation, Inc., 51 Franklin St,
 * Fifth Floor, Boston, MA  02110-1301  USA
 *
 * This software consists of voluntary contributions made by many
 * individuals.  For exact contribution history, see the revision
 * history and logs, available at http://rapidsvn.tigris.org/.
 * ====================================================================
 */
#if defined( _MSC_VER) && _MSC_VER <= 1200
#pragma warning( disable: 4786 )// debug symbol truncated
#endif

// svncpp
#include "svnqt/client_impl.h"
#include "svn_opt.h"
#include "svnqt/svnqt_defines.h"

#include <tqmap.h>
#include <tqstringlist.h>

#if (!(SVN_VER_MAJOR == 1 && SVN_VER_MINOR <= 8))
apr_array_header_t* svn_sort__hash(apr_hash_t *ht,
        int (*comparison_func)(const svn_sort__item_t*, const svn_sort__item_t*), apr_pool_t *pool)
{
  apr_hash_index_t *hi;
  apr_array_header_t *ary;
  svn_boolean_t sorted;
  svn_sort_item_type *prev_item;

  /* allocate an array with enough elements to hold all the keys. */
  ary = apr_array_make(pool, apr_hash_count(ht), sizeof(svn_sort_item_type));

  /* loop over hash table and push all keys into the array */
  sorted = TRUE;
  prev_item = NULL;
  for (hi = apr_hash_first(pool, ht); hi; hi = apr_hash_next(hi))
	{
		svn_sort_item_type *item = (svn_sort_item_type*)apr_array_push(ary);
		apr_hash_this(hi, &item->key, &item->klen, &item->value);

		if (prev_item == NULL)
		{
			prev_item = item;
			continue;
		}

		if (sorted)
		{
			sorted = (comparison_func((svn_sort__item_t*)prev_item, (svn_sort__item_t*)item) < 0);
			prev_item = item;
		}
	}

  /* quicksort the array if it isn't already sorted.  */
  if (!sorted)
  {
    qsort(ary->elts, ary->nelts, ary->elt_size,
          (int (*)(const void*, const void*))comparison_func);
  }

  return ary;
}
#endif

namespace svn
{

  Client_impl::Client_impl (ContextP context)
	: Client()
  {
    setContext (context);
  }

  Client_impl::~Client_impl ()
  {
  }

  const ContextP
  Client_impl::getContext () const
  {
    return m_context;
  }

  void
  Client_impl::setContext (ContextP context)
  {
    m_context = context;
  }


  void
  Client_impl::url2Revision(const TQString&revstring,
        Revision&start,Revision&end)
  {
    Pool pool;
    int n = svn_opt_parse_revision(start,end,revstring.TOUTF8(),pool);

    if (n<0) {
        start = Revision::UNDEFINED;
        end = Revision::UNDEFINED;
    }
  }

    void Client_impl::url2Revision(const TQString&revstring,Revision&start)
    {
        if (revstring=="WORKING") {
            start = Revision::WORKING;
        } else if (revstring=="BASE"){
            start = Revision::BASE;
        } else if (revstring=="START"){
            start = Revision::START;
        } else {
            Revision end;
            url2Revision(revstring,start,end);
        }
  }

  apr_hash_t * Client_impl::map2hash(const PropertiesMap&aMap,const Pool&pool)
  {
      if (aMap.count()==0) {
          return 0;
      }
      apr_hash_t * hash = apr_hash_make(pool);
      PropertiesMap::ConstIterator it;
      const char*propval;
      const char*propname;
      TQByteArray s,n;
      for (it=aMap.begin();it!=aMap.end();++it) {
          s=it.data().TOUTF8();
          n=it.key().TOUTF8();
          propval=apr_pstrndup(pool,s,s.size());
          propname=apr_pstrndup(pool,n,n.size());
          apr_hash_set(hash,propname,APR_HASH_KEY_STRING,propval);
      }
      return hash;
  }
}
