#include "kprocessorview.h"

#include <tqlabel.h>
#include <tqlayout.h>
#include <tqscrollview.h>
#include <tqsize.h>
#include <tqmessagebox.h>
#include <tqpopupmenu.h>
#include <tqcursor.h>

MyListView::MyListView(TQWidget *parent) : TDEListView(parent)
{
	connect( this, TQT_SIGNAL( contextMenu( TDEListView *, TQListViewItem *, const TQPoint & ) ),
             TQT_SLOT( slotContextMenu( TDEListView *, TQListViewItem *, const TQPoint & ) ) );
}

MyListView::~MyListView()
{
}

void MyListView::slotContextMenu( TDEListView *, TQListViewItem *, const TQPoint & ) 
{
//	mousePressEvent( NULL ) ;
	emit showPopupMenu() ;
}
/*
void MyListView::mousePressEvent( TQMouseEvent * event )
{
	//TQMessageBox::information( this, "information", "mouse pressed" ) ;
	
//	if ( event->button() == RightButton ) 
		emit showPopupMenu() ;
//	else
//		TDEListView::mousePressEvent( event ) ;
}
*/

TDEProcessorView::TDEProcessorView(TQWidget *parent, const char *name)
 : TDEToolBar(parent)
{
	name = name ; // avoid compiler warning
	
	view = new MyListView( this ) ;
	
	connect( view, TQT_SIGNAL( itemRenamed( TQListViewItem*) ), this, TQT_SLOT( slotItemRenamed(TQListViewItem*) ) ) ;
	connect( view, TQT_SIGNAL( showPopupMenu() ), this, TQT_SLOT( showPopupMenu() ) ) ;

	view->addColumn( "Register" ) ;
	view->addColumn( "Value" ) ;
	view->setRootIsDecorated( true ) ;
	view->setRenameable( 1, true ) ;	// Column 1 is renameable
	view->setRenameable( 0, false ) ;	// Column 1 is renameable
	view->setItemsRenameable( true ) ;
	setWidget( view ) ;
	setResizeEnabled( true ) ;
	
	int i ;
	char str[ 128 ] ;
	
	TQListViewItem *cpu = new TQListViewItem( view ) ;
	cpu->setText( 0, "CPU" ) ;

	TQListViewItem *flags = new TQListViewItem( cpu ) ;
	flags->setText( 0, "Flags" ) ;

	zeroFlag = new TQListViewItem( flags ) ;
	zeroFlag->setText( 0, "Zero" ) ;
	zeroFlag->setText( 1, "0" ) ;
	
	carryFlag = new TQListViewItem( flags ) ;
	carryFlag->setText( 0, "Carry" ) ;
	carryFlag->setText( 1, "0" ) ;
	
	ieFlag = new TQListViewItem( flags ) ;
	ieFlag->setText( 0, "IE" ) ;
	ieFlag->setText( 1, "0" ) ;
	
	TQListViewItem *reg = new TQListViewItem( cpu ) ;
	reg->setText( 0, "Registers" ) ;

	for ( i = 0 ; i < 16 ; i++ ) {
		regs[ i ] = new TQListViewItem( reg ) ;
		sprintf( str, "s%X", i ) ;
		regs[ i ]->setText( 0, str ) ;
		regs[ i ]->setText( 1, "0" ) ;
	}
	
	view->setOpen( cpu, true ) ;
	view->setOpen( flags, true ) ;
	view->setOpen( reg, true ) ;

	m_bHexMode = false ;
}

void TDEProcessorView::slotHexMode()
{
	unsigned char regs[ 16 ] ;

	getRegisterValues(regs) ;
	m_bHexMode = !m_bHexMode ;
	setRegisterValues(regs) ;
}

void TDEProcessorView::showPopupMenu() 
{
	TQPopupMenu *menu = new TQPopupMenu( this ) ;
	menu->insertItem( "Hexadecimal", this, TQT_SLOT( slotHexMode() ), 0, 1 ) ;
	menu->setItemChecked( 1, m_bHexMode ) ;	
	menu->exec( TQCursor::pos() );
}

void TDEProcessorView::slotItemRenamed( TQListViewItem * item )
{
	int i, value, base ;
	bool ok ;
	
	if ( m_bHexMode ) base = 16 ;
	else              base = 10 ;

	if ( !item )
		return ;
	
	for ( i = 0 ; i < 16 ; i++ ) {
		if ( item == regs[ i ] ) {
			value = item->text(1).toInt( &ok, base ) ;
		
			if ( !ok || value < 0 || value > 255 ) {
				TQMessageBox::warning( parentWidget(), "Modify register", "Value should be between 0-255" ) ;
				view->rename( item, 1 ) ;
			} else {
				emit processorRegsChanged() ;
			}
			return ;
		}
	}
	
	if ( zeroFlag == item || carryFlag == item || ieFlag == item ) {
		value = item->text(1).toInt( &ok ) ;
		if ( !ok || value < 0 || value > 1 ) {
			TQMessageBox::warning( parentWidget(), "Modify flag", "Value should be between 0-1" ) ;
		} else
			emit processorFlagsChanged() ;
	}
}

void TDEProcessorView::resizeEvent( TQResizeEvent *event )
{
	event = event ;
//	view->resize( width() - 10, height() - 10 ) ;
}

void TDEProcessorView::getRegisterValues( unsigned char *values )
{
	int i, base ;
	bool ok ;

	if ( m_bHexMode ) base = 16 ;
	else              base = 10 ;

	for ( i = 0 ; i < 16 ; i++ ) {
		values[ i ] = regs[ i ]->text(1).toInt( &ok, base ) ;
	}
}

void TDEProcessorView::setRegisterValues( unsigned char *values )
{
	int i, base ;
		
	if ( m_bHexMode ) base = 16 ;
	else              base = 10 ;

	TQString str; 
	for ( i = 0 ; i < 16 ; i++ ) {
		str.setNum( values[ i ], base ) ;
		regs[ i ]->setText( 1, str ) ;
	}
}
		
void TDEProcessorView::setFlags( unsigned char flags )
{
	if ( flags & 0x01 ) zeroFlag->setText( 1, "1" ) ;
	else                zeroFlag->setText( 1, "0" ) ;
	
	if ( flags & 0x02 ) carryFlag->setText( 1, "1" ) ;
	else                carryFlag->setText( 1, "0" ) ;	
		
	if ( flags & 0x04 ) ieFlag->setText( 1, "1" ) ;
	else                ieFlag->setText( 1, "0" ) ;
} 

unsigned char TDEProcessorView::getFlags() 
{
	unsigned char flags = 0 ;
		
	if ( zeroFlag->text(1).toInt() == 1 )  flags |= 0x01 ;
	if ( carryFlag->text(1).toInt() == 1 ) flags |= 0x02 ;
	if ( ieFlag->text(1).toInt() == 1 )    flags |= 0x04 ;
	
	return flags ;
}

TDEProcessorView::~TDEProcessorView()
{
	delete view ;
}

#include "kprocessorview.moc"

