/***************************************************************************
 *   Copyright (C) 2002 by Bernd Gehrmann                                  *
 *   bernd@kdevelop.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "custombuildoptionswidget.h"

#include <tqcheckbox.h>
#include <klineedit.h>
#include <kurlrequester.h>
#include <kurlcompletion.h>
#include <tdefiledialog.h>
#include <tqradiobutton.h>
#include <tqtabwidget.h>
#include "domutil.h"


CustomBuildOptionsWidget::CustomBuildOptionsWidget(TQDomDocument &dom,
                                                   TQWidget *parent, const char *name)
    : CustomBuildOptionsWidgetBase(parent, name),
      m_dom(dom)
{
    ant_button->setChecked(DomUtil::readEntry(dom, "/kdevcustomproject/build/buildtool") == "ant");
    other_button->setChecked(DomUtil::readEntry(dom, "/kdevcustomproject/build/buildtool") == "other");
    if( !DomUtil::readEntry(dom, "/kdevcustomproject/build/builddir").isEmpty()
            && TQFileInfo( DomUtil::readEntry(dom, "/kdevcustomproject/build/builddir") ).exists() )
    {
        builddir_edit->setURL(DomUtil::readEntry(dom, "/kdevcustomproject/build/builddir"));
        builddir_edit->fileDialog()->setURL( DomUtil::readEntry(dom, "/kdevcustomproject/build/builddir") );
    }
    else
    {
        builddir_edit->setURL( TQString() );
        builddir_edit->fileDialog()->setURL( TQString() );
    }
    builddir_edit->completionObject()->setMode(KURLCompletion::DirCompletion);
    builddir_edit->setMode( KFile::Directory | KFile::ExistingOnly | KFile::LocalOnly );

    // This connection must not be made before the ant->setChecked() line,
    // because at this time makeToggled() would crash
    connect( make_button, TQT_SIGNAL(toggled(bool)),
            this, TQT_SLOT(makeToggled(bool)) );
    connect( other_button, TQT_SIGNAL(toggled(bool)),
             this, TQT_SLOT(otherToggled(bool)) );
}


CustomBuildOptionsWidget::~CustomBuildOptionsWidget()
{}


void CustomBuildOptionsWidget::accept()
{
    TQString buildtool;
    if (ant_button->isChecked())
    {
        buildtool = "ant";
    }
    else if (other_button->isChecked())
    {
        buildtool = "other";
    }
    else
    {
        buildtool = "make";
    }
    DomUtil::writeEntry(m_dom, "/kdevcustomproject/build/buildtool", buildtool);
    DomUtil::writeEntry(m_dom, "/kdevcustomproject/build/builddir", builddir_edit->url());
}


void CustomBuildOptionsWidget::setMakeOptionsWidget(TQTabWidget *tw, TQWidget *mow, TQWidget* oow)
{
    m_tabWidget = tw;
    m_makeOptions = mow;
    m_otherOptions = oow;
    makeToggled(make_button->isChecked());
    otherToggled(other_button->isChecked());
}

void CustomBuildOptionsWidget::otherToggled(bool b)
{
    m_tabWidget->setTabEnabled(m_otherOptions, b);
}

void CustomBuildOptionsWidget::makeToggled(bool b)
{
    m_tabWidget->setTabEnabled(m_makeOptions, b);
}

#include "custombuildoptionswidget.moc"
