 /*
    This file is part of tdepim.

    Copyright (c) 2004 Reinhold Kainhofer <reinhold@kainhofer.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/
#ifndef KCAL_RESOURCEBLOGGING_H
#define KCAL_RESOURCEBLOGGING_H

#include <kcal_resourcegroupwarebase.h>
#include <kdemacros.h>

namespace KBlog {
class APIBlog;
}

namespace KCal {

/**
  This class provides a resource for accessing blogs on a blogging server as journals
*/
class KDE_EXPORT ResourceBlogging : public ResourceGroupwareBase
{
    TQ_OBJECT
  
  public:
    ResourceBlogging();
    ResourceBlogging( const TDEConfig * );

    void readConfig( const TDEConfig *config );
    void writeConfig( TDEConfig *config );

    bool addEvent( Event* ) { return false; }
    bool addTodo( Todo * ) { return false; }
    bool deleteEvent( Event* ) { return false; }
    bool deleteTodo( Todo * ) { return false; }
    static KBlog::APIBlog *api() { return mAPI; }

  protected:
    void init();
    static KBlog::APIBlog *mAPI;
};

}

#endif
