# Copyright 2022 The Trinity Desktop Project
# Distributed under the terms of the GNU General Public License v2

EAPI="8"

TRINITY_MODULE_TYPE="dependencies"
PYTHON_COMPAT=( python3_{8..11} )

inherit trinity-base-2 python-single-r1 flag-o-matic

DESCRIPTION="Python/C++ bindings generator runtime library"
HOMEPAGE="https://trinitydesktop.org"
LICENSE="|| ( GPL-2 GPL-3 SIP )"
SLOT="0"
if [[ ${PV} != *9999* ]] ; then
	KEYWORDS="~amd64 ~arm64 ~x86"
fi
IUSE=""
REQUIRED_USE="${PYTHON_REQUIRED_USE}"

DEPEND="${PYTHON_DEPS}
	~x11-libs/tqscintilla-${PV}
	~dev-tqt/tqtinterface-${PV}
"
RDEPEND="${DEPEND}"

TQTDIR="/usr/tqt3"
BUILD_DIR="${S}"

src_prepare() {
	eapply_user
}

src_configure() {
	local myconf
	append-cflags "-I/usr/include/tqt -I/${TQTDIR}/include"
	myconf=(
	-b "${TDEDIR}/bin"
	-e "${TDEDIR}/include"
	)
	echo yes | "${EPYTHON}" configure.py "${myconf[@]}" CFLAGS="${CFLAGS}" || die
}

src_compile() {
	emake
}

src_install() {
	emake install DESTDIR="${D}"
}
