#!/bin/bash

function run_pdebuild()
{
  # pbuilder absolute paths
  PBUILDER_HOOK_DIR="/var/cache/pbuilder/hooks"
  PBUILDER_SHELL_HOOK_TEMPLATE="$SCRIPT_DIR/internals/C10shell"
  PBUILDER_SHELL_HOOK="$PBUILDER_HOOK_DIR/C10shell"
  PBUILDER_DEPS_HOOK="$PBUILDER_HOOK_DIR/D05deps"

  # Sign packages optino
  OPT_SIGN_PKG_PBUILDER=""
  if [ ! -z "$GPG_SIGN_KEYID" ]; then
    OPT_SIGN_PKG_LOCAL="-k$GPG_SIGN_KEYID"
    OPT_SIGN_PKG_PBUILDER="--auto-debsign --debsign-k $GPG_SIGN_KEYID"
  fi

  ## Build module in a clean chroot environment using pbuilder
  # Install/remove shell hook
  if [ ! -d "$PBUILDER_HOOK_DIR" ]; then
    mkdir -p "$PBUILDER_HOOK_DIR"
  fi
  if [ "$bool_SHELL_HOOK" = "y" ]; then
    cp "$PBUILDER_SHELL_HOOK_TEMPLATE" "$PBUILDER_SHELL_HOOK"
    chmod a+x "$PBUILDER_SHELL_HOOK"
  else
    if [ -x "$PBUILDER_SHELL_HOOK" ]; then
      rm "$PBUILDER_SHELL_HOOK"
    fi
  fi
  # Build using pbuilder
  echo -e "${CYellow}> Building using pbuilder${CNone}"
  # Create pbuilder hook to make sure all available packages are scanned
  # Store any existing D05 hook as a temporary file, this will be reinstated at the end
  cat <<END_D05_01 > "$PBUILDER_DEPS_HOOK"
#!/bin/sh
(cd "$TDE_DEBS_DIR"; apt-ftparchive packages . > Packages)
echo "deb [trusted=yes] file:$TDE_DEBS_DIR ./" >> /etc/apt/sources.list
END_D05_01
  if [[ "$USE_PREBUILD_EXTRA_DEPS" = "y" ]]; then
    # Get building branch from .tdescminfo file
    if [[ -f "$MOD_BUILD_PATH/.tdescminfo" ]]; then
      BUILD_BRANCH=`sed -n -r "s/^Revision: ([^-]+)-.*/\1/p" "$MOD_BUILD_PATH/.tdescminfo"`
      bool_EDEPS_FOUND="n"
      OLD_IFS=$IFS && IFS=$' \t'
      while read l_branch l_repo l_component; do
        if [ "$l_branch" = "$BUILD_BRANCH" ]; then
          bool_EDEPS_FOUND="y"
          cat <<END_D05_02 >> "$PBUILDER_DEPS_HOOK"
echo "deb [trusted=yes] $l_repo $DISTRO_NAME $l_component" >> /etc/apt/sources.list
END_D05_02
          break
        fi
      done <<< $(cat "$SCRIPT_DIR/internals/extra_deps.txt" | grep -E "^[[:space:]]*[^#[:space:]]+[[:space:]]+[^[:space:]]+.*$")
      if [ "$bool_EDEPS_FOUND" != "y" ]; then
        # EDEPS repository not found, use default. This could happen when building from sub branches of the main package repo
      while read l_branch l_repo l_component; do
        if [ "$l_branch" = "default" ]; then
          bool_EDEPS_FOUND="y"
          cat <<END_D05_02 >> "$PBUILDER_DEPS_HOOK"
echo "deb [trusted=yes] $l_repo $DISTRO_NAME $l_component" >> /etc/apt/sources.list
END_D05_02
          break
        fi
      done <<< $(cat "$SCRIPT_DIR/internals/extra_deps.txt" | grep -E "^[[:space:]]*[^#[:space:]]+[[:space:]]+[^[:space:]]+.*$")
      fi
      IFS=$OLD_IFS
    fi
  fi
  cat <<END_D05_03 >> "$PBUILDER_DEPS_HOOK"
apt-get update
END_D05_03
  chmod a+x "$PBUILDER_DEPS_HOOK"
  # Build
  OPT_BUILD_PARALLEL=""
  if [ ${DEB_BUILD_PARALLEL+x} ]; then
    OPT_BUILD_PARALLEL="DEB_BUILD_PARALLEL=$DEB_BUILD_PARALLEL"
  fi
  eval pdebuild $OPT_SIGN_PKG_PBUILDER \
                --architecture $ARCHITECTURE  \
                --buildresult \"$MOD_DEB_PATH\" \
                --pbuilderroot \"sudo $OPT_BUILD_PARALLEL DISTRO_NAME=$DISTRO_NAME ARCHITECTURE=$ARCHITECTURE\" \
                --logfile \"$BUILDING_LOG_FILE\" \
                -- \
                --bindmounts \"$TDE_DEBS_DIR\" \
                --hookdir \"$PBUILDER_HOOK_DIR\" \
                $OPT_SHOW_LOGS\"$BUILDING_LOG_FILE\"
  PBUILDER_RETVAL=$?
  # Remove shell hook if it was installed before the build
  if [ -x "$PBUILDER_SHELL_HOOK" ]; then
    rm "$PBUILDER_SHELL_HOOK"
  fi
  # Remove deps hook
  if [ -x "$PBUILDER_DEPS_HOOK" ]; then
    rm "$PBUILDER_DEPS_HOOK"
  fi
  # Return pdebuild return value to calling function
  return $PBUILDER_RETVAL
}


#----------------------------
# The actual code is inside a function to allow the pdebuild return value to be
# correctly passed back to the calling script in all cases (root and non root users)
run_pdebuild
