#!/bin/bash

set -a

#----------------------------
# Repo information
#----------------------------
TDE_DIR=""         							  # TDE root folder
UPDATE_BRANCHES="master"				  # Space separated list. Available choices: master, r14.0.x
DEFAULT_REPO_BRANCH="master"      # After update in completed, switch repo to this branch. Must be
                                  # one of the branches specified in UPDATE_BRANCHES

#----------------------------
# Build information
#----------------------------
TDE_RELEASE="14.1.0"              # TDE release number
DISTRO=""									  			# Distro family (leave empty for auto-detection). For ex. debian
DISTRO_NAME=""              			# Distro name of specific version (leave empty for auto-detection). For ex. buster
ARCHITECTURE=""              			# Build for this architecture (leave empty for auto-detection). For ex. amd64
USE_PREBUILD_EXTRA_DEPS="y"       # If == "y", use pre-built extra dependency packages
BUILD_DEFAULT_OPTIONS="-g -lr"    # Default building options (pbuilder)
GPG_SIGN_KEYID=""								  # Use this GPG key to sign packages. If null, packages will not be signed

#----------------------------
# Base directories
#----------------------------
CFG_SCRIPT_LOG_DIR="0_logs"
CFG_GIT_DIR="1_git"
CFG_BUILD_DIR="2_build"
CFG_REPO_DIR="3_repo"
CFG_EXTRA_DEPS_DIR="edeps"			  # Relative to CFG_GIT_DIR folder. Only required if USE_PREBUILD_EXTRA_DEPS != "y"
CFG_HOOKS_DIR="hooks"     			  # Relative to CFG_GIT_DIR folder

set +a
