#!/bin/bash

# Load common code and initialization
export SCRIPT_DIR=$(dirname $(readlink -f "$0"))
. ${SCRIPT_DIR}/internals/_build_common.sh
init_common

_BUILDSET_TIMER=1
_BUILDSET_TIME="--/--:--:--:---"

parm_SKIP_FETCH="n"     # if "y" skips N packages from the list
parm_SKIP_N=0           # this argument represents the number of packages to skip
SKIP_cnt=0


#----------------------------
# do_exit for set building
function do_exit()
{
	cd "$SCRIPT_DIR"
	if [ $1 -eq 0 ]; then
		echo -e "${CGray}####  Building process for set \"${0##*/}\" completed  ####${CNone}"
	else
		echo -e "${CGray}####  Building process for set \"${0##*/}\" interrupted ($1)  ####${CNone}"
	fi
	exit $1
}


#----------------------------
function set_log_start()
{
  echo -e "${CGray}####  Starting building process for set \"${0##*/}\"  ####${CNone}"
  echo
  echo "----------  ${0##*/}  ----------" >>"$LOG_BUILD_RESULT_FILENAME"
  exec_time_start $_BUILDSET_TIMER
}


#----------------------------
function set_log_end()
{
  exec_time_stop $_BUILDSET_TIMER "_BUILDSET_TIME"
  echo "          [$_BUILDSET_TIME]  SET ${0##*/}" >>"$LOG_BUILD_RESULT_FILENAME"
  echo >>"$LOG_BUILD_RESULT_FILENAME"
  do_exit 0
}


#----------------------------
function build_module()
{
  if [ $parm_SKIP_N -gt 0 -a $SKIP_cnt -lt $parm_SKIP_N ]; then
    SKIP_cnt=$((SKIP_cnt+1))
  else
    ./build_module.sh ${BUILD_DEFAULT_OPTIONS} "$@"
    echo
  fi
}


#----------------------------
# Check command line arguments
#----------------------------
for arg in $@; do
  if [ "$parm_SKIP_FETCH" = "y" ]; then
    parm_SKIP_N=$arg
		parm_SKIP_FETCH="n"BUILD_DEFAULT_OPTIONS
	elif [ "$arg" = "-s" ]; then    		# skip first N packages
		parm_SKIP_FETCH="y"
	fi
done
if [ "$parm_SKIP_FETCH" = "y" ]; then
  echo "Invalid command line arguments ($@)"
  do_exit 3
fi
