#!/bin/bash

# Load common code and initialization
export SCRIPT_DIR=$(dirname $(readlink -f "$0"))
. ${SCRIPT_DIR}/internals/_build_common.sh
init_common

_BUILDALL_TIMER=2
_BUILDALL_TIME="--/--:--:--:---"


#----------------------------
# do_exit for set building
function do_exit()
{
	cd "$SCRIPT_DIR"
	if [ $1 -eq 0 ]; then
		echo -e "${CGray}####  Building process for TDE completed  ####${CNone}"
	else 
		echo -e "${CGray}####  Building process for TDE interrupted ($1)  ####${CNone}"
	fi
	exit $1
}


#----------------------------
function set_log_start()
{
  echo -e "${CGray}####  Starting building process for TDE  ####${CNone}"
  echo
  echo "**********  TDE  **********" >>"$LOG_BUILD_RESULT_FILENAME"
  exec_time_start $_BUILDALL_TIMER
}


#----------------------------
function set_log_end()
{
  exec_time_stop $_BUILDALL_TIMER "_BUILDALL_TIME"
  echo "          [$_BUILDALL_TIME]  All TDE " >>"$LOG_BUILD_RESULT_FILENAME"
  echo >>"$LOG_BUILD_RESULT_FILENAME"
  do_exit 0
}


#----------------------------
# Build TDE
#----------------------------
set_log_start

./91_build_base.sh
./92_build_applications.sh
./17_meta_packages.sh

set_log_end
