/* ============================================================
 * File  : pluginloader.h
 * Author: Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Date  : 2004-02-19
 * Description :
 *
 * Copyright 2004 by Renchi Raju

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU Library General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * ============================================================ */

#ifndef KIPI_PLUGINLOADER_H
#define KIPI_PLUGINLOADER_H

#include "libkipi/interface.h"
#include "libkipi/libkipi_export.h"
#include <tqwidget.h>
#include <tqscrollview.h>


namespace KIPI
{
    class Plugin;
    class Interface;
    class ConfigWidget;

    class LIBKIPI_EXPORT PluginLoader :public TQObject
    {
        Q_OBJECT
  
    public:
        class LIBKIPI_EXPORT Info
        {
		public:
            Info( const TQString& name, const TQString& comment, const TQString& library, bool shouldLoad );
            ~Info();
            TQString name() const;
            
			TQString comment() const;
            
			TQString library() const;
            
			Plugin* plugin() const;
			void setPlugin(Plugin*);
			
            bool shouldLoad() const;
            void setShouldLoad(bool);

		private:
			struct Private;
			Private* d;
        };

        PluginLoader( const TQStringList& ignores, Interface* interface );
        virtual ~PluginLoader();
        void loadPlugins();
        static PluginLoader* instance();
        ConfigWidget* configWidget( TQWidget* parent );

        typedef TQValueList<Info*> PluginList;

        const PluginList& pluginList();

        void loadPlugin( Info* );

    signals:
        void plug( KIPI::PluginLoader::Info* );
        void unplug( KIPI::PluginLoader::Info* );
        void replug();

    private:
        friend class ConfigWidget;
        friend class PluginCheckBox;

		struct Private;
		Private* d;
    };

    class LIBKIPI_EXPORT ConfigWidget :public TQScrollView
    {
        Q_OBJECT
  
    public:
        ConfigWidget( TQWidget* parent );
		~ConfigWidget();
    public slots:
        void apply();
    private:
		struct Private;
		Private* d;
    };
}

#endif /* PLUGINLOADER_H */
