/* ============================================================
 *
 * This file is a part of kipi-plugins project
 * http://www.kipi-plugins.org
 *
 * Date        : 2007-16-07
 * Description : a kipi plugin to export images to Picasa web service
 *
 * Copyright (C) 2007-2008 by Vardhman Jain <vardhman at gmail dot com>
 * Copyright (C) 2008 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef PICASAWEBWINDOW_H
#define PICASAWEBWINDOW_H

// TQt includes.

#include <tqvaluelist.h>
#include <tqpair.h>
#include <tqintdict.h>

// KDE includes.

#include <kdialogbase.h>

// Libkipi includes.

#include <libkipi/interface.h>
#include <libkipi/imagedialog.h>

// Local includes

#include "kpaboutdata.h"

class TQListView;
class TQPushButton;
class TQRadioButton;
class TQSpinBox;
class TQCheckBox;
class TQProgressDialog;
class TDEHTMLPart;
class KURL;
class TQLineEdit;
class TQComboBox;

namespace KIPI
{
class Interface;
}

namespace TDEWallet
{
class Wallet;
}

namespace KIPIPicasawebExportPlugin
{
class PicasawebWidget;
class PicasawebTalker;
class GAlbum;
class GPhoto;
class FPhotoInfo;
class FPhotoSet;
class GAlbumViewItem;

class PicasawebWindow : public KDialogBase
{
    Q_OBJECT
  

public:

    PicasawebWindow(KIPI::Interface *interface, const TQString &tmpFolder,TQWidget *parent);
    ~PicasawebWindow();

    void getToken(TQString& username, TQString& password);

private:

    unsigned int                             m_uploadCount;
    unsigned int                             m_uploadTotal;

    TQListView                               *m_tagView;

    TQSpinBox                                *m_dimensionSpinBox;
    TQSpinBox                                *m_imageQualitySpinBox;

    TQPushButton                             *m_newAlbumButton;
    TQPushButton                             *m_addPhotoButton;
    TQPushButton                             *m_startUploadButton;
    TQPushButton                             *m_reloadAlbumsListButton;
    TQPushButton                             *m_changeUserButton;

    TQString                                  m_tmp;
    TQString                                  m_token;
    TQString                                  m_username;
    TQString                                  m_userId;
    TQString                                  m_lastSelectedAlbum;

    TQCheckBox                               *m_resizeCheckBox;

    TQLineEdit                               *m_tagsLineEdit;

    TQRadioButton                            *m_exportApplicationTags;

    TQProgressDialog                         *m_progressDlg;
    TQProgressDialog                         *m_authProgressDlg;

    TQComboBox                               *m_albumsListComboBox;

    TQLabel                                  *m_userNameDisplayLabel;

//  TDEWallet::Wallet                         *m_wallet;

    TDEHTMLPart                               *m_photoView;
    KURL::List                              *m_urls;

    PicasawebWidget                         *m_widget;
    PicasawebTalker                         *m_talker;

    TQIntDict<GAlbumViewItem>                 m_albumDict;

    TQValueList< TQPair<TQString,FPhotoInfo> >  m_uploadQueue;

    KIPI::Interface                         *m_interface;
    KIPIPlugins::KPAboutData                *m_about; 

private slots:

    void slotTokenObtained(const TQString& token);
    void slotDoLogin();
//  void slotLoginFailed( const TQString& msg );
    void slotBusy( bool val );
    void slotError( const TQString& msg );
//  void slotAlbums( const TQValueList<GAlbum>& albumList );
//  void slotPhotos( const TQValueList<GPhoto>& photoList );
//  void slotTagSelected();
//  void slotOpenPhoto( const KURL& url );
    void slotUpdateAlbumsList();
    void slotUserChangeRequest();
    void slotListPhotoSetsResponse(const TQValueList <FPhotoSet>& photoSetList);
    void slotAddPhotos();
    void slotUploadImages();
    void slotAddPhotoNext();
    void slotAddPhotoSucceeded();
    void slotAddPhotoFailed( const TQString& msg );
    void slotAddPhotoCancel();
    void slotAuthCancel();
    void slotHelp();
    void slotCreateNewAlbum();
    void slotGetAlbumsListSucceeded();
    void slotGetAlbumsListFailed(const TQString& msg);
    void slotRefreshSizeButtons(bool);
//  void slotHandleLogin();

protected:

    void slotClose();
};

} // namespace KIPIPicasawebExportPlugin

#endif /* PICASAWEBWINDOW_H */
