/* ============================================================
 * File  : gpcontroller.h
 * Author: Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Date  : 2003-01-22
 * Description : 
 * 
 * Copyright 2003 by Renchi Raju <renchi@pooh.tam.uiuc.edu>

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

#ifndef GPCONTROLLER_H
#define GPCONTROLLER_H

#include <tqobject.h>
#include <tqthread.h>
#include <tqmutex.h>

#include "mtqueue.h"
#include "gpcommand.h"
#include "cameratype.h"

class TQString;
class TQImage;

namespace KIPIKameraKlientPlugin
{

class GPCamera;

class GPController : public TQObject, public TQThread {
    Q_OBJECT
  

public:
    GPController(TQObject *parent, const CameraType& ctype);
    ~GPController();

    void requestInitialize();
    void requestGetSubFolders(const TQString& folder);
    void requestMakeFolder(const TQString& folder, const TQString& newFolder);
    void requestDeleteFolder(const TQString& folder);
    void requestGetItemsInfo(const TQString& folder);
    void requestGetAllItemsInfo(const TQString& folder);
    void requestGetThumbnail(const TQString& folder, const TQString& imageName);
    void requestDownloadItem(const TQString& folder, const TQString& itemName, const TQString& saveFile);
    void requestDeleteItem(const TQString& folder, const TQString& itemName);
    void requestUploadItem(const TQString& folder, const TQString& localFile, const TQString& uploadName);
    void requestOpenItem(const TQString& folder, const TQString& itemName, const TQString& saveFile);
    void requestOpenItemWithService(const TQString& folder, const TQString& itemName, const TQString& saveFile, const TQString& serviceName);
    void cancel();
    void getInformation(TQString& summary, TQString& manual, TQString& about);

protected:
    void run();

private:
    void initialize();
    void getSubFolders(const TQString& folder);
    void makeFolder(const TQString& folder, const TQString& newFolder);
    void deleteFolder(const TQString& folder);
    void getItemsInfo(const TQString& folder);
    void getAllItemsInfo(const TQString& folder);
    void getThumbnail(const TQString& folder, const TQString& imageName);
    void downloadItem(const TQString& folder, const TQString& itemName, const TQString& saveFile);
    void deleteItem(const TQString& folder, const TQString& itemName);
    void uploadItem(const TQString& folder, const TQString& uploadName, const TQString& localFile);
    void openItem(const TQString& folder, const TQString& itemName, const TQString& saveFile);
    void openItemWithService(const TQString& folder, const TQString& itemName, const TQString& saveFile, const TQString& serviceName);
    void exifInfo(const TQString& folder, const TQString& itemName);
    void error(const TQString& errorMsg);

    void scaleHighlightThumbnail(TQImage& thumbnail);
    void showBusy(bool val);
    
    TQObject  *parent_;
    GPCamera *camera_;
    TQMutex    mutex_;
    MTQueue<GPCommand> cmdQueue_;
    bool      close_;

private slots:
    void slotStatusMsg(const TQString& msg);
    void slotProgressVal(int val);
    void slotErrorMsg(const TQString& msg);
};

}  // NameSpace KIPIKameraKlientPlugin

#endif /* GPCONTROLLER_H */
