// This is an example not a library
/*
 * This file is part of the Polkit-tqt project
 * Copyright (C) 2009 Jaroslav Reznik <jreznik@redhat.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB. If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "tqstringlist.h"
#include "tqinputdialog.h"

#include "polkit-tqt-identity.h"
#include "polkit-tqt-details.h"
#include "polkit-tqt-agent-session.h"
#include "tqtlistener.h"


using namespace PolkitTQt::Agent;

TQtListener::TQtListener(TQObject *parent) : Listener(parent)
{
  tqDebug("Registering TQt listener");
}

void TQtListener::initiateAuthentication(const TQString &actionId, const TQString &message,
        const TQString &iconName, const PolkitTQt::Details &details, const TQString &cookie,
        const PolkitTQt::Identity::List &identities, AsyncResult *result)
{
  tqDebug(TQString("Initiate authentication for %1 with message %2").arg(actionId).arg(message));
  tqDebug(TQString("    iconName %1").arg(iconName));
  TQStringList dkeys = details.keys();
  for (const TQString &dkey : dkeys)
  {
    tqDebug(TQString("    key %1").arg(dkey));
  }
  tqDebug(TQString("    cookie %1").arg(cookie));

  for (const PolkitTQt::Identity &identity : identities)
  {
    tqDebug(identity.toString());
    Session *session = new Session(identity, cookie, result);
    connect(session, TQT_SIGNAL(request(const TQString&, bool)), this,
            TQT_SLOT(request(const TQString&, bool)));
    connect(session, TQT_SIGNAL(completed(bool)), this, TQT_SLOT(completed(bool)));
    connect(session, TQT_SIGNAL(showError(const TQString&)), this,
            TQT_SLOT(showError(const TQString&)));
    connect(session, TQT_SIGNAL(showInfo(const TQString&)), this,
            TQT_SLOT(showInfo(const TQString&)));
    session->initiate();
  }
}

bool TQtListener::initiateAuthenticationFinish()
{
  tqDebug("InitiateAuthenticationFinish() done");
  return true;
}

void TQtListener::cancelAuthentication()
{
  tqDebug("Cancelling authentication");
}

void TQtListener::request(const TQString &request, bool echo)
{
  tqDebug(TQString("Request: %1").arg(request));
  Session *session = (Session*)sender();
  bool ok;
  TQString text = TQInputDialog::getText("TQt Agent", "Enter authorization password:",
      TQLineEdit::Password, TQString::null, &ok, nullptr );
  if (ok && !text.isEmpty())
  {
    session->setResponse(text);
  }
  else
  {
    session->setResponse(TQString::null);
  }
}

void TQtListener::completed(bool gainedAuthorization)
{
  tqDebug(TQString("Completed: %1").arg(gainedAuthorization ? "true" : "false"));
  Session *session = (Session*)sender();
  session->result()->setCompleted();
  delete session;
}

void TQtListener::showError(const TQString &text)
{
  tqDebug(TQString("Error: %1").arg(text));
}

void TQtListener::showInfo(const TQString &text)
{
  tqDebug(TQString("Info: %1").arg(text));
}

#include "tqtlistener.moc"
