//
// C++ Interface: cvslogdialog
//
// Description:
//
//
// Author: KDevelop Authors <kdevelop-devel@kdevelop.org>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef CVSLOGDIALOG_H
#define CVSLOGDIALOG_H

#include <kdialogbase.h>

class CvsJob_stub;
class CvsService_stub;
class CVSLogPage;

/**
Implementation for the form displaying 'cvs log' output.

@author KDevelop Authors
*/
class CVSLogDialog : public KDialogBase
{
    Q_OBJECT
  
public:
    CVSLogDialog( CvsService_stub *cvsService, TQWidget *parent=0, const char *name=0, int flags=0 );
    virtual ~CVSLogDialog();

    void startLog( const TQString &workDir, const TQString &pathName );

private slots:
    void slotDiffRequested( const TQString &pathName, const TQString &revA, const TQString &revB );
    virtual void slotCancel();

private:
//    void parseLogContent( const TQString& text );
    void displayActionFeedback( bool working );

private:
    TQString m_pathName;

    CVSLogPage *m_cvsLogPage;
    CvsService_stub *m_cvsService;
};

#endif
