// Author: Denis Kozadaev - (c) 2017-2020


#ifndef	__GAME_BOARD_H__
#define	__GAME_BOARD_H__

#include <stdlib.h>

#include <tqwidget.h>
#include <tqlabel.h>
#include <tqpixmap.h>
#include <tqtimer.h>


class BoardItem:public TQLabel
{
public:

	BoardItem(int, TQWidget *parent = NULL, const char *name = NULL);
	~BoardItem();

	int	item()const{return (num);}

private:
	int	num;

protected:
	void	paintEvent(TQPaintEvent *);
};

//------------------------------------------------------------------------------

class GameBoard:public TQWidget
{
	Q_OBJECT
public:

	GameBoard(TQWidget *parent = NULL, const char *name = NULL);
	~GameBoard();

	void	newGame();
	void	loadImage();

private:
	int		n, nt, xt, yt, dx, dy;
	BoardItem	*map[16];
	TQTimer		*tmr;
	TQPixmap	origin;

	void	initMap();
	void	startMoving(int, int);
	void	checkEndGame();
	void	newTask();

	int	index(int, int);
	int	mayMove(int);
	int	step(int, int);
	int	sign(int);

protected:
	void	resizeEvent(TQResizeEvent *);
	void	mousePressEvent(TQMouseEvent *);

private slots:
	void	moveItem();
};

#endif	/* __GAME_BOARD_H__ */
