#!/bin/sh -x

# Settings
JS='../kjscmd --noexec'
REF='jsref'

# Examples and changelog
(cd examples ; w3m -dump index.html > README)

# Constructor Index
$JS write_classes.js > $REF/classes.html

# Constructor Index
$JS write_widgets.js > $REF/widgets.html

# Global Objects
$JS write_docs.js 'this' 'this' 'Default context scripts are executed in.' > $REF/this.html

$JS write_docs.js 'Global' 'global' 'The global object.' > $REF/global.html
$JS write_docs.js 'Application' 'application' 'Global application object.' > $REF/application.html
$JS write_docs.js 'Part' 'part' 'Part used by the interpreter.' > $REF/part.html
$JS write_docs.js 'StdDirs' 'StdDirs' 'Provides access to TDEStandardDirs.' > $REF/stddirs.html
$JS write_docs.js 'StdIcons' 'StdIcons' 'Provides access to the TDEIconLoader.' > $REF/stdicons.html

# Custom Objects
$JS write_docs.js 'Image' 'new Image()' 'Bindings to the TQImage class.' > $REF/image.html
$JS write_docs.js 'Pixmap' 'new Pixmap()' 'Bindings to the TQPixmap class.' > $REF/pixmap.html
$JS write_docs.js 'Painter' 'new Painter()' 'Bindings for painting on Pixmaps.' > $REF/painter.html
$JS write_docs.js 'NetAccess' 'new NetAccess()' 'Bindings for TDEIO::NetAccess.' > $REF/netaccess.html
$JS write_docs.js 'DCOPObject' 'new DCOPObject()' 'Provides support for DCOP.' > $REF/dcop.html
$JS write_docs.js 'SqlDatabase' 'new SqlDatabase()' 'Provides support for QtSQL Databases.' > $REF/sqldatabase.html
$JS write_docs.js 'SqlQuery' 'new SqlQuery()' 'Provides support for QtSQL Queries.' > $REF/sqlquery.html
$JS write_docs.js 'TextStream' 'System.stdin' 'Bindings for TQTextSteam.' > $REF/textstream.html
$JS write_docs.js 'Config' 'new Config()' 'Bindings to the TDEConfig class.' > $REF/config.html

# Qt Objects
OBJECTS="TQPushButton TQToolButton TQCheckBox TQRadioButton"
OBJECTS="$OBJECTS TQGroupBox TQButtonGroup TQIconView TQTable"
OBJECTS="$OBJECTS TQListBox TQListView TQLineEdit TQSpinBox"
OBJECTS="$OBJECTS TQMultiLineEdit TQLabel TextLabel PixmapLabel"
OBJECTS="$OBJECTS TQLayoutWidget TQTabWidget TQComboBox"
OBJECTS="$OBJECTS TQWidget TQDialog TQWizard TQLCDNumber"
OBJECTS="$OBJECTS TQProgressBar TQTextView TQTextBrowser"
OBJECTS="$OBJECTS TQDial TQSlider TQFrame Line TQTextEdit"
OBJECTS="$OBJECTS TQDateEdit TQTimeEdit TQDateTimeEdit TQScrollBar"
OBJECTS="$OBJECTS TQPopupMenu TQWidgetStack TQMainWindow"
OBJECTS="$OBJECTS TQDataTable TQDataBrowser TQDataView"
OBJECTS="$OBJECTS TQVBox TQHBox TQGrid"

for OBJ in $OBJECTS ;
do
  FILENAME=`echo $OBJ | tr '[A-Z]' '[a-z]'`
  $JS write_docs.js "$OBJ" "new $OBJ()" "Bindings for a $OBJ." > "$REF/$FILENAME.html" ;
done

OBJECTS=""

OBJECTS="$OBJECTS KActiveLabel KCharSelect KColorButton KColorCombo"
OBJECTS="$OBJECTS KComboBox TDECModule KDateWidget KDatePicker KDialog"
OBJECTS="$OBJECTS KDualColorButton KEditListBox TDEFontCombo KGradientSelector"
OBJECTS="$OBJECTS KHistoryCombo KHSSelector KLed TDEListBox TDEListView"
OBJECTS="$OBJECTS KLineEdit KPasswordEdit KProgress KPushButton"
OBJECTS="$OBJECTS KRestrictedLine TDEIconButton KIntSpinBox KRuler"
OBJECTS="$OBJECTS KSqueezedTextLabel KTextBrowser KTextEdit"
OBJECTS="$OBJECTS KURLLabel KURLRequester"
OBJECTS="$OBJECTS KIntNumInput KDoubleNumInput KDoubleSpinBox"

for OBJ in $OBJECTS ;
do
  FILENAME=`echo $OBJ | tr '[A-Z]' '[a-z]'`
  $JS write_docs.js "$OBJ" "new $OBJ()" "Bindings for a $OBJ." > "$REF/$FILENAME.html" ;
done


OBJECTS="$OBJECTS TQSplitter"
OBJECTS="$OBJECTS TQObject TQTimer"

OBJECTS="$OBJECTS TDEMainWindow TDEAction TDEToggleAction"

for OBJ in $OBJECTS ;
do
  FILENAME=`echo $OBJ | tr '[A-Z]' '[a-z]'`
  $JS write_docs.js "$OBJ" "new $OBJ()" "Bindings for a $OBJ." > "$REF/$FILENAME.html" ;
done



