/***************************************************************************
                          datetime.h  -  description
                             -------------------
    begin                : Mon Jan 7 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DATETIME_H
#define DATETIME_H

/*
 * This two includes are required, because you have to use
 * KRenames internal structures and enums.
 */
#include "batchrenamer.h"
#include "pluginloader.h"
#include "plugin.h"
#include "helpdialog.h"

#include <stdio.h>

class KDatePicker;
class KIntSpinBox;
class TQCheckBox;
class TQButtonGroup;
class TQGroupBox;
class TQLabel;
class TQVBoxLayout;
class TQHBoxLayout;
class TQPushButton;
class TQString;
class TQWidget;

class MyDatePlugin: public Plugin {
    Q_OBJECT
  
    public:
        const TQString getName() const;
        const TQString getAccelName() const;
        const int type() const;

        bool checkError();
        void drawInterface( TQWidget* w, TQVBoxLayout* l );
        void fillStructure();
        TQString processFile( BatchRenamer*, int, TQString token, int );

        const TQPixmap getIcon() const;
                        
    private slots:
        void changeDT();

    protected:
        TQCheckBox* checkAccess;
        TQCheckBox* checkModification;
        KDatePicker* kDate;
        TQLabel* labelTime;
        KIntSpinBox* spinHour;
        KIntSpinBox* spinMinute;
        KIntSpinBox* spinSecond;
        TQPushButton* buttonCurrentDT;

        TQHBoxLayout* Layout0;
        TQVBoxLayout* Layout1;
        TQHBoxLayout* Layout2;

        struct datevals {
            TQDate date;                 // Date

            bool changeModification;    // Change modification date
            bool changeAccess;          // Change access date

            int hour;
            int minute;
            int second;
        } dvals;
};


#endif


