/***************************************************************************
 *   Copyright (C) 2004-2007 by Georgy Yunaev, gyunaev@ulduzsoft.com       *
 *   Please do not use email address above for bug reports; see            *
 *   the README file                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include <tqclipboard.h>

#include <tdehtmlview.h>
#include <kfinddialog.h>

#include "tde-tqt.h"
#include "kchmmainwindow.h"
#include "kchmconfig.h"
#include "kchmviewwindow_tdehtmlpart.h"

#include "kchmviewwindow_tdehtmlpart.moc"


TQWidget * KCHMViewWindow_TDEHTMLPart::getTQWidget()
{
	 return view();
}

KCHMViewWindow_TDEHTMLPart::KCHMViewWindow_TDEHTMLPart( TQTabWidget * parent )
	: TDEHTMLPart ( parent ), KCHMViewWindow ( parent )
{
	m_zoomfactor = 0;
	m_currentEncoding = 0;
	m_searchForward = true;

	invalidate();

	connect( browserExtension(), TQT_SIGNAL( openURLRequest( const KURL &, const KParts::URLArgs & ) ),
		this, TQT_SLOT ( onOpenURLRequest( const KURL &, const KParts::URLArgs & )) );
	
	connect( this, TQT_SIGNAL ( popupMenu ( const TQString &, const TQPoint &) ),
		this, TQT_SLOT ( onPopupMenu ( const TQString &, const TQPoint &) ) );
}


KCHMViewWindow_TDEHTMLPart::~KCHMViewWindow_TDEHTMLPart()
{
}

bool KCHMViewWindow_TDEHTMLPart::openPage (const TQString& url)
{
	// Set or change the encoding
	if ( m_currentEncoding != ::mainWindow->chmFile()->currentEncoding() )
	{
		m_currentEncoding = ::mainWindow->chmFile()->currentEncoding();
		setEncoding ( m_currentEncoding->qtcodec, TRUE );
	}
	
	TQString fullurl = "ms-its:" + ::mainWindow->getOpenedFileName() + "::" + url;
	openURL ( KURL(fullurl) );
	
	return true;
}

void KCHMViewWindow_TDEHTMLPart::setZoomFactor( int zoom )
{
	m_zoomfactor = zoom;
	
	// Default ZoomFactor is 100, any increase or decrease should modify this value.
	TDEHTMLPart::setZoomFactor ( 100 + (m_zoomfactor * 10) );
}

void KCHMViewWindow_TDEHTMLPart::invalidate( )
{
	m_zoomfactor = 0;
	m_searchForward = true;
	m_searchText = TQString();

	setJScriptEnabled ( appConfig.m_kdeEnableJS );
	setJavaEnabled ( appConfig.m_kdeEnableJava );
	setMetaRefreshEnabled ( appConfig.m_kdeEnableRefresh );
	setPluginsEnabled ( appConfig.m_kdeEnablePlugins );
	
	KCHMViewWindow::invalidate( );
}

int KCHMViewWindow_TDEHTMLPart::getScrollbarPosition( )
{
	return view()->contentsY ();
}

void KCHMViewWindow_TDEHTMLPart::setScrollbarPosition( int pos )
{
	view()->scrollBy (0, pos);
}

void KCHMViewWindow_TDEHTMLPart::addZoomFactor( int value )
{
	setZoomFactor( m_zoomfactor + value);
}

bool KCHMViewWindow_TDEHTMLPart::printCurrentPage()
{
	view()->print();
	return true;
}

void KCHMViewWindow_TDEHTMLPart::searchWord( const TQString & word, bool forward, bool )
{
	if ( word != m_searchText || forward != m_searchForward )
	{
		m_searchText = word;
		m_searchForward = forward;
		
		findText ( word, forward ? 0 : KFindDialog::FindBackwards, ::mainWindow, 0 );
	}
	
	findTextNext ();
}

void KCHMViewWindow_TDEHTMLPart::onOpenURLRequest( const KURL & url, const KParts::URLArgs & )
{
	bool sourcechange = true;
	emit signalLinkClicked ( url.prettyURL(), sourcechange );
}

void KCHMViewWindow_TDEHTMLPart::slotLinkClicked( const TQString & newlink )
{
	bool notused;
	emit signalLinkClicked (newlink, notused);
}


void KCHMViewWindow_TDEHTMLPart::clipSelectAll()
{
	selectAll ();
}

void KCHMViewWindow_TDEHTMLPart::clipCopy()
{
	TQString text = selectedText();
	
	if ( !text.isEmpty() )
		TQApplication::clipboard()->setText( text );
}

void  KCHMViewWindow_TDEHTMLPart::onPopupMenu ( const TQString &url, const TQPoint & point )
{
	KTQPopupMenu * menu = getContextMenu( url, view() );
	menu->exec( point );
}

