/***************************************************************************
                          previewdialog.cpp  -  description
                             -------------------
    begin                : Die Dez 10 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "previewdialog.h"
#include "label.h"
#include "sqltables.h"
#include "labeleditor.h"
#include "measurements.h"

// TQt includes
#include <tqiodevice.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqpainter.h>
#include <tqscrollview.h>
#include <tqsqlcursor.h>

// KDE includes
#include <tdeabc/addresseedialog.h>
#include <tdeapplication.h>
#include <kcombobox.h>
#include <tdeconfig.h>
#include <kiconloader.h>
#include <klineedit.h>
#include <tdelocale.h>
#include <knuminput.h>
#include <kpushbutton.h>

int PreviewDialog::customer_index = 0;
int PreviewDialog::m_index = 1;
TQString PreviewDialog::group = "";
TQString PreviewDialog::article = "";
        
PreviewDialog::PreviewDialog( TQIODevice* device, Definition* d, TQString filename, TQWidget *parent, const char *name )
    : TQDialog( parent, name, true, WDestructiveClose )
{
    file = device;
    def = d;
    m_filename = filename;
    
    TQSpacerItem* spacer = new TQSpacerItem( 20, 20, TQSizePolicy::Minimum, TQSizePolicy::Expanding );

    TQHBoxLayout* Layout = new TQHBoxLayout( this, 6, 6 );
    TQVBoxLayout* vbox = new TQVBoxLayout( 0, 6, 6 );
    TQVBoxLayout* buttons = new TQVBoxLayout( 0, 6, 6 );
    TQGridLayout* grid = new TQGridLayout( 0 );

    customerName = new KComboBox( false, this );
    customerId = new KComboBox( false, this );

    groupName = new KLineEdit( group, this );
    articleId = new KLineEdit( article, this );
    if( SqlTables::isConnected() ) {
        TDECompletion* comp = articleId->completionObject();
        TQSqlQuery query( "select article_no from barcode_basic"  );
        TQStringList slist;
        while ( query.next() )
            slist.append( query.value(0).toString() );
        slist.sort();
        comp->setItems( slist );
    }

    spinIndex = new KIntNumInput( this );
    spinIndex->setRange( 1, 100000, 1, false );
    spinIndex->setValue( m_index );

    serialStart = new KLineEdit( this );

    serialInc = new KIntNumInput( this );
    serialInc->setRange( 1, 10000, 1, false );

    lineAddr = new KLineEdit( this );
    lineAddr->setReadOnly( true );
    
    buttonAddr = new KPushButton( i18n("Select &Address"), this );

    buttonUpdate = new KPushButton( i18n("&Update"), this );
    buttonClose = new KPushButton( i18n("&Close"), this );
    buttonClose->setIconSet( SmallIconSet("window-close") );
    
    grid->addWidget( new TQLabel( i18n("Customer Name and No.:"), this ), 0, 0 );
    grid->addWidget( customerName, 0, 1 );
    grid->addWidget( customerId, 0, 2 );
    grid->addWidget( new TQLabel( i18n("Article Number:"), this ), 1, 0 );
    grid->addMultiCellWidget( articleId, 1, 1, 1, 2 );
    grid->addWidget( new TQLabel( i18n("Group:"), this ), 2, 0 );
    grid->addMultiCellWidget( groupName, 2, 2, 1, 2 );
    grid->addWidget( new TQLabel( i18n("Index:"), this ), 3, 0 );
    grid->addMultiCellWidget( spinIndex, 3, 3, 1, 2 );
    grid->addWidget( new TQLabel( i18n("Serial start:"), this ), 4, 0 );
    grid->addMultiCellWidget( serialStart, 4, 4, 1, 2 );
    grid->addWidget( new TQLabel( i18n( "Serial increment:" ), this ), 5, 0 );
    grid->addMultiCellWidget( serialInc, 5, 5, 1, 2 );
    grid->addWidget( new TQLabel( i18n( "Addressbook entry:" ), this ), 6, 0 );
    grid->addWidget( lineAddr, 6, 1 );
    grid->addWidget( buttonAddr, 6, 2 );
    TQScrollView* sv = new TQScrollView( this );

    preview = new TQLabel( sv->viewport() );
    sv->addChild( preview );
    
    TQPixmap pix( (int)d->getMeasurements().width( TQT_TQPAINTDEVICE(this) ), (int)d->getMeasurements().height( TQT_TQPAINTDEVICE(this) ) );
    pix.fill( TQt::white );
    preview->setPixmap( pix );
        
    vbox->addLayout( grid );
    vbox->addWidget( sv );

    buttons->addWidget( buttonUpdate );
    buttons->addWidget( buttonClose );
    buttons->addItem( spacer );
    
    Layout->addLayout( vbox );
    Layout->addLayout( buttons );

    connect( buttonClose, TQT_SIGNAL( clicked() ), this, TQT_SLOT( reject() ) );
    connect( buttonAddr, TQT_SIGNAL( clicked() ), this, TQT_SLOT( selectAddress() ) );
    // TODO:
    // remove this ugly hack! The finished label is only shown when I call
    // updateChanges() twice. I have no idea why!
    connect( buttonUpdate, TQT_SIGNAL( clicked() ), this, TQT_SLOT( updatechanges() ) );
    connect( buttonUpdate, TQT_SIGNAL( clicked() ), this, TQT_SLOT( updatechanges() ) );
    // end ugly hack
    
    connect( customerName, TQT_SIGNAL( activated(int) ), this, TQT_SLOT( customerNameChanged(int) ) );
    connect( customerId, TQT_SIGNAL( activated(int) ), this, TQT_SLOT( customerIdChanged(int) ) );

    TDEConfig* config = kapp->config();
    config->setGroup( "PreviewDialog" );
    resize( config->readNumEntry( "width", width() ), config->readNumEntry( "height", height() ) );
    
    if( SqlTables::isConnected() )
        setupSql();
}

PreviewDialog::~PreviewDialog()
{
    TDEConfig* config = kapp->config();
    config->setGroup( "PreviewDialog" );
    config->writeEntry( "width", width() );
    config->writeEntry( "height", height() );
    config->sync();
}

void PreviewDialog::setupSql()
{
    TQSqlCursor cur( "customer" );
    cur.select();
    customerId->clear();
    customerName->clear();
    while ( cur.next() ) {
        customerId->insertItem( cur.value("customer_no" ).toString() );
        customerName->insertItem( cur.value("customer_name" ).toString() );
    }

    customerId->setCurrentItem( customer_index );
    customerName->setCurrentItem( customer_index );
}

void PreviewDialog::selectAddress()
{
    m_address = TDEABC::AddresseeDialog::getAddressee( this );
    if( !m_address.isEmpty() ) 
        lineAddr->setText( m_address.realName() );
    else
        lineAddr->setText( TQString() );
}

void PreviewDialog::updatechanges()
{
    TQPixmap pix( (int)def->getMeasurements().width( TQT_TQPAINTDEVICE(this) ), (int)def->getMeasurements().height( TQT_TQPAINTDEVICE(this) ) );
    pix.fill( TQt::white );

    TQPainter painter( &pix );
    
    Label* l = new Label( def, file, m_filename, TQT_TQPAINTDEVICE(TDEApplication::desktop()),
        customerId->currentText(), articleId->text(), groupName->text() );
    l->setIndex( spinIndex->value() - 1 );
    l->setSerial( serialStart->text(), serialInc->value() );
    l->setAddressee( &m_address );
    l->draw( &painter, 0, 0 );

    preview->setPixmap( pix );

    delete l;
        
    // keep settings for next the
    // next time the dialog is shown
    group = groupName->text();
    article = articleId->text();
    customer_index = customerId->currentItem();
    m_index = spinIndex->value();
}

void PreviewDialog::customerIdChanged( int index )
{
    customerName->setCurrentItem( index );
}

void PreviewDialog::customerNameChanged( int index )
{
    customerId->setCurrentItem( index );
}

#include "previewdialog.moc"
