/***************************************************************************
                         dstextedit.cpp  -  description
                             -------------------
    begin                : Sam Jun 04 2005
    copyright            : (C) 2005 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dstextedit.h"
#include "dstextedit.moc"
#include <tqregexp.h>

DSTextEdit::DSTextEdit( TQWidget* parent, const char* name )
    : KTextEdit( parent, name )
{
    connect( this, TQT_SIGNAL( textChanged() ), this, TQT_SLOT( fixParagraphs() ) );
}

void DSTextEdit::fixParagraphs()
{
    struct { 
        TQFont  font;
        TQColor color;
        int    alignment;
    } tFormattings;

    TQString t;
    int pos = 0;
    int count = 0;
    int i;
    int para, index;                          // needed to save the cursor position
    int paraFrom, indexFrom, paraTo, indexTo; // needed to save the selection
    TQValueList<int> chars;
    TQRegExp reg("<p[^>]*>");

    for( i = 0; i < paragraphs(); i++ )
        chars.append( paragraphLength( i ) );

    // disconnect us first as we change the text here
    disconnect( this, TQT_SIGNAL( textChanged() ), this, TQT_SLOT( fixParagraphs() ) );

    getCursorPosition( &para, &index );
    getSelection( &paraFrom, &indexFrom, &paraTo, &indexTo );

    if( !para && !index ) 
        setCursorPosition( 0, index+1 );

    t                      = this->text();
    tFormattings.font      = this->currentFont();
    tFormattings.color     = this->color();
    tFormattings.alignment = this->alignment();

    while( pos != -1 ) 
    {
        pos = reg.search( t, pos );
        if( pos != -1 )
        {
            if( count && count == para )
            {
                for( i = 0; i < count; i++ )
                    index += chars[i];
                ++index; // count the new <br> that is inserted later
            }

            ++count;

            if( count > 1 ) //&& pos != -1 ) 
                t = t.remove( pos, reg.matchedLength() );
            else
                pos += reg.matchedLength();
        }
    }

    pos = t.length();
    count = 0;

    while( pos != -1 ) 
    {
        pos = t.findRev( "</p>", pos );
        if( pos != -1 )
        {
            ++count;

            if( count > 1 ) //&& pos != -1 ) 
                t = t.replace( pos, 4, "<br />" );
            else
                pos -= 4;
        }
    }

    this->setText( t );
    this->setCursorPosition( 0, index );
    this->setCurrentFont( tFormattings.font );
    this->setColor( tFormattings.color );
    this->setAlignment( tFormattings.alignment );
    this->setSelection( paraFrom, indexFrom, paraTo, indexTo );


    connect( this, TQT_SIGNAL( textChanged() ), this, TQT_SLOT( fixParagraphs() ) );
}

/*
void DSTextEdit::moveCursor( CursorAction action, bool select )
{
    do { 
        TextEditBase::moveCursor( action, select );
    } while( cursorIsInToken() );
}

bool DSTextEdit::cursorIsInToken() 
{
    int para, index;
    int firstopen, firstclose;
    TQString data;

    getCursorPosition( &para, &index );

    data = text( para );

    tqDebug("data=" + data );
    --index;
    firstopen = data.findRev( "[", index );
    firstclose = data.findRev( "]", index );
    ++index;

    if( firstopen != -1 && firstopen > firstclose )
    {
        firstopen = data.find( "[", index );
        firstclose = data.find( "]", index );
        if( ( firstclose != -1 && firstopen != -1 && firstclose < firstopen ) ||
            ( firstclose != -1 && firstopen == -1 ) )
            return true;
    }

    return false;
}

*/
