/***************************************************************************
 *
 * knetworkmanager-authenticationdialog.h - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_VPNAUTHENTICATIONDIALOG_H
#define KNETWORKMANAGER_VPNAUTHENTICATIONDIALOG_H

#include <tqdir.h>
#include <tqobject.h>
#include <kprocess.h>
#include <tdeconfig.h>

#include "knetworkmanager.h"
#include "vpnauthentication.h"
#include "knetworkmanager-vpnplugin.h"
#include "knetworkmanager-vpnmanager.h"

class KNetworkManager;
class ManageConnectionsDialog;
class VPNService;

namespace ConnectionSettings
{
	class VPNConnection;
}

class VPNAuthenticationDialog : public AuthenticationDialog
{
	Q_OBJECT
  
	public:
		VPNAuthenticationDialog(ConnectionSettings::VPNConnection* conn = NULL, TQWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0);
		~VPNAuthenticationDialog();
		void setPasswords(TQString name, TQString value);
		virtual bool close(bool);

	protected slots:
		void ok();
		void cancel();

	private:
		VPNAuthenticationWidget* _vpnAuthWidget;
		ConnectionSettings::VPNConnection* _conn;

	signals:
		void done(bool, TQStringList &, bool, bool);
};

#endif /* KNETWORKMANAGER_VPNAUTHENTICATIONDIALOG_H */
