/***************************************************************************
 *
 * knetworkmanager-menuitem.cpp - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006, 2008 Novell, Inc.
 *
 * Author: Timo Hoenig        <thoenig@suse.de>, <thoenig@nouse.net>
 *         Will Stephenson    <wstephenson@suse.de>, <wstephenson@kde.org>
 *         Valentine Sinitsyn <e_val@inbox.ru>
 *         Helmut Schaa       <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#include "knetworkmanager-menuitem.h"

#include <tqevent.h>
#include <tqguardedptr.h>
#include <tqvbox.h>
#include <tqlayout.h>
#include <tqpushbutton.h>
#include <tqpixmap.h>
#include <tqpixmapcache.h>
#include <tqpainter.h>
#include <tqstyle.h>
#include <dcopclient.h>
#include <kdebug.h>
#include <kdialogbase.h>
#include <knotifyclient.h>
#include <knotifydialog.h>
#include <tdelocale.h>
#include <kstdguiitem.h>
#include <khelpmenu.h>
#include <kprocess.h>
#include <kiconloader.h>
#include <tdeconfig.h>
#include <tdemessagebox.h>

#include <tqdbusobjectpath.h>
#include <tqdbuserror.h>

#include "knetworkmanager-connection.h"
#include "knetworkmanager-device.h"
#include "knetworkmanager-nm_proxy.h"
#include "knetworkmanager-vpn_plugin.h"

#if !defined(NM_CHECK_VERSION)
#define NM_CHECK_VERSION(x,y,z) 0
#endif

TQString currentVPNDevice;
TQT_DBusObjectPath vpn_attempt_this_conn;

using namespace ConnectionSettings;

class NetworkMenuItemPrivate
{
	public:
		NetworkMenuItemPrivate(Device* device, Connection* connection)
		: dev(device), conn(connection)
		{

		}
		~NetworkMenuItemPrivate() {}
	
		TQGuardedPtr<Device> dev;
		TQGuardedPtr<Connection> conn;
};

void NetworkMenuItem::slotActivate()
{
	int id;
	TQT_DBusError err;
	kdDebug() << "NetworkMenuItem::slotActivate()" << endl;
	NMProxy* nm = NMProxy::getInstance();

	if (d->dev && d->conn)
	{
		NMProxy* nm = NMProxy::getInstance();
		if (nm)
		{
			kdDebug() << "Activate Connection " << d->conn->getObjectPath().ascii() << " on Device " << d->dev->getObjectPath().ascii() << endl;
			printf("Activate Connection %s on Device %s\n", d->conn->getObjectPath().ascii(), d->dev->getObjectPath().ascii());

#if NM_CHECK_VERSION(0,8,992)
			if (nm->ActivateConnectionAsync(id, "org.freedesktop.NetworkManagerUserSettings", d->conn->getObjectPath(), TQT_DBusObjectPath(QCString(d->dev->getObjectPath())), d->conn->getObjectPath(), err))
#else
			if (nm->ActivateConnectionAsync(id, NM_DBUS_SERVICE_USER_SETTINGS, d->conn->getObjectPath(), TQT_DBusObjectPath(TQCString(d->dev->getObjectPath())), d->conn->getObjectPath(), err))
#endif
			{

			}
			else
				kdDebug() << "ActivateDevice failed" << endl;
		}
	}
	else if (d->conn)
	{
		// no device given, just take the default device
		printf("Activate Connection %s on default device\n", d->conn->getObjectPath().ascii());
		TQT_DBusObjectPath act_conn = nm->getDefaultActiveConnection();
		TQT_DBusObjectPath device   = nm->getDeviceForActiveConnection(act_conn);
		vpn_attempt_this_conn = d->conn->getObjectPath();
#if NM_CHECK_VERSION(0,8,992)
		nm->ActivateConnectionAsync(id, "org.freedesktop.NetworkManagerUserSettings", d->conn->getObjectPath(), device, act_conn, err);
#else
		nm->ActivateConnectionAsync(id,NM_DBUS_SERVICE_USER_SETTINGS, d->conn->getObjectPath(), device, act_conn, err);
#endif
	}
	else
		kdDebug() << "Device or Connection invalid" << endl;
}

NetworkMenuItem::NetworkMenuItem (Device* dev, Connection* conn, TQObject* parent, const char* name)
		       : TQObject(parent, name)
{
	d = new NetworkMenuItemPrivate(dev, conn);
}

NetworkMenuItem::~NetworkMenuItem ()
{
	delete d;
}



#include "knetworkmanager-menuitem.moc"
