/***************************************************************************
 *
 * knetworkmanager-nm_proxy.h - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_NMPROXY_H
#define KNETWORKMANAGER_NMPROXY_H

#include "dbus/networkmanagerproxy.h"

namespace ConnectionSettings
{
	class Connection;
}
class Device;
class NMProxyPrivate;

class NMProxy : public DBus::NetworkManagerProxy
{
	Q_OBJECT
  
	public:
		static NMProxy* getInstance();

		Device* getDefaultDevice();
		TQT_DBusObjectPath getDeviceForActiveConnection(TQT_DBusObjectPath act_conn);
		TQT_DBusObjectPath getDefaultActiveConnection();
		ConnectionSettings::Connection* getActiveConnection(const Device* dev);
		void deactivateDevice(const Device* dev);
		void deactivateConnection(const ConnectionSettings::Connection* conn, const Device* dev);
		void deactivateConnectionPath(TQT_DBusObjectPath obj_path);
		TQValueList<TQPair<ConnectionSettings::Connection*, Device*> > getActiveConnectionsMap();
		bool isNMRunning();

	protected:
	  NMProxy ();
	  ~NMProxy ();

	private:
	  NMProxyPrivate * d;
};

#endif /* KNETWORKMANAGER_NMPROXY_H */
