/***************************************************************************
 *
 * knetworkmanager-devicestore_dbus.h - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_CONNECTION_SETTINGS_DIALOG_H
#define KNETWORKMANAGER_CONNECTION_SETTINGS_DIALOG_H

// qt headers
#include <tqlistview.h>
#include <tqvaluelist.h>

// qt autogenerated headers
#include "connection_settings.h"

// knm headers
#include "knetworkmanager-connection_setting.h"

class TQWidget;
class Device;

namespace ConnectionSettings
{
	class WidgetInterface;
	class ConnectionSetting;
}

class ConnectionSettingsDialogImpl : public ConnectionSettingsDialog
{
	Q_OBJECT
  
	public:
		ConnectionSettingsDialogImpl(ConnectionSettings::Connection* conn, bool new_conn, ConnectionSettings::ConnectionSetting* setting = NULL, TQWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0);
		~ConnectionSettingsDialogImpl();

	public slots:
		void slotConnect();
		void slotCancel();
		void slotSave();
		void slotNext();
		void slotBack();
		void slotEnableButtons();

	signals:
		void connectionSaved();

	private:
		void updateDialogForDeviceType();
		void createWidgetsForConnection(ConnectionSettings::Connection*, bool new_conn, ConnectionSettings::ConnectionSetting* setting);
		void activateWidget(ConnectionSettings::WidgetInterface* widget);
		void deactivateWidget(ConnectionSettings::WidgetInterface* widget);
		int getDeviceTypeFromConnection(ConnectionSettings::Connection* conn);

		// TODO: To be moved to a factory class
		TQValueList<ConnectionSettings::WidgetInterface*> createWidgetsForWired(ConnectionSettings::Connection* conn, bool new_conn, ConnectionSettings::ConnectionSetting* setting);
		TQValueList<ConnectionSettings::WidgetInterface*> createWidgetsForWireless(ConnectionSettings::Connection* conn, bool new_conn, ConnectionSettings::ConnectionSetting* setting);
		TQValueList<ConnectionSettings::WidgetInterface*> createWidgetsForWirelessKnownESSID(ConnectionSettings::Connection* conn, bool new_conn, ConnectionSettings::ConnectionSetting* setting, const TQByteArray& essid);
		TQValueList<ConnectionSettings::WidgetInterface*> createWidgetsForVPN(ConnectionSettings::Connection* conn, bool new_conn, ConnectionSettings::ConnectionSetting* setting);
		TQValueList<ConnectionSettings::WidgetInterface*> createWidgetsForCDMA(ConnectionSettings::Connection* conn, bool new_conn, ConnectionSettings::ConnectionSetting* setting);
		TQValueList<ConnectionSettings::WidgetInterface*> createWidgetsForGSM(ConnectionSettings::Connection* conn, bool new_conn, ConnectionSettings::ConnectionSetting* setting);

		ConnectionSettings::Connection* _conn;
		ConnectionSettings::ConnectionSetting* _setting;
		TQValueList<int>                 _widgetIds;
		bool _new_conn;
};

#endif /* KNETWORKMANAGER_CONNECTION_SETTINGS_DIALOG_H*/
