/* This file is part of the KDE project
   Copyright (C) 2001,2002,2003,2004 Laurent Montel <montel@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include "kchartHeaderFooterConfigPage.h"
#include "kchartHeaderFooterConfigPage.moc"

#include <tdeapplication.h>
#include <kdialog.h>
#include <tdelocale.h>
#include <tqlayout.h>
#include <tqlabel.h>
#include <tqlineedit.h>
#include <tqbuttongroup.h>
#include <tqwhatsthis.h>
#include <tdefontdialog.h>

#include "kchart_params.h"

namespace KChart
{

KChartHeaderFooterConfigPage::KChartHeaderFooterConfigPage( KChartParams* params,
                                                      TQWidget* parent ) :
    TQWidget( parent ),_params( params )
{
    TQGridLayout* layout = new TQGridLayout( this, 4, 3 );
    layout->setSpacing( KDialog::spacingHint() );
    layout->setMargin( KDialog::marginHint() );

    TQLabel *lab=new TQLabel(i18n("Title:"), this);
    TQWhatsThis::add(lab, i18n("Write here the title of your chart if you want one. The title will be centered on top above your chart."));
    layout->addWidget(lab,0,0);

    titleEdit=new TQLineEdit(this);
    TQWhatsThis::add(titleEdit, i18n("Write here the title of your chart if you want one. The title will be centered on top above your chart."));
    layout->addWidget(titleEdit,0,1);

    titleColorButton=new KColorButton(this);
    TQWhatsThis::add(titleColorButton, i18n("Click on this button to choose the color for the title font."));
    layout->addWidget(titleColorButton,0,2);

    titleFontButton=new TQPushButton(i18n("Font..."),this);
    TQWhatsThis::add(titleFontButton, i18n("Click on this button to choose the font family, style and size for the title."));
    layout->addWidget(titleFontButton,0,3);
    connect( titleFontButton, TQT_SIGNAL(clicked()), this, TQT_SLOT(changeTitleFont()));

    lab=new TQLabel(i18n("Subtitle:"),this);
    TQWhatsThis::add(lab, i18n("Write here the subtitle of your chart if you want one. The subtitle will be centered on top just below the title."));
    layout->addWidget(lab,1,0);

    subtitleEdit=new TQLineEdit(this);
    TQWhatsThis::add(subtitleEdit, i18n("Write here the subtitle of your chart if you want one. The subtitle will be centered on top just below the title."));
    layout->addWidget(subtitleEdit,1,1);

    subtitleColorButton=new KColorButton(this);
    TQWhatsThis::add(subtitleColorButton, i18n("Click on this button to choose the color for the subtitle font."));
    layout->addWidget(subtitleColorButton,1,2);

    subtitleFontButton=new TQPushButton(i18n("Font..."),this);
    TQWhatsThis::add(subtitleFontButton, i18n("Click on this button to choose the font family, style and size for the subtitle."));
    layout->addWidget(subtitleFontButton,1,3);
    connect( subtitleFontButton, TQT_SIGNAL(clicked()), this, TQT_SLOT(changeSubtitleFont()));

    lab=new TQLabel(i18n("Footer:"),this);
    TQWhatsThis::add(lab, i18n("Write here the footer of your chart if you want one. The footer will be centered at the bottom just below your chart."));
    layout->addWidget(lab,2,0);

    footerEdit=new TQLineEdit(this);
    TQWhatsThis::add(footerEdit, i18n("Write here the subtitle of your chart if you want one. The subtitle will be centered on top just below the title."));
    layout->addWidget(footerEdit,2,1);

    footerColorButton=new KColorButton(this);
    TQWhatsThis::add(footerColorButton, i18n("Click on this button to choose the color for the footer font."));
    layout->addWidget(footerColorButton,2,2);

    footerFontButton=new TQPushButton(i18n("Font..."),this);
    TQWhatsThis::add(footerFontButton, i18n("Click on this button to choose the font family, style and size for the footer."));
    connect( footerFontButton, TQT_SIGNAL(clicked()), this, TQT_SLOT(changeFooterFont()));
    layout->addWidget(footerFontButton,2,3);

    layout->addItem( new TQSpacerItem( 5, 5, TQSizePolicy::Minimum, TQSizePolicy::Expanding ), 3, 0 );

    layout->activate();
}

void KChartHeaderFooterConfigPage::init()
{
    titleColorButton->setColor(_params->headerFooterColor( KDChartParams::HdFtPosHeader ) );
    subtitleColorButton->setColor(_params->headerFooterColor( KDChartParams::HdFtPosHeader2 ));
    footerColorButton->setColor(_params->headerFooterColor( KDChartParams::HdFtPosFooter ) );
    titleEdit->setText(_params->header1Text());
    subtitleEdit->setText(_params->header2Text());
    footerEdit->setText(_params->footerText());


    titleFont = _params->header1Font();
    titleFontIsRelative = _params->headerFooterFontUseRelSize(KDChartParams::HdFtPosHeader)
                          ? TQButton::On
                          : TQButton::Off;
    if( TQButton::On == titleFontIsRelative )
        titleFont.setPointSize( _params->headerFooterFontRelSize(KDChartParams::HdFtPosHeader) );

    subtitleFont = _params->header2Font();
    subtitleFontIsRelative = _params->headerFooterFontUseRelSize(KDChartParams::HdFtPosHeader2)
                          ? TQButton::On
                          : TQButton::Off;
    if( TQButton::On == subtitleFontIsRelative )
        subtitleFont.setPointSize( _params->headerFooterFontRelSize(KDChartParams::HdFtPosHeader2) );

    footerFont = _params->footerFont();
    footerFontIsRelative = _params->headerFooterFontUseRelSize(KDChartParams::HdFtPosFooter)
                          ? TQButton::On
                          : TQButton::Off;
    if( TQButton::On == footerFontIsRelative )
        footerFont.setPointSize( _params->headerFooterFontRelSize(KDChartParams::HdFtPosFooter) );
}


void KChartHeaderFooterConfigPage::apply()
{
    _params->setHeaderFooterColor( KDChartParams::HdFtPosHeader,titleColorButton->color() );
    _params->setHeaderFooterColor( KDChartParams::HdFtPosHeader2,subtitleColorButton->color() );
    _params->setHeaderFooterColor( KDChartParams::HdFtPosFooter, footerColorButton->color() );


    _params->setHeader1Text(titleEdit->text());
    _params->setHeader2Text(subtitleEdit->text());
    _params->setFooterText(footerEdit->text());


    _params->setHeaderFooterFont( KDChartParams::HdFtPosHeader, titleFont,
                                  titleFontIsRelative,
                                  titleFont.pointSize() );
    _params->setHeaderFooterFont( KDChartParams::HdFtPosHeader2, subtitleFont,
                                  subtitleFontIsRelative,
                                  subtitleFont.pointSize() );
    _params->setHeaderFooterFont( KDChartParams::HdFtPosFooter, footerFont,
                                  footerFontIsRelative,
                                  footerFont.pointSize() );
}

void KChartHeaderFooterConfigPage::changeTitleFont()
{
    TQButton::ToggleState state = titleFontIsRelative;
    if (    TDEFontDialog::getFont( titleFont,false,this, true,&state ) != TQDialog::Rejected
            && TQButton::NoChange != state )
        titleFontIsRelative = state;
}

void KChartHeaderFooterConfigPage::changeSubtitleFont()
{
    TQButton::ToggleState state = subtitleFontIsRelative;
    if (    TDEFontDialog::getFont( subtitleFont,false,this, true,&state ) != TQDialog::Rejected
            && TQButton::NoChange != state )
        subtitleFontIsRelative = state;
}

void KChartHeaderFooterConfigPage::changeFooterFont()
{
    TQButton::ToggleState state = footerFontIsRelative;
    if (    TDEFontDialog::getFont( footerFont,false,this, true,&state ) != TQDialog::Rejected
            && TQButton::NoChange != state )
        footerFontIsRelative = state;
}

}  //KChart namespace
