
#include "soundkonverterapp.h"
#include "soundkonverter.h"

#include <tqstringlist.h>
#include <tqfile.h>
#include <tqmovie.h>

#include <tdeglobal.h>
#include <tdestartupinfo.h>
#include <tdecmdlineargs.h>
#include <dcopclient.h>
#include <ksystemtray.h>
#include <kstandarddirs.h>

soundKonverterApp::soundKonverterApp()
    : KUniqueApplication()
{}

soundKonverterApp::~soundKonverterApp()
{}

int soundKonverterApp::newInstance()
{
    // register ourselves as a dcop client
    if( !dcopClient()->isRegistered() )
        dcopClient()->registerAs( name(), false );

    // see if we are starting with session management
    if( restoringSession() )
    {
        RESTORE( soundKonverter );
    }
    else
    {
        // no session.. just start up normally
        TDECmdLineArgs *args = TDECmdLineArgs::parsedArgs();

        if( !mainWidget() )
        {
            soundKonverter *widget = new soundKonverter();
            setMainWidget(widget);
            //widget->show();
        }
        else
            TDEStartupInfo::setNewStartupId( mainWidget(), kapp->startupId());

        soundKonverter *widget = ::tqqt_cast<soundKonverter*>( mainWidget() );

        widget->increaseInstances();

        TQCString notify = args->getOption( "command" );
        if( !notify.isNull() ) {
            widget->setNotify( notify );
        }

        TQCString profile = args->getOption( "profile" );
        if( !profile.isNull() ) {
            widget->profile = profile;
        }

        TQCString format = args->getOption( "format" );
        if( !format.isNull() ) {
            widget->format = format;
        }

        TQCString directory = args->getOption( "output" );
        if( !directory.isNull() ) {
            widget->directory = directory;
        }

        TQCString device = args->getOption( "rip" );
        if( !device.isNull() ) {
            if( !args->isSet( "invisible" ) ) {
                widget->visible = true;
                widget->show();
                widget->systemTray->hide();
                widget->systemTray->setPixmap( 0 );
            }
            widget->device = device;
            widget->showCdDialog( false );
        }

        widget->autoclose = args->isSet( "autoclose" );

        if( args->isSet( "invisible" ) ) {
            widget->visible = false;
            widget->autoclose = true;
            widget->hide();
            widget->systemTray->show();
            TDEStandardDirs* stdDirs = new TDEStandardDirs();
            widget->systemTray->setMovie( TQMovie(stdDirs->findResource("data","soundkonverter/pics/systray.mng")) );
            delete stdDirs;
        }
        else {
            widget->visible = true;
            widget->show();
            widget->systemTray->hide();
            widget->systemTray->setPixmap( 0 );
        }

        // add the files to the file lists depending on the used switch
        if( args->isSet( "replaygain" ) ) {
            TQStringList replayGainFiles;
            for( int i = 0; i < args->count(); i++ ) {
                replayGainFiles.append(KURL::encode_string(args->arg(i)));
            }
            if(!replayGainFiles.isEmpty())
                widget->openArgReplayGainFiles(replayGainFiles);
        }
//         else if( args->isSet( "repair" ) ) {
//             TQStringList repairFiles;
//             for( int i = 0; i < args->count(); i++ ) {
//                 repairFiles.append(TQFile::decodeName(args->arg(i)));
//             }
//             if(!repairFiles.isEmpty())
//                 widget->openArgRepairFiles(repairFiles);
//         }
        else {
            TQStringList files;
            for( int i = 0; i < args->count(); i++ )
            {
                files.append(KURL::encode_string(args->arg(i)));
            }
            if(!files.isEmpty())
                widget->openArgFiles(files);
        }

        args->clear();
    }
    return 0;
}

