
#include "optionssimple.h"
#include "config.h"
#include "convertpluginloader.h"
#include "optionsdetailed.h"

#include <tqlayout.h>
#include <tqlabel.h>
#include <tqstring.h>
#include <tqtooltip.h>

#include <tdelocale.h>
#include <kcombobox.h>
#include <kiconloader.h>
#include <tdemessagebox.h>
#include <tdetoolbarbutton.h>
//#include <kdebug.h>
#include <kpushbutton.h>


// FIXME when changing the output directory, check if the profile is a user defined and set it to 'User defined', if it is

// TODO hide lossless/hybrid/etc. when not available
OptionsSimple::OptionsSimple( Config* _config, OptionsDetailed* _optionsDetailed, const TQString &text, TQWidget *parent, const char *name )
    : TQWidget( parent, name )
{
    config = _config;
    optionsDetailed = _optionsDetailed;

    // create an icon loader object for loading icons
    TDEIconLoader* iconLoader = new TDEIconLoader();

    TQGridLayout *grid = new TQGridLayout( this, 3, 1, 6, 3 );

    TQHBoxLayout *topBox = new TQHBoxLayout( );
    grid->addLayout( topBox, 0, 0 );

    TQLabel *lQuality = new TQLabel( i18n("Quality")+":", this, "lQuality" );
    topBox->addWidget( lQuality, 0, TQt::AlignVCenter );
    cProfile = new KComboBox( this, "cProfile" );
    sProfile += i18n("Very low");
    sProfile += i18n("Low");
    sProfile += i18n("Medium");
    sProfile += i18n("High");
    sProfile += i18n("Very high");
    sProfile += i18n("Lossless");
    sProfile += i18n("Hybrid");
    sProfile += config->getAllProfiles();
    sProfile.remove( i18n("Last used") );
    sProfile.remove( "Last used" );
    sProfile += i18n("User defined");
    cProfile->insertStringList( sProfile );
    topBox->addWidget( cProfile, 0, TQt::AlignVCenter );
    connect( cProfile, TQT_SIGNAL(activated(int)),
               this, TQT_SLOT(profileChanged())
             );
    connect( cProfile, TQT_SIGNAL(activated(int)),
               this, TQT_SLOT(somethingChanged())
             );
    topBox->addSpacing( 3 );
    //pProfileRemove = new TDEToolBarButton( "edit-delete", 1002, this, "pProfileRemove" );
    pProfileRemove = new KPushButton( iconLoader->loadIcon("edit-delete",TDEIcon::Small), i18n("Remove"), this, "pProfileRemove" );
    pProfileRemove->hide();
    TQToolTip::add( pProfileRemove, i18n("Remove the selected profile") );
    topBox->addWidget( pProfileRemove, 0, TQt::AlignVCenter );
    connect( pProfileRemove, TQT_SIGNAL(clicked()),
               this, TQT_SLOT(profileRemove())
             );
    //pProfileInfo = new TDEToolBarButton( "messagebox_info", 1110, this, "pProfileInfo" );
    pProfileInfo = new KPushButton( iconLoader->loadIcon("messagebox_info",TDEIcon::Small), i18n("Info"), this, "pProfileInfo" );
    TQToolTip::add( pProfileInfo, i18n("Information about the selected profile") );
    topBox->addWidget( pProfileInfo, 0, TQt::AlignVCenter );
    connect( pProfileInfo, TQT_SIGNAL(clicked()),
               this, TQT_SLOT(profileInfo())
             );
    topBox->addSpacing( 18 );

    TQLabel *lFormat = new TQLabel( i18n("Output format")+":", this, "lFormat" );
    topBox->addWidget( lFormat, 0, TQt::AlignVCenter );
    cFormat = new KComboBox( this, "cFormat" );
    topBox->addWidget( cFormat, 0, TQt::AlignVCenter );
    connect( cFormat, TQT_SIGNAL(activated(int)),
               this, TQT_SLOT(formatChanged())
             );
    connect( cFormat, TQT_SIGNAL(activated(int)),
               this, TQT_SLOT(somethingChanged())
             );
    topBox->addSpacing( 3 );
    //pFormatInfo = new TDEToolBarButton( "messagebox_info", 1111, this, "pFormatInfo" );
    pFormatInfo = new KPushButton( iconLoader->loadIcon("messagebox_info",TDEIcon::Small), i18n("Info"), this, "pFormatInfo" );
    TQToolTip::add( pFormatInfo, i18n("Information about the selected file format") );
    topBox->addWidget( pFormatInfo, 0, TQt::AlignVCenter );
    connect( pFormatInfo, TQT_SIGNAL(clicked()),
               this, TQT_SLOT(formatInfo())
             );
    topBox->addStretch( );

    TQHBoxLayout *middleBox = new TQHBoxLayout( );
    grid->addLayout( middleBox, 1, 0 );

    outputDirectory = new OutputDirectory( config, this, "outputDirectory" );
    middleBox->addWidget( outputDirectory, 0, TQt::AlignVCenter );
    connect( outputDirectory, TQT_SIGNAL(modeChanged(OutputDirectory::Mode)),
               this, TQT_SLOT(outputDirectoryModeChanged(OutputDirectory::Mode))
             );
    connect( outputDirectory, TQT_SIGNAL(directoryChanged(const TQString&)),
               this, TQT_SLOT(outputDirectoryPathChanged(const TQString&))
             );
    connect( outputDirectory, TQT_SIGNAL(modeChanged(OutputDirectory::Mode)),
               this, TQT_SLOT(somethingChanged())
             );
    connect( outputDirectory, TQT_SIGNAL(directoryChanged(const TQString&)),
               this, TQT_SLOT(somethingChanged())
             );

    TQHBoxLayout *bottomBox = new TQHBoxLayout( );
    grid->addLayout( bottomBox, 2, 0 );

    TQLabel *lInfo = new TQLabel( text, this, "lInfo" );
    lInfo->setFixedHeight( cProfile->height() );
    bottomBox->addWidget( lInfo, 0, TQt::AlignVCenter | TQt::AlignLeft );

    // delete the icon loader object
    delete iconLoader;
}


OptionsSimple::~OptionsSimple()
{
}

int OptionsSimple::profileIndex( const TQString &string )
{
    TQString profile = string;
    if( profile == "Very low" ) profile = i18n("Very low");
    else if( profile == "Low" ) profile = i18n("Low");
    else if( profile == "Medium" ) profile = i18n("Medium");
    else if( profile == "High" ) profile = i18n("High");
    else if( profile == "Very high" ) profile = i18n("Very high");
    else if( profile == "Lossless" ) profile = i18n("Lossless");
    else if( profile == "Hybrid" ) profile = i18n("Hybrid");
    else if( profile == "User defined" ) profile = i18n("User defined");
    return sProfile.findIndex( profile );
}

int OptionsSimple::formatIndex( const TQString &string )
{
    return sFormat.findIndex( string );
}

void OptionsSimple::profileInfo()
{
    TQString sProfileString = cProfile->currentText();

    if( sProfileString == i18n("Very low") ) {
        KMessageBox::information( this,
        i18n("This produces sound files of a very low quality.\nThat can be useful, if you have a mobile device, where your memory cell is limited. It is not recommended to save your music in this quality without a copy with higher quality.\nIt can also be used to save audio files with voices."),
        i18n("Profile")+": "+sProfileString );
    }
    else if( sProfileString == i18n("Low") ) {
        KMessageBox::information( this,
        i18n("This produces sound files of a low quality.\nThat can be useful if you habe a mobile device where your memory cell is limited. It is not recommended to save your music in this quality without a copy with higher quality."),
        i18n("Profile")+": "+sProfileString );
    }
    else if( sProfileString == i18n("Medium") ) {
        KMessageBox::information( this,
        i18n("This produces sound files of a medium quality.\nIf your disc space is limited, you can use this to save your music."),
        i18n("Profile")+": "+sProfileString );
    }
    else if( sProfileString == i18n("High") ) {
        KMessageBox::information( this,
        i18n("This produces sound files of a high quality.\nIf you have enough disc space available, you can use this to save your music."),
        i18n("Profile")+": "+sProfileString );
    }
    else if( sProfileString == i18n("Very high") ) {
        KMessageBox::information( this,
        i18n("This produces sound files of a very high quality.\nYou should only use this, if you are a quality freak and have enough disc space available."),
        i18n("Profile")+": "+sProfileString );
    }
    else if( sProfileString == i18n("Lossless") ) {
        KMessageBox::information( this,
        i18n("This produces files, that have exact the same quality as the input files.\nThis files are very big and definitely only for quality freaks."),
        i18n("Profile")+": "+sProfileString );
    }
    else if( sProfileString == i18n("Hybrid") ) {
        KMessageBox::information( this,
        i18n("This produces two files. One lossy compressed playable file and one correction file.\nBoth files together result in a file that is equivalent to the input file."),
        i18n("Profile")+": "+sProfileString );
    }
    else if( sProfileString == i18n("User defined") ) {
        KMessageBox::information( this,
        i18n("You can define your own profile in the \"detailed\" tab."),
        i18n("Profile")+": "+sProfileString );
    }
//     else { // the info button is hidden when showing user defined profiles
//         KMessageBox::error( this,
//         i18n("This is a user defined profile."),
//         i18n("Profile")+": "+sProfileString );
//     }
}

void OptionsSimple::profileRemove()
{
    int ret = KMessageBox::questionYesNo( this,
        i18n("Do you really want to remove the profile: %1").arg(cProfile->currentText()),
        i18n("Remove profile?") );
    if( ret != KMessageBox::Yes ) return;

    config->removeProfile( cProfile->currentText() );

    sProfile.clear();
    cProfile->clear();
    sProfile += i18n("Very low");
    sProfile += i18n("Low");
    sProfile += i18n("Medium");
    sProfile += i18n("High");
    sProfile += i18n("Very high");
    sProfile += i18n("Lossless");
    sProfile += i18n("Hybrid");
    sProfile += config->getAllProfiles();
    sProfile.remove( i18n("Last used") );
    sProfile.remove( "Last used" );
    sProfile += i18n("User defined");
    cProfile->insertStringList( sProfile );
    profileChanged();
}

void OptionsSimple::formatInfo()
{
    TQString format = cFormat->currentText();

    if( format == "wav" ) {
        KMessageBox::information( this,
            i18n("<p>Wave is a file format, that doesn't compress it's audio data.</p>\n<p>So the quality is very high, but the file size is enormous. It is widely spread and should work with every audio player.</p>\n<a href=\"http://en.wikipedia.org/wiki/Wav\">http://en.wikipedia.org/wiki/Wav</a>"),
            i18n("File format")+": " + format,
            TQString(), KMessageBox::Notify | KMessageBox::AllowLink );
        return;
    }
    else {
        KMessageBox::information( this,
            config->getFormatDescription(format),
            i18n("File format")+": " + format,
            TQString(), KMessageBox::Notify | KMessageBox::AllowLink );
    }
}

void OptionsSimple::profileChanged()
{
    TQString last;

    ConversionOptions options = config->getProfile( cProfile->currentText() );
    if( !options.encodingOptions.sFormat.isEmpty() ) {
        pProfileRemove->show();
        pProfileInfo->hide();
        last = cFormat->currentText();
        cFormat->clear();
        sFormat = options.encodingOptions.sFormat;
        cFormat->insertStringList( sFormat );
        cFormat->setCurrentItem( formatIndex(last) );
        outputDirectory->setMode( options.outputOptions.mode );
        outputDirectory->setDirectory( options.outputOptions.directory );
        optionsDetailed->setCurrentOptions( options );
        return;
    }

    pProfileRemove->hide();
    pProfileInfo->show();

    if( cProfile->currentText() == i18n("Very low") ) {
        last = cFormat->currentText();
        cFormat->clear();
        sFormat = config->allLossyEncodableFormats();
        cFormat->insertStringList( sFormat );
        cFormat->setCurrentItem( formatIndex(last) );
        formatChanged();
        ConvertPlugin* plugin = config->encoderForFormat( cFormat->currentText() );
        if( plugin == 0 ) {
            // FIXME error handling
            //kdDebug() << "NULL POINTER: `" << "OptionsSimple::profileChanged() / Very low" << "'" << endl;
            return;
        }
        if( plugin->enc.lossy.quality.enabled ) {
            optionsDetailed->setQualityMode( i18n("Quality") );
            optionsDetailed->setQuality( 20 );
        }
        else if( plugin->enc.lossy.bitrate.abr.enabled || plugin->enc.lossy.bitrate.cbr.enabled) {
            optionsDetailed->setQualityMode( i18n("Bitrate") );
            optionsDetailed->setQuality( 64 );
        }
        optionsDetailed->setBitrateRangeEnabled( false );
        optionsDetailed->setSamplingrateEnabled( true );
        optionsDetailed->setSamplingrate( 22050 );
        optionsDetailed->setChannelsEnabled( true );
        optionsDetailed->setChannels( i18n("Mono") );
        optionsDetailed->setReplayGainEnabled( true );
        optionsDetailed->setUserOptions( config->binaries[plugin->enc.bin] + " " + plugin->enc.in_out_files );
    }
    else if( cProfile->currentText() == i18n("Low") ) {
        last = cFormat->currentText();
        cFormat->clear();
        sFormat = config->allLossyEncodableFormats();
        cFormat->insertStringList( sFormat );
        cFormat->setCurrentItem( formatIndex(last) );
        formatChanged();
        ConvertPlugin* plugin = config->encoderForFormat( cFormat->currentText() );
        if( plugin == 0 ) {
            // FIXME error handling
            //kdDebug() << "NULL POINTER: `" << "OptionsSimple::profileChanged() / Low" << "'" << endl;
            return;
        }
        if( plugin->enc.lossy.quality.enabled ) {
            optionsDetailed->setQualityMode( i18n("Quality") );
            optionsDetailed->setQuality( 30 );
        }
        else if( plugin->enc.lossy.bitrate.abr.enabled || plugin->enc.lossy.bitrate.cbr.enabled ) {
            optionsDetailed->setQualityMode( i18n("Bitrate") );
            optionsDetailed->setQuality( 96 );
        }
        optionsDetailed->setBitrateRangeEnabled( false );
        optionsDetailed->setSamplingrateEnabled( true );
        optionsDetailed->setSamplingrate( 22050 );
        optionsDetailed->setChannelsEnabled( false );
        optionsDetailed->setReplayGainEnabled( true );
        optionsDetailed->setUserOptions( config->binaries[plugin->enc.bin] + " " + plugin->enc.in_out_files );
    }
    else if( cProfile->currentText() == i18n("Medium") ) {
        last = cFormat->currentText();
        cFormat->clear();
        sFormat = config->allLossyEncodableFormats();
        cFormat->insertStringList( sFormat );
        cFormat->setCurrentItem( formatIndex(last) );
        formatChanged();
        ConvertPlugin* plugin = config->encoderForFormat( cFormat->currentText() );
        if( plugin == 0 ) {
            // FIXME error handling
            //kdDebug() << "NULL POINTER: `" << "OptionsSimple::profileChanged() / Medium" << "'" << endl;
            return;
        }
        if( plugin->enc.lossy.quality.enabled ) {
            optionsDetailed->setQualityMode( i18n("Quality") );
            optionsDetailed->setQuality( 40 );
        }
        else if( plugin->enc.lossy.bitrate.abr.enabled || plugin->enc.lossy.bitrate.cbr.enabled ) {
            optionsDetailed->setQualityMode( i18n("Bitrate") );
            optionsDetailed->setQuality( 192 );
        }
        optionsDetailed->setBitrateRangeEnabled( false );
        optionsDetailed->setSamplingrateEnabled( false );
        optionsDetailed->setChannelsEnabled( false );
        optionsDetailed->setReplayGainEnabled( true );
        optionsDetailed->setUserOptions( config->binaries[plugin->enc.bin] + " " + plugin->enc.in_out_files );
    }
    else if( cProfile->currentText() == i18n("High") ) {
        last = cFormat->currentText();
        cFormat->clear();
        sFormat = config->allLossyEncodableFormats();
        cFormat->insertStringList( sFormat );
        cFormat->setCurrentItem( formatIndex(last) );
        formatChanged();
        ConvertPlugin* plugin = config->encoderForFormat( cFormat->currentText() );
        if( plugin == 0 ) {
            // FIXME error handling
            //kdDebug() << "NULL POINTER: `" << "OptionsSimple::profileChanged() / High" << "'" << endl;
            return;
        }
        if( plugin->enc.lossy.quality.enabled ) {
            optionsDetailed->setQualityMode( i18n("Quality") );
            optionsDetailed->setQuality( 50 );
        }
        else if( plugin->enc.lossy.bitrate.abr.enabled || plugin->enc.lossy.bitrate.cbr.enabled ) {
            optionsDetailed->setQualityMode( i18n("Bitrate") );
            optionsDetailed->setQuality( 240 );
        }
        optionsDetailed->setBitrateRangeEnabled( false );
        optionsDetailed->setSamplingrateEnabled( false );
        optionsDetailed->setChannelsEnabled( false );
        optionsDetailed->setReplayGainEnabled( true );
        optionsDetailed->setUserOptions( config->binaries[plugin->enc.bin] + " " + plugin->enc.in_out_files );
    }
    else if( cProfile->currentText() == i18n("Very high") ) {
        last = cFormat->currentText();
        cFormat->clear();
        sFormat = config->allLossyEncodableFormats();
        cFormat->insertStringList( sFormat );
        cFormat->setCurrentItem( formatIndex(last) );
        formatChanged();
        ConvertPlugin* plugin = config->encoderForFormat( cFormat->currentText() );
        if( plugin == 0 ) {
            // FIXME error handling
            //kdDebug() << "NULL POINTER: `" << "OptionsSimple::profileChanged() / Very high" << "'" << endl;
            return;
        }
        if( plugin->enc.lossy.quality.enabled ) {
            optionsDetailed->setQualityMode( i18n("Quality") );
            optionsDetailed->setQuality( 60 );
        }
        else if( plugin->enc.lossy.bitrate.abr.enabled || plugin->enc.lossy.bitrate.cbr.enabled ) {
            optionsDetailed->setQualityMode( i18n("Bitrate") );
            optionsDetailed->setQuality( 320 );
        }
        optionsDetailed->setBitrateRangeEnabled( false );
        optionsDetailed->setSamplingrateEnabled( false );
        optionsDetailed->setChannelsEnabled( false );
        optionsDetailed->setReplayGainEnabled( true );
        optionsDetailed->setUserOptions( config->binaries[plugin->enc.bin] + " " + plugin->enc.in_out_files );
    }
    else if( cProfile->currentText() == i18n("Lossless") ) {
        last = cFormat->currentText();
        cFormat->clear();
        sFormat = config->allLosslessEncodableFormats();
        sFormat += "wav";
        cFormat->insertStringList( sFormat );
        cFormat->setCurrentItem( formatIndex(last) );
        formatChanged();
        optionsDetailed->setReplayGainEnabled( true );
        ConvertPlugin* plugin = config->encoderForFormat( cFormat->currentText() );
        if( plugin != 0 ) {
            optionsDetailed->setUserOptions( config->binaries[plugin->enc.bin] + " " + plugin->enc.in_out_files );
        }
    }
    else if( cProfile->currentText() == i18n("Hybrid")/* || cProfile->currentText() == "Hybrid"*/ ) {
        last = cFormat->currentText();
        cFormat->clear();
        sFormat = config->allHybridEncodableFormats();
        cFormat->insertStringList( sFormat );
        cFormat->setCurrentItem( formatIndex(last) );
        formatChanged();
        optionsDetailed->setReplayGainEnabled( true );
        ConvertPlugin* plugin = config->encoderForFormat( cFormat->currentText() );
        optionsDetailed->setQualityMode( i18n("Hybrid") );
        if( plugin != 0 ) {
            optionsDetailed->setUserOptions( config->binaries[plugin->enc.bin] + " " + plugin->enc.in_out_files );
        }
    }
    else if( cProfile->currentText() == i18n("User defined") ) {
        last = cFormat->currentText();
        cFormat->clear();
        sFormat = config->allEncodableFormats();
        sFormat += "wav";
        cFormat->insertStringList( sFormat );
        cFormat->setCurrentItem( formatIndex(last) );
        formatChanged();
    }
}

void OptionsSimple::formatChanged()
{
    optionsDetailed->setFormat( cFormat->currentText() );
}

void OptionsSimple::outputDirectoryModeChanged( OutputDirectory::Mode mode )
{
    optionsDetailed->setOutputDirectoryMode( mode );
    if( cProfile->currentText() != i18n("User defined") && config->getAllProfiles().findIndex(cProfile->currentText()) != -1 ) {
        ConversionOptions options = config->getProfile( cProfile->currentText() );
//         if( options.encodingOptions.sFormat.isEmpty() ) return;
        if( outputDirectory->mode() != options.outputOptions.mode || outputDirectory->directory() != options.outputOptions.directory ) {
            cProfile->setCurrentItem( profileIndex(i18n("User defined")) ); // NOTE not refill() ?
            profileChanged();
        }
//         refill();
    }
}

void OptionsSimple::outputDirectoryPathChanged( const TQString& path )
{
    optionsDetailed->setOutputDirectoryPath( path );
    if( cProfile->currentText() != i18n("User defined") && config->getAllProfiles().findIndex(cProfile->currentText()) != -1 ) {
        ConversionOptions options = config->getProfile( cProfile->currentText() );
//         if( options.encodingOptions.sFormat.isEmpty() ) return;
        if( outputDirectory->mode() != options.outputOptions.mode || outputDirectory->directory() != options.outputOptions.directory ) {
            cProfile->setCurrentItem( profileIndex(i18n("User defined")) ); // NOTE not refill() ?
            profileChanged();
        }
//         refill();
    }
}

void OptionsSimple::setCurrentProfile( const TQString& profile )
{
    // TODO check profile (and don't change, if not available)
    cProfile->setCurrentItem( profileIndex(profile) );
    profileChanged();
}

void OptionsSimple::setCurrentFormat( const TQString& format )
{
    cFormat->setCurrentItem( formatIndex(format) );
    formatChanged();
}

// TODO check for errors
void OptionsSimple::setCurrentOutputDirectory( const TQString& directory )
{
    outputDirectory->setMode( OutputDirectory::Specify );
    outputDirectory->setDirectory( directory );
    optionsDetailed->setOutputDirectoryMode( OutputDirectory::Specify );
    optionsDetailed->setOutputDirectoryPath( directory );
}

void OptionsSimple::somethingChanged()
{
    emit optionsChanged();
}

void OptionsSimple::refill()
{
    sProfile.clear();
    cProfile->clear();
    sProfile += i18n("Very low");
    sProfile += i18n("Low");
    sProfile += i18n("Medium");
    sProfile += i18n("High");
    sProfile += i18n("Very high");
    sProfile += i18n("Lossless");
    sProfile += i18n("Hybrid");
    sProfile += config->getAllProfiles();
    sProfile.remove( i18n("Last used") );
    sProfile.remove( "Last used" );
    sProfile += i18n("User defined");
    cProfile->insertStringList( sProfile );

    cProfile->setCurrentItem( profileIndex(config->getProfileName(optionsDetailed->getCurrentOptions())) );

    if( cProfile->currentText() == i18n("Very low") || cProfile->currentText() == i18n("Low") ||
         cProfile->currentText() == i18n("Medium") || cProfile->currentText() == i18n("High") ||
         cProfile->currentText() == i18n("Very high") ) {
        cFormat->clear();
        sFormat = config->allLossyEncodableFormats();
        cFormat->insertStringList( sFormat );
        cFormat->setCurrentItem( formatIndex(optionsDetailed->getFormat()) );
        pProfileInfo->show();
        pProfileRemove->hide();
    }
    else if( cProfile->currentText() == i18n("Lossless") ) {
        cFormat->clear();
        sFormat = config->allLosslessEncodableFormats();
        sFormat += "wav";
        cFormat->insertStringList( sFormat );
        cFormat->setCurrentItem( formatIndex(optionsDetailed->getFormat()) );
        pProfileInfo->show();
        pProfileRemove->hide();
    }
    else if( cProfile->currentText() == i18n("Hybrid") ) {
        cFormat->clear();
        sFormat = config->allHybridEncodableFormats();
        cFormat->insertStringList( sFormat );
        cFormat->setCurrentItem( formatIndex(optionsDetailed->getFormat()) );
        pProfileInfo->show();
        pProfileRemove->hide();
    }
    else if( cProfile->currentText() == i18n("User defined") ) {
        cFormat->clear();
        sFormat = config->allEncodableFormats();
        sFormat += "wav";
        cFormat->insertStringList( sFormat );
        cFormat->setCurrentItem( formatIndex(optionsDetailed->getFormat()) );
        pProfileInfo->show();
        pProfileRemove->hide();
    }
    else {
        ConversionOptions options = config->getProfile( cProfile->currentText() );
        cFormat->clear();
        sFormat = options.encodingOptions.sFormat;
        cFormat->insertStringList( sFormat );
        cFormat->setCurrentItem( formatIndex(optionsDetailed->getFormat()) );
        pProfileInfo->hide();
        pProfileRemove->show();
    }

    outputDirectory->setMode( optionsDetailed->getOutputDirectoryMode() );
    outputDirectory->setDirectory( optionsDetailed->getOutputDirectoryPath() );
}

