/***************************************************************************
*   Copyright (C) 2003-2004 by                                            *
*   Unai Garro (ugarro@users.sourceforge.net)                             *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef _KRECIPES_H_
#define _KRECIPES_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tdeapplication.h>
#include <tdemainwindow.h>

#include "krecipesview.h" //for KrePanel

class KrecipesView;

class KPrinter;
class TDEToggleAction;
class KURL;
class KDialog;
class ConversionDialog;

/**
 * This class serves as the main window for Krecipes.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author $AUTHOR <$EMAIL>
 * @version $APP_VERSION
 */
class Krecipes : public TDEMainWindow
{
	Q_OBJECT
public:
	/**
	 * Default Constructor
	 */
	Krecipes();

	/**
	 * Default Destructor
	 */
	virtual ~Krecipes();


protected:
	/**
	 * Overridden virtuals for TQt drag 'n drop (XDND)
	 */
	virtual void dragEnterEvent( TQDragEnterEvent *event );

protected:
	/**
	 * This function is called when it is time for the app to save its
	 * properties for session management purposes.
	 */
	void saveProperties( TDEConfig * );

	/**
	 * This function is called when this app is restored.  The TDEConfig
	 * object points to the session management config file that was saved
	 * with @ref saveProperties
	 */
	void readProperties( TDEConfig * );

	virtual bool queryClose();


private slots:
	void fileNew();
	void fileOpen();
	void fileSave();
	void fileExport();
	void fileToClipboard();
	void filePrint();
	void optionsShowToolbar();
	void optionsShowStatusbar();
	void optionsConfigureKeys();
	void optionsConfigureToolbars();
	void optionsPreferences();
	void newToolbarConfig();
	void import();
	void kreDBImport();
	void pageSetupSlot();
	void printSetupSlot();
	void conversionToolSlot();
	void backupSlot();
	void restoreSlot();
	void mergeSimilarCategories();
	void mergeSimilarIngredients();

	/**  This function is called whenever a panel is shown or hidden and then sets
	  *  actions as enabled as appropriate.
	  */
	void updateActions( KrePanel panel, bool show );

	void changeStatusbar( const TQString& text );
	void changeCaption( const TQString& text );

private:
	// Private methods
	void setupAccel();
	void setupActions();

private:
	KrecipesView *m_view;

	KPrinter *m_printer;
	TDEToggleAction *m_toolbarAction;
	TDEToggleAction *m_statusbarAction;

private:
	// Internal variables
	TDEAction *saveAction;
	TDEAction *exportAction;
	TDEAction *editAction;
	TDEAction *printAction;
	TDEAction *reloadAction;
	TDEAction *copyToClipboardAction;

	KDialog *parsing_file_dlg;
	ConversionDialog *convertDialog;

	TQValueList<TDEAction*> recipe_actions;

private slots:
	void enableSaveOption( bool en = true );
	void recipeSelected( bool );
};

#endif // _KRECIPES_H_
