/***************************************************************************
 *   Copyright (C) 2012 by Timothy Pearson                                 *
 *   kb9vqf@pearsoncomputing.net                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _LDAPCONTROLLER_H_
#define _LDAPCONTROLLER_H_

#include <tdecmodule.h>
#include <tdeaboutdata.h>
#include <kpushbutton.h>
#include <tdelistview.h>
#include <tdefileitem.h>
#include <tdeglobalsettings.h>
#include <tqpushbutton.h>
#include <tqcombobox.h>
#include <tqtimer.h>
#include <tdeio/jobclasses.h>

#include <libtdeldap.h>

class LDAPControllerConfigBase;

enum sc_command {
	SC_START,
	SC_STOP,
	SC_RESTART,
	SC_PURGE,
	SC_SETDBPERMS
};

class LDAPController: public TDECModule
{
	Q_OBJECT

	public:
		LDAPController( TQWidget *parent=0, const char *name=0, const TQStringList& = TQStringList() );
		~LDAPController();
		
		virtual void load();
		virtual void save();
		virtual void defaults();
		virtual int buttons();
		virtual TQString quickHelp() const;
		virtual const TDEAboutData *aboutData() const { return myAboutData; };

	public:
		int createNewLDAPRealm(TQWidget* dialogparent, LDAPRealmConfig realmconfig, TQString adminUserName, TQString adminGroupName, TQString machineAdminGroupName, TQString standardUserGroupName, const char * adminPassword, TQString rootUserName, const char * rootPassword, TQString adminRealm, LDAPCertConfig certinfo, TQString *errstr);
		int createNewSecondaryController(TQWidget* dialogparent, LDAPRealmConfig realmconfig, TQString adminUserName, const char * adminPassword, TQString adminRealm, TQString *errstr);

	private slots:
		void systemRoleChanged();
		void processLockouts();
		void updateCertDisplay();

		void btncaSetMaster();
		void btncaRegenerate();
		void btncaExportKey();
		void btncaExportCert();
		void btnkrbRegenerate();
		void btnkrbExportKey();
		void btnkrbExportCert();
		void btnldapRegenerate();
		void btnldapExportKey();
		void btnldapExportCert();
		void btncrlRegenerate();
		void slotCertCopyResult(TDEIO::Job*);

		void btnChangeLDAPRootPassword();
		void btnChangeRealmAdminPassword();

		void btnAddMultiMasterReplicationMapping();
		void btnEditMultiMasterReplicationMapping();
		void btnRemoveMultiMasterReplicationMapping();

		void multiMasterReplicationHighlighted();
		void modifySelectedMultiMasterReplication();

		void caCertExpiryChanged();
		void caCrlExpiryChanged();
		void kerberosCertExpiryChanged();
		void ldapCertExpiryChanged();

	private:
		int controlKAdminDaemon(sc_command command);
		int controlSASLServer(sc_command command);
		int controlHeimdalServer(sc_command command, uid_t userid=-1, gid_t groupid=-1);
		int controlLDAPServer(sc_command command, uid_t userid=-1, gid_t groupid=-1);
		int initializeNewKerberosRealm(TQString realmName, TQString *errstr);
		int addLDAPEntryToKerberosRealm(TQString ldapProcessOwnerName, TQString ldapHost, TQString *errstr);
		int addHostEntryToKerberosRealm(TQString kerberosHost, TQString *errstr);
		int setKerberosPasswordForUser(LDAPCredentials user, TQString *errstr);
		int createRealmCertificates(LDAPCertConfig certinfo, LDAPRealmConfig realmconfig, uid_t ldap_uid, gid_t ldap_gid);
		int uploadKerberosCAFileToLDAP(LDAPManager* ldap_mgr, TQString* errstr=0);
		int uploadKerberosCAKeyFileToLDAP(LDAPManager* ldap_mgr, TQString* errstr=0);

	private:
		TDEAboutData *myAboutData;

		LDAPControllerConfigBase *m_base;
		KSimpleConfig *m_systemconfig;

		TQString m_fqdn;
		int m_prevRole;
		bool m_roleFullyConfigured;
		TQString m_ldapUserName;
		TQString m_ldapGroupName;

		LDAPCertConfig m_certconfig;
		TQString m_defaultRealm;
		LDAPRealmConfigList m_realmconfig;

		TQTimer m_certRefreshTimer;
};

#endif // _LDAPCONTROLLER_H_
