/***************************************************************************
                          io_engine.h  -  description
                             -------------------
    begin                : Sat Jun 30 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef IO_ENGINE_H
#define IO_ENGINE_H

#include <tqstring.h>
#include <tqvaluelist.h>
#include "io_base.h"

/**
  *@author Troy Corbin Jr.
  */

class TQFile;
class TDEProcess;
class resource;
class proto_base;

class io_engine : public io_base
{
  Q_OBJECT
  
	public:
													io_engine( TQWidget *parent=NULL, resource *Rsrc=0 );
													~io_engine();

		void									Start( const int side );

	public slots:
		virtual void					recvCMD( const Command& command );
		void									recvProtoCMD( const Command& command );
		void									SendClear( TDEProcess* );
		void									Recv( TDEProcess*, char*, int );

	signals:
		virtual void					sendCMD(const Command& command);

	protected slots:
		void									sendToChild( void );
		void									WriteFIFO( const TQString &Data );

	protected:
		void									Kill( void );

	private:

		engineList::Iterator	IT;
		proto_base						*proto;

		/* States */
		bool									SafeToSend;
		bool									SendSIGINT;
		bool									CleanBuffer;
		bool									Forced;

		/* References */
		TQFile									*Log;
		int										Protocol;
		ChessMove							Move;

		/* Data */
		TDEProcess							*engine;
		TQString								FIFO_In;
		TQString								FIFO_Out;
};

#endif
