/***************************************************************************
 *   Copyright (C) 2007 Nicolas Hadacek <hadacek@kde.org>                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "console.h"

#include <tqlayout.h>
#include <tqlabel.h>
#include <tqdir.h>
#include <klibloader.h>
#include <tdelocale.h>
#include <tdeparts/part.h>
#include <kde_terminal_interface.h>

ConsoleView::ConsoleView(TQWidget *parent)
  : TQWidget(parent, "console_view"), _initialized(false)
{}

void ConsoleView::showEvent(TQShowEvent *e)
{
  if ( !_initialized ) {
    _initialized = true;
    KLibFactory *factory = KLibLoader::self()->factory("libkonsolepart");
    TQVBoxLayout *top = new TQVBoxLayout(this, 0, 10);
    if ( factory==0 ) {
      TQLabel *label = new TQLabel(i18n("Could not find \"konsolepart\"; please install tdebase."), this);
      label->show();
      top->addWidget(label);
      return;
    } else {
      TQWidget *pwidget = static_cast<KParts::Part *>(factory->create(TQT_TQOBJECT(this), "konsole"))->widget();
      pwidget->show();
      top->addWidget(pwidget);
      setFocusProxy(pwidget);
    }
  }
  TQWidget::showEvent(e);
}
