/***************************************************************************
 *   Copyright (C) 2006 Nicolas Hadacek <hadacek@kde.org>                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "container.h"

#include "misc_gui.h"

//----------------------------------------------------------------------------
Container::Container(TQWidget *parent, Type type)
  : TQFrame(parent), _type(type)
{
  initLayout();
}

Container::Container(TQWidgetStack *stack, uint index, Type type)
  : TQFrame(stack), _type(type)
{
  initLayout();
  stack->addWidget(this, index);
}

Container::Container(TQTabWidget *tabw, const TQString &title, Type type)
  : TQFrame(tabw), _type(type)
{
  initLayout();
  tabw->addTab(this, title);
}

void Container::setFrame(Type type)
{
  _type = type;
  switch (type) {
  case Flat:
    setMargin(parent() && parent()->inherits(TQTABWIDGET_OBJECT_NAME_STRING) ? 10 : 0);
    setFrameStyle(TQFrame::NoFrame);
    break;
  case Sunken:
    setMargin(10);
    setFrameStyle(TQFrame::StyledPanel | TQFrame::Sunken);
    break;
  }
}

void Container::initLayout()
{
  _topLayout = new TQGridLayout(this, 1, 1, 0, 10);
  _gridLayout = new TQGridLayout(1, 1, 10);
  _topLayout->addLayout(_gridLayout, 0, 0);
  _topLayout->setRowStretch(1, 1);
  setFrame(_type);
}

void Container::addWidget(TQWidget *w, uint startRow, uint endRow, uint startCol, uint endCol, int alignment)
{
  Q_ASSERT( startRow<=endRow );
  Q_ASSERT( startCol<=endCol );
  w->show();
  _gridLayout->addMultiCellWidget(w, startRow, endRow, startCol, endCol, alignment);
}

void Container::addLayout(TQLayout *l, uint startRow, uint endRow, uint startCol, uint endCol, int alignment)
{
  Q_ASSERT( startRow<=endRow );
  Q_ASSERT( startCol<=endCol );
  _gridLayout->addMultiCellLayout(l, startRow, endRow, startCol, endCol, alignment);
}

//----------------------------------------------------------------------------
ButtonContainer::ButtonContainer(const TQString &title, TQWidget *parent)
  : Container(parent, Sunken)
{
  _button = new PopupButton(title, this);
  addWidget(_button, 0,0, 0,1);
  setColStretch(2, 1);
}
