#include <tqradiobutton.h>
#include <tqslider.h>
#include <tqspinbox.h>  
#include <tqcheckbox.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tdelocale.h>
#include <tdefiledialog.h>
#include <kurlrequester.h>
#include <tqtoolbutton.h>
#include <klineedit.h>
#include <kstandarddirs.h>

#include "dbseprefwidget.h"
#include "preferenceswidget.h"

PreferencesWidget::PreferencesWidget(TQWidget *parent, const char* name)
		: PrefWidget(parent,name)
{
	TQVBoxLayout *layout = new TQVBoxLayout(this);
//	TQLabel *label = new TQLabel(i18n("Settings for TDE database search engine"),this);
//	layout->addWidget(label);

	dbpw = new DBSearchEnginePref(this);
	dbpw->dirInput->setMode(KFile::Directory | KFile::LocalOnly);
	
	layout->addWidget(dbpw);
	resize(TQSize(200,200).expandedTo(minimumSizeHint()));

//    connect(dbpw->browseTB_3,TQT_SIGNAL(clicked()),TQT_SLOT(browse1()));

    emit restoreNow();   //Fill with actual params.			

}

PreferencesWidget::~PreferencesWidget()
{
}

void PreferencesWidget::apply()
{
emit applyNow();
}

void PreferencesWidget::cancel()
{
emit restoreNow();
}

void PreferencesWidget::standard()
{


dbpw->caseSensitiveCB->setChecked(false);
dbpw->normalizeCB->setChecked(true);
dbpw->removeContextCB->setChecked(true);

dbpw->oneWordSubCB->setChecked(true);
dbpw->twoWordSubCB->setChecked(false);


dbpw->RegExpRB->setChecked(false);
dbpw->normalTextRB->setChecked(true);
dbpw->equalCB->setChecked( true );
dbpw->containsCB->setChecked( true);
dbpw->containedCB->setChecked( true );
 
 
dbpw->oneWordSubSB->setValue(20);
dbpw->twoWordSubSB->setValue(8);

dbpw->maxSB->setValue(500);
dbpw->thresholdSL->setValue(50);
dbpw->thresholdOrigSL->setValue(50);

dbpw->allRB->setChecked( false);
dbpw->slistRB->setChecked( true);
dbpw->rlistRB->setChecked( false );
	
dbpw->nothingCB->setChecked(true); 
dbpw->freqSB->setValue(300);
 
dbpw->ignoreLE->setText("&.:");
 
dbpw->autoAddCB_2->setChecked(true);

TQString defaultDir;
 TDEStandardDirs * dirs = TDEGlobal::dirs();
 if(dirs)
 {
     defaultDir = dirs->saveLocation("data");
     if(defaultDir.right(1)!="/")
         defaultDir+="/";
     defaultDir += "kbabeldict/dbsearchengine";
 }
 
 dbpw->dirInput->setURL(defaultDir); 
}

void PreferencesWidget::setName(TQString n)
{
dbpw->filenameLB->setText(i18n("Scanning file: %1").arg(n));
}

void PreferencesWidget::setEntries(int i)
{
dbpw->entriesLB->setText(i18n("Entries added: %1").arg(i));

}

#include "preferenceswidget.moc"
