/*
    behaviorconfig.h  -  Kopete Look Feel Config

    Kopete    (c) 2002-2005 by the Kopete developers  <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef __BEHAVIOR_H
#define __BEHAVIOR_H

#include "tdecmodule.h"

namespace Kopete
{
class Away;
}

class TQFrame;
class TQTabWidget;

class BehaviorConfig_General;
class BehaviorConfig_Events;
class BehaviorConfig_Chat;
class KopeteAwayConfigBaseUI;
class KPluginInfo;

class BehaviorConfig : public TDECModule
{
	Q_OBJECT
  

	public:
		BehaviorConfig(TQWidget *parent, const char *  name , const TQStringList &args) ;

		virtual void save();
		virtual void load();

	private slots:
		void slotSettingsChanged(bool);
		void slotValueChanged(int);
		void slotUpdatePluginLabel(int);
		void slotTextChanged(const TQString&);

	private:
		TQTabWidget* mBehaviorTabCtl;
		BehaviorConfig_General *mPrfsGeneral;
		BehaviorConfig_Events *mPrfsEvents;
		BehaviorConfig_Chat *mPrfsChat;
		KopeteAwayConfigBaseUI *mAwayConfigUI;
		TQValueList<KPluginInfo*> viewPlugins;
		Kopete::Away* awayInstance;
};
#endif
