require 'Qt'

class CannonField < TQt::Widget
	signals 'angleChanged(int)'
	slots 'setAngle(int)'
	
	def initialize(parent, name)
		super
		@ang = 45
    	setPalette( TQt::Palette.new( TQt::Color.new( 250, 250, 200) ) )
	end

	def setAngle( degrees )
		if degrees < 5
			degrees = 5
		elsif degrees > 70
        	degrees = 70
		end
		if @ang == degrees
			return
		end
		@ang = degrees
		repaint()
		emit angleChanged( @ang )
	end

	def paintEvent( event )
		p = TQt::Painter.new( self )

		p.setBrush( blue )
		p.setPen( TQt::NoPen )
		p.translate( 0, rect().bottom() )
		p.drawPie( TQt::Rect.new(-35, -35, 70, 70), 0, 90*16 )
		p.rotate( - @ang )
		p.drawRect( TQt::Rect.new(33, -4, 15, 8) )
		p.end()		
	end


	def sizePolicy()
    	return TQt::SizePolicy.new( TQt::SizePolicy::Expanding, TQt::SizePolicy::Expanding )
	end
end
