/***************************************************************************
                          radiobutton.cpp - Radiobutton class 
                             -------------------
    copyright            : (C) 2002 by Marc Britton
    email                : consume@optusnet.com.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/* KDE INCLUDES */

/* QT INCLUDES */
#include <tqobject.h>
#include <tqstring.h>
#include <tqwidget.h>
#include <tqstringlist.h>
#include <tqevent.h>
#include <tqradiobutton.h>

/* OTHER INCLUDES */
#include <specials.h>
#include "radiobutton.h"

RadioButton::RadioButton(TQWidget *a_parent, const char *a_name)
  : TQRadioButton(a_parent, a_name), KommanderWidget(TQT_TQOBJECT(this))
{
  TQStringList states;
  states << "unchecked";
  states << "checked";
  setStates(states);
  TQStringList displayStates;
  displayStates << "checked";
  displayStates << "unchecked";
  setDisplayStates(displayStates);
}

RadioButton::~RadioButton()
{
}

TQString RadioButton::currentState() const
{
  return (isChecked() ? "checked" : "unchecked");
}

bool RadioButton::isKommanderWidget() const
{
  return true;
}

TQStringList RadioButton::associatedText() const
{
  return KommanderWidget::associatedText();
}

void RadioButton::setAssociatedText(const TQStringList& a_at)
{
  KommanderWidget::setAssociatedText(a_at);
}

void RadioButton::setWidgetText(const TQString &a_text)
{
  setText(a_text);
  emit widgetTextChanged(a_text);
}

void RadioButton::setPopulationText(const TQString& a_text)
{
  KommanderWidget::setPopulationText( a_text );
}

TQString RadioButton::populationText() const
{
  return KommanderWidget::populationText();
}

void RadioButton::populate()
{
  TQString txt = KommanderWidget::evalAssociatedText( populationText() );
  setWidgetText( txt );
}

void RadioButton::showEvent( TQShowEvent *e )
{
    TQRadioButton::showEvent( e );
    emit widgetOpened();
}

void RadioButton::contextMenuEvent( TQContextMenuEvent * e )
{
  e->accept();
  TQPoint p = e->globalPos();
  emit contextMenuRequested(p.x(), p.y());
}

bool RadioButton::isFunctionSupported(int f)
{
  return f == DCOP::text || f == DCOP::setText || f == DCOP::setChecked || f == DCOP::checked || f == DCOP::geometry || f == DCOP::getBackgroundColor || f == DCOP::setBackgroundColor;
}

TQString RadioButton::handleDCOP(int function, const TQStringList& args)
{
  switch (function) {
    case DCOP::text:
      return text();
    case DCOP::setText:
      setWidgetText(args[0]);
      break;
    case DCOP::setChecked:
      setChecked(args[0] != "false");
      break;
    case DCOP::checked:
      return TQString::number(isOn());
    case DCOP::geometry:
    {
      TQString geo = TQString::number(this->x())+" "+TQString::number(this->y())+" "+TQString::number(this->width())+" "+TQString::number(this->height());
      return geo;
      break;
    }
    case DCOP::getBackgroundColor:
      return this->paletteBackgroundColor().name();
      break;
    case DCOP::setBackgroundColor:
    {
      TQColor color;
      color.setNamedColor(args[0]);
      this->setPaletteBackgroundColor(color);
      break;
    }
    default:
      return KommanderWidget::handleDCOP(function, args);
  }
  return TQString();
}



#include "radiobutton.moc"
